/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/DaytimeTradeInitTick.cs#6 $
 * $DateTime$
 * 
 * DaytimeTradeŕATickf[^W߂iK̏ԂB
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;


using Bellagio.Values;

#if UNITTEST
using NUnit.Framework;
#endif


namespace Bellagio.Data {
    public class IntraDayTradeInitTick : StockPrimaryDataInitializer {
        private IntraDayTrade _intraDayTrade;
        private int _initialTickIndex; //ڑuԂ̍ŐVIndexBɃZbgs
        private int _firstEmptyIndex;  //҂Ăindex
        private TimeAndSales _timeAndSales;  //߂ׂf[^̖{
        private TimeAndSales _extraTimeAndSales; //_initialTickIndexȍ~̃f[^sėĂ܂Ƃ߂ĂBRv[gɃ}[WB
        private bool _completedAndDisposed;

        public IntraDayTradeInitTick(IntraDayTrade dt)
            : base(dt) {
            _intraDayTrade = dt;
        }
        public IntraDayTrade IntraDayTrade {
            get {
                return _intraDayTrade;
            }
        }

        public void Initialize(int tickCount) {
            _initialTickIndex = tickCount; //0tickCount-1܂ł_timeAndSalesɖ߂̂ڕWƂȂ 0ĂIsCompletedtrueɂȂ邱Ƃɒ
            _timeAndSales = new TimeAndSales();
            _extraTimeAndSales = new TimeAndSales();
            _firstEmptyIndex = 0;
            _completedAndDisposed = false;
        }

        public void AddTick(int index, int time, int price, int volume) {
            AddTick(index, time, price, volume, 0); //vwap̓IvVi
        }
        public void AddTick(int index, int time, int price, int volume, double vwap) {
            Debug.Assert(!_completedAndDisposed);
            if(index==_firstEmptyIndex) { //擪痈ĂԁB͌S
                _timeAndSales.Add(time, price, volume, TickItaRelation.Unknown);
                _firstEmptyIndex++;
                Debug.Assert(_firstEmptyIndex==_timeAndSales.Count);
            }
            else if(index==_initialTickIndex + _extraTimeAndSales.Count) { //ǉĂ܂
                _extraTimeAndSales.Add(time, price, volume, TickItaRelation.Unknown);
            }
            else //ȊO͔F߂Ȃ
                throw new BellagioException(String.Format("Unexpected tick index {0}, collected={1}", index, _firstEmptyIndex));
        }

        public override bool IsCompleted {
            get {
                return _completedAndDisposed || _firstEmptyIndex==_initialTickIndex;
            }
        }

        //ʂTimeAndSales𓾂B͂P񂵂ĂׂȂjIȂ̂ŒӁBIsCompletedŊmF邱Ƃ͉\
        internal TimeAndSales CompleteAndDispose() {
            Debug.Assert(!_completedAndDisposed);
            for(int i=0; i<_extraTimeAndSales.Count; i++)
                _timeAndSales.Add(_extraTimeAndSales.TickAt(i));
            TimeAndSales ts = _timeAndSales;
            _timeAndSales = null; //ƂBnullZbgGC
            _completedAndDisposed = true;
            return ts;
        }
        
        public override void CompleteInitialization() {
            TimeAndSales ts = CompleteAndDispose();

            int last_confirmed_time; //TickDataɓĂŏI(P)
            if(ts.Count==0)
                last_confirmed_time = MarketOpenTimeRange.GetFor(_intraDayTrade.Stock).StartTimeAt(0);
            else {
                last_confirmed_time = ts.LastTick.Time;
                last_confirmed_time -= last_confirmed_time % 60; //Pʐ؂̂

                //ʒmɂ镪sĂȂ炻D悷邪A̎Ԃ߂邱Ƃ͂ȂB
                //̏̓CujOZbVނƕGɂȂ
                int current = BellagioRoot.TimeManager.Current.AsMinutelyInt();
                if(_intraDayTrade.Stock.Profile is DerivativeStockProfile && current >= 3600*16) {
                    //16߂̐敨́uv19Ƃ
                    current -= 3600*12;
                    if(last_confirmed_time < current) {
                        last_confirmed_time = current;
                        last_confirmed_time = Math.Min(last_confirmed_time, MarketUtil.GetEveningCloseTime(_intraDayTrade.Stock.Market).AsInt());
                    }
                }
                else {
                    if(last_confirmed_time < current) {
                        last_confirmed_time = current;
                        last_confirmed_time = Math.Min(last_confirmed_time, MarketUtil.GetGobaCloseTime(_intraDayTrade.Stock.Market).AsInt());
                    }
                }
            }

            _intraDayTrade.ResetByTimeAndSales(ts, new BTime(last_confirmed_time));
            //ԍXV
            BellagioRoot.DataSubscriberManager.AddPeriodicalSubscriber(_intraDayTrade);
        }

        public int ReceivedCount {
            get {
                return _timeAndSales.Count;
            }
        }
    }

#if UNITTEST
    [TestFixture]
    public class DaytimeTradeInitTickTest {
        [Test]
        public void Normal() {
            IntraDayTradeInitTick t = new IntraDayTradeInitTick(null);
            t.Initialize(3);
            Assert.IsFalse(t.IsCompleted);
            int time = new BTime(9, 0, 0).AsInt();
            t.AddTick(0, time, 100, 1000);
            Assert.IsFalse(t.IsCompleted);
            t.AddTick(1, time, 100, 1000);
            Assert.IsFalse(t.IsCompleted);
            t.AddTick(2, time, 100, 1000);
            Assert.IsTrue(t.IsCompleted);

            TimeAndSales ts = t.CompleteAndDispose();
            Assert.AreEqual(3, ts.Count);
            Assert.IsTrue(t.IsCompleted);
        }
        [Test]
        public void Empty() {
            IntraDayTradeInitTick t = new IntraDayTradeInitTick(null);
            t.Initialize(0);
            Assert.IsTrue(t.IsCompleted);

            TimeAndSales ts = t.CompleteAndDispose();
            Assert.AreEqual(0, ts.Count);
            Assert.IsTrue(t.IsCompleted);
        }
        [Test]
        public void WithExtra() {
            IntraDayTradeInitTick t = new IntraDayTradeInitTick(null);
            t.Initialize(3);
            int time = new BTime(9, 0, 0).AsInt();
            t.AddTick(3, time, 100, 1000); //sĂRԂP[X
            Assert.IsFalse(t.IsCompleted);
            for(int i=0; i<3; i++)
                t.AddTick(i, time, 100, 1000);
            Assert.IsTrue(t.IsCompleted);

            TimeAndSales ts = t.CompleteAndDispose();
            Assert.AreEqual(4, ts.Count); //ǉƂ킹ĂS
            Assert.IsTrue(t.IsCompleted);
        }

        //OOK
        private void ConfirmException(VoidVoidDelegate body) {
            bool e = false;
            try {
                body();
            }
            catch(BellagioException) {
                e = true;
            }
            Assert.IsTrue(e);
        }
        [Test]
        public void Errors() {
            IntraDayTradeInitTick t = new IntraDayTradeInitTick(null);
            t.Initialize(3);
            int time = new BTime(9, 0, 0).AsInt();
            ConfirmException(delegate() { t.AddTick(1, time, 100, 1000); }); //indexƂщz

            t = new IntraDayTradeInitTick(null);
            t.Initialize(3);
            time = new BTime(9, 0, 0).AsInt();
            ConfirmException(delegate() { t.AddTick(4, time, 100, 1000); }); //s̃G[

            t = new IntraDayTradeInitTick(null);
            t.Initialize(3);
            time = new BTime(9, 0, 0).AsInt();
            t.AddTick(0, time, 100, 1000);
            ConfirmException(delegate() { t.AddTick(0, time, 100, 1000); }); //dԍ
        }
    }
#endif
}
