/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/RuntimeIndicator.cs#11 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * XL[}Ƃɍ쐬sindicator
 */
using System;
using System.Collections;
using System.Drawing;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Environment;
using Bellagio.Drawing;
using Bellagio.Values;

using Travis.ORT;
using Travis.Collections;

using Poderosa;

namespace Bellagio.Chart {
    //CWP[^\ꏊ@ŏenumNXɃAbvO[h
    public class IndicatorLocation {
        private delegate string FigureFormatter(double value);

        //IV[^łgȂôŕʃNX悢̂
        private FigureFormatter _figureFormatter;
        private bool _isOscillator;
        private bool _valueCheckRequired; //őEŏl𒲂ׂĂłȂValueTranslatorȂ̂ǂ
        private bool _isSymmetric; //O𒆐SƂΏ̌`ł邩ǂ
        private double _minValue;
        private string _minValueString;
        private double _maxValue;
        private string _maxValueString;

        //ÕRXgN^͂Ȃ
        private IndicatorLocation(FigureFormatter ff, bool oscillator, bool valueCheckRequired, bool symmetric) {
            _figureFormatter = ff;
            _isOscillator = oscillator;
            _valueCheckRequired = valueCheckRequired;
            _isSymmetric = symmetric;
        }
        public string FormatForFigure(double value) {
            return _figureFormatter(value);
        }
        public double MinValue {
            get {
                return _minValue;
            }
        }
        public double MaxValue {
            get {
                return _maxValue;
            }
        }
        public string MinValueString {
            get {
                return _minValueString;
            }
        }
        public string MaxValueString {
            get {
                return _maxValueString;
            }
        }

        private IndicatorLocation InitFixedOscillator(double min, string mins, double max, string maxs) {
            Debug.Assert(!_valueCheckRequired); //肵ĂIV[^ɂ̂ݒʗp
            _minValue = min;
            _minValueString = mins;
            _maxValue = max;
            _maxValueString = maxs;
            return this;
        }

        //O%͎gȂ̂pőpB܂ŝsymmetric̈Ӗ
        public static IndicatorLocation Chart { get { return _chart; } }
        public static IndicatorLocation Volume { get { return _volume; } }
        public static IndicatorLocation Figure { get { return _figure; } }
        public static IndicatorLocation Os100p { get { return _os100p; } } //0-100̊Ԃ^CṽIV[^
        public static IndicatorLocation Os100ps { get { return _os100ps; } } //-100-100̊Ԃ^CṽIV[^
        public static IndicatorLocation Os0ps { get { return _os0ps; } } //0𒆐SƂp[Zg\
        public static IndicatorLocation Os0s { get { return _os0s; } }

        private static IndicatorLocation _chart;
        private static IndicatorLocation _volume;
        private static IndicatorLocation _figure;
        private static IndicatorLocation _os100p;
        private static IndicatorLocation _os100ps;
        private static IndicatorLocation _os0ps;
        private static IndicatorLocation _os0s;
        private static IndicatorLocation _os0;

        static IndicatorLocation() {
            FigureFormatter f2 = delegate(double value) { return value.ToString("F2"); };
            FigureFormatter f2_100 = delegate(double value) { return (value*100).ToString("F2"); };
            FigureFormatter f2_100p = delegate(double value) { return String.Format("{0:F2}%", value*100); };

            _chart = new IndicatorLocation(f2, false, true, false);
            _volume = new IndicatorLocation(f2, false, true, false);
            _figure = new IndicatorLocation(f2, false, false, false);
            _os100p = new IndicatorLocation(f2_100, true, false, false).InitFixedOscillator(0, "0%", 1, "100%");
            _os100ps = new IndicatorLocation(f2_100, true, false, true).InitFixedOscillator(-1, "-100%", 1, "100%");
            _os0ps = new IndicatorLocation(f2_100p, true, true, true);
            _os0s = new IndicatorLocation(f2, true, true, true);
            _os0  = new IndicatorLocation(f2, true, true, false);
        }

        public bool IsOscillator {
            get {
                return _isOscillator;
            }
        }
        public bool ValueCheckRequired {
            get {
                return _valueCheckRequired;
            }
        }
        public bool IsSymmetric {
            get {
                return _isSymmetric;
            }
        }

        public static IndicatorLocation Parse(IORText text) {
            string value = text.Value;
            if(value=="chart")
                return _chart;
            else if(value=="volume")
                return _volume;
            else if(value=="figure")
                return _figure;
            else if(value=="os100%")
                return _os100p;
            else if(value=="os100%s")
                return _os100ps;
            else if(value=="os0%s")
                return _os0ps;
            else if(value=="os0s")
                return _os0s;
            else if(value=="os0")
                return _os0;
            else
                throw new BellagioException(String.Format("{0} {1} location̒lƂĕsł", text.LocationString, text.Value));
        }

    }


    public class RuntimeIndicator : IDisposable, IEnumerable<RuntimeIndicatorElement> {
        private IndicatorSchema _schema;
        private bool _creationCompleted; //쐬tOB͕ύXs\ȍڂ
        private bool _sharesAppearance; //appearanceElementԂŋL邩ǂ
        private string _label;
        private IndicatorLocation _location;
        private List<RuntimeIndicatorElement> _elements;
        private EvaluatorBuildContextWithArgs _argContext;
        private ISpecialIndicatorPaint _specialPaint; //`Ƃ͂ꂪZbg
        private RuntimeOscillatorGroup _oscillatorGroup; //IV[^łƂ̂ݐݒ肳

        public RuntimeIndicator(IndicatorSchema schema, string label, IndicatorLocation loc, EvaluatorBuildContextWithArgs args, ISpecialIndicatorPaint special_paint) {
            _schema = schema;
            _creationCompleted = false;
            _elements = new List<RuntimeIndicatorElement>();
            _argContext = args;
            _location = loc;
            _label = label;
            _specialPaint = special_paint;
        }
        public int ElementCount {
            get {
                return _elements.Count;
            }
        }
        public bool CreationComplted {
            get {
                return _creationCompleted;
            }
        }
        public IndicatorSchema SourceSchema {
            get {
                return _schema;
            }
        }
        public IndicatorLocation Location {
            get {
                return _location;
            }
        }
        public EvaluatorBuildContextWithArgs EvaluatorContext {
            get {
                return _argContext;
            }
        }
        public ISpecialIndicatorPaint SpecialIndicatorPaint {
            get {
                return _specialPaint;
            }
        }
        public string Label {
            get {
                return _label;
            }
            set {
                Debug.Assert(!_creationCompleted);
                _label = value;
            }
        }
        public bool SharesAppearance {
            get {
                return _sharesAppearance;
            }
            set {
                Debug.Assert(!_creationCompleted);
                _sharesAppearance = value;
            }
        }

        public RuntimeOscillatorGroup OscillatorGroup {
            get {
                return _oscillatorGroup;
            }
        }


        //XL[}̃CX^Xł̂ݎgp
        public void SetParentOscillatorGroup(RuntimeOscillatorGroup og) {
            Debug.Assert(!_creationCompleted);
            _oscillatorGroup = og;
        }

        //RuntimeIndicatorElement̃RXgN^Ă
        public void AddElement(RuntimeIndicatorElement e, IndicatorDefinition.Element s) {
            Debug.Assert(!_creationCompleted);
            _elements.Add(e);
            if(_specialPaint!=null) _specialPaint.AddElement(e, s);
        }

        IEnumerator IEnumerable.GetEnumerator() {
            return _elements.GetEnumerator();
        }
        IEnumerator<RuntimeIndicatorElement> IEnumerable<RuntimeIndicatorElement>.GetEnumerator() {
            return _elements.GetEnumerator();
        }
        public RuntimeIndicatorElement ElementAt(int index) {
            return _elements[index];
        }
        public void CompleteCreation() {
            if(_specialPaint!=null)
                _specialPaint.CheckComplete();
            _creationCompleted = true;
        }
        public void ReloadPreference(ChartPreferenceUpdateInfo info, IndicatorValueCache valueCache, StringWithParameterParser parser) {
            if(info.UpdatedParameters || info.ContainsLocalIndicator(_schema.name.ParseMandatoryString())) {
                if(info.UpdatedParameters) {
                    //p[^BV[]͔z̃GgŃIuWFNgƂċLĂ̂ŁǍʂ΂悢
                    BV[] newargs = _argContext.EvalArguments();
                    BV[] targets = _elements[0].Evaluator.Args;
                    Debug.Assert(newargs.Length==targets.Length);
                    for(int i=0; i<targets.Length; i++)
                        targets[i] = newargs[i];
                }

                for(int i=0; i<_elements.Count; i++) {
                    RuntimeIndicatorElement elem = _elements[i];
                    if(info.UpdatedAppearance) {
                        IDynamicPreferenceItem pi = _schema.AppearancePreferences[_sharesAppearance? 0 : i];
                        elem.BPenStyle = BPenStyle.Parse(pi.Value);
                    }
                    if(info.UpdatedParameters || info.UpdatedLabel) {
                        elem.BuildSelective(parser, info.UpdatedLabel, false);
                        if(info.UpdatedParameters) valueCache.ClearByIndicatorIndex(elem.Index);
                    }
                }

            }
        }

        public int FutureLength {
            get {
                int r = 0;
                foreach(RuntimeIndicatorElement e in _elements)
                    if(e.Visible)
                        r = Math.Max(r, e.FutureLength);
                return r;
            }
        }
        public bool VisibleAny { //PłVisibleȂ
            get {
                foreach(RuntimeIndicatorElement e in _elements)
                    if(e.Visible) return true;
                return false;
            }
        }
        public void SetVisible(bool value) {
            foreach(RuntimeIndicatorElement e in _elements) e.Visible = value;
        }

        public void Dispose() {
            foreach(RuntimeIndicatorElement e in _elements) e.Dispose();
        }
        private void ClearPen() {
            foreach(RuntimeIndicatorElement e in _elements) e.ClearPen();
        }

    }

    //l̒@
    public enum FigureAdjustment {
        None,  //Ȃ
        Price  //Œl^ꂽł͊
    }

    //`[gindicator
    public class RuntimeIndicatorElement : IDisposable {
        private int _localIndex; //RuntimeIndicatorł̃CfbNX
        private int _index; //RuntimeIndicatorSet̑SGg̒ʂԍ
        private ORText _labelExpr; //x(ȗɂǂ玝Ă邩Ȃǂ̎dlGȂ߂Ƀ[JRs[j
        private string _label; //RpCς
        private bool _focused;
        private bool _visible; //^CŐݒł邪AUI̓sIndicatorPʂɂȂ邱Ƃ
        private BPenStyle _penStyle; //`p^[FȊÔƂ͖l
        private StandAloneEvaluator _evaluator;
        private RuntimeIndicator _container; //Rei
        private FigureAdjustment _figureAdjustment;
        private StandAloneEvaluator _futureLengthEvaluator; //̈̒
        private int _futureLength; //̈̒(vZς)
        private PolyPen _pen; //DisposeKv


        public RuntimeIndicatorElement(int local_index, int index, RuntimeIndicator container, ORText label_expr, StandAloneEvaluator evaluator, StandAloneEvaluator futureLengthEvaluator) {
            _localIndex = local_index;
            _index = index;
            _container = container;
            _labelExpr = label_expr;
            _evaluator = evaluator;
            _futureLengthEvaluator = futureLengthEvaluator; //can be null
            Debug.Assert(container!=null);
        }

        //[UsɕύX\Ȃ̂ appearanceɂĂBPenStylevpeB𒼐ڂ
        public void Build(StringWithParameterParser parser) {
            _futureLength = _futureLengthEvaluator==null? 0 : ((BInt)_futureLengthEvaluator.Eval(new EvalContext())).Value; //TODO BIntɃLXgłȂꍇ~
            _label = parser.Parse(_labelExpr);
        }
        public void BuildSelective(StringWithParameterParser parser, bool build_label, bool build_future) {
            if(build_future)
                _futureLength = _futureLengthEvaluator==null? 0 : ((BInt)_futureLengthEvaluator.Eval(new EvalContext())).Value; //TODO BIntɃLXgłȂꍇ~
            if(build_label)
                _label = parser.Parse(_labelExpr);
        }

        public BPenStyle BPenStyle {
            get {
                return _penStyle;
            }
            set {
                ClearPen();
                _penStyle = value;
                _visible = _penStyle.visible;
            }
        }
        public bool Focused {
            get {
                return _focused;
            }
            set {
                ClearPen();
                _focused = value;
            }
        }
        public bool Visible {
            get {
                return _visible;
            }
            set {
                _visible = value;
            }
        }
        public FigureAdjustment FigureAdjustment {
            get {
                return _figureAdjustment;
            }
            set {
                _figureAdjustment = value;
            }
        }
        public int Index {
            get {
                return _index;
            }
        }
        public string Label {
            get {
                return _label;
            }
        }
        public int FutureLength {
            get {
                return _futureLength;
            }
        }
        public StandAloneEvaluator Evaluator {
            get {
                return _evaluator;
            }
        }
        public RuntimeIndicator Container {
            get {
                return _container;
            }
        }
        public IndicatorDefinition.Element SourceSchema {
            get {
                return _container.SourceSchema.IndicatorDefinition.element[_localIndex];
            }
        }

        public PolyPen Pen {
            //nCCgl
            get {
                if(_pen==null) {
                    BPenStyle ps = _penStyle;
                    if(_focused) ps = ps.Bolder();
                    _pen = ps.CreatePolyPen();
                }
                return _pen;
            }
        }

        public IDynamicPreferenceItem GetAppearancePreferenceItem() {
            IndicatorSchema s = _container.SourceSchema;
            if(_container.SharesAppearance)
                return s.AppearancePreferences[0];
            else
                return s.AppearancePreferences[_localIndex];
        }

        public void Dispose() {
            ClearPen();
        }

        public void ClearPen() {
            if(_pen!=null) _pen.Dispose();
            _pen = null;
        }

        public static FigureAdjustment ParseFigureAdjustment(string value) {
            if(value=="price")
                return FigureAdjustment.Price;
            else
                return FigureAdjustment.None;
        }
    }



    public class RuntimeIndicatorSet : IDisposable {
        private List<RuntimeIndicator> _indicators;
        private List<RuntimeIndicatorElement> _elements; //SGgʓrĂ
        private ISpecialIndicatorPaint[] _specialPaints;

        public int ElementCount {
            get {
                return _elements.Count;
            }
        }
        public int VisibleElementCount {
            get {
                int c = 0;
                foreach(RuntimeIndicatorElement e in _elements)
                    if(e.Visible) c++;
                return c;
            }
        }

        public RuntimeIndicatorSet() {
            _elements = new List<RuntimeIndicatorElement>();
            _indicators = new List<RuntimeIndicator>();
        }

        public void AddIndicator(RuntimeIndicator ind) {
            _indicators.Add(ind);
            Debug.Assert(ind.ElementCount>0);
            _elements.AddRange(ind);
        }

        public IEnumerable<RuntimeIndicator> Indicators {
            get {
                return _indicators;
            }
        }
        public IEnumerable<RuntimeIndicatorElement> Elements {
            get {
                return _elements;
            }
        }
        public RuntimeIndicator GetIndicatorAt(int index) {
            return _indicators[index];
        }
        public RuntimeIndicatorElement GetElementAt(int index) {
            return _elements[index];
        }
        public int FutureLength {
            get {
                //ő̂̂
                int r = 0;
                foreach(RuntimeIndicator ri in _indicators)
                    if(ri.VisibleAny)
                        r = Math.Max(r, ri.FutureLength);
                return r;
            }
        }

        //x쐬瓯zgÂ
        public ISpecialIndicatorPaint[] GetSpecialIndicatorPaints() {
            if(_specialPaints==null) {
                List<ISpecialIndicatorPaint> r = new List<ISpecialIndicatorPaint>();
                foreach(RuntimeIndicator ri in _indicators)
                    if(ri.SpecialIndicatorPaint!=null) r.Add(ri.SpecialIndicatorPaint);
                _specialPaints = r.ToArray();
            }
            return _specialPaints;
        }

        public void Dispose() {
            foreach(RuntimeIndicator i in _indicators) i.Dispose();
        }
    }

    public class RuntimeOscillatorGroup {
        private OscillatorGroupSchema _source; //\[X̃IV[^O[vƂ͂AȂnull
        private string _id;
        private int _index;
        private IndicatorLocation _location;
        private List<RuntimeIndicator> _indicators;

        //őEŏlvZЂ悤̂Ƃ͂g
        private double _minValue;
        private double _maxValue;
        private bool _validValueExists;

        public RuntimeOscillatorGroup(OscillatorGroupSchema gr, string id, int index) {
            _source = gr;
            _id = id;
            _index = index;
        }
        public int Index {
            get {
                return _index;
            }
        }
        public IndicatorLocation IndicatorLocation {
            get {
                return _location;
            }
        }
        public IEnumerable<RuntimeIndicator> Oscillators {
            get {
                return _indicators;
            }
        }

        public double MinValue {
            get {
                return _minValue;
            }
            set {
                _minValue = value;
            }
        }
        public double MaxValue {
            get {
                return _maxValue;
            }
            set {
                _maxValue = value;
            }
        }
        public bool ValidValueExists {
            get {
                return _validValueExists;
            }
            set {
                _validValueExists = value;
            }
        }
        public int Height {
            get {
                DynamicPreferenceItemImpl pref = GetHeightPreferenceItem();
                return ParseUtil.ParseInt(pref.Value, BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings.oscillatorDefaultHeight.V);
            }
        }
        public string Text {
            get {
                //eLXg͍邪\CWP[^̂̂Ƃ
                IndicatorSchema inds = _indicators[0].SourceSchema;
                return inds.label.IsOmitted? inds.IndicatorDefinition.id.ParseMandatoryString() : inds.label.ParseMandatoryString();
            }
        }

        public bool VisibleAny {
            get {
                //zRuntimeIndicator̂ЂƂłĂtrue
                foreach(RuntimeIndicator ind in _indicators)
                    if(ind.VisibleAny) return true;
                return false;
            }
        }

        //ʃ`FbN̒ǉ
        public void AddOscillator(RuntimeIndicator ind) {
            if(_indicators==null) {
                _indicators = new List<RuntimeIndicator>();
                _location = ind.Location;
            }
            else {
                Debug.Assert(ind.Location.IsOscillator);
                if(_location!=ind.Location)
                    throw new BellagioException("َ̃IV[^͍݂ł܂"); //TODO ʒu
            }
            _indicators.Add(ind);
            ind.SetParentOscillatorGroup(this);
        }

        //\p̃eLXg
        public string MaxValueString {
            get {
                return _location.ValueCheckRequired? (_validValueExists? _maxValue.ToString("F0") : "") : _location.MaxValueString;
            }
        }
        public string MinValueString {
            get {
                return _location.ValueCheckRequired? (_validValueExists? _minValue.ToString("F0") : "") : _location.MinValueString;
            }
        }

        public DynamicPreferenceItemImpl GetHeightPreferenceItem() {
            if(_source!=null)
                return _source.HeightInfo;
            else {
                RuntimeIndicator ri = _indicators[0];
                DynamicPreferenceItemImpl item;
                ri.SourceSchema.Parent.OscillatorHeightInfoForImplicitGroup.TryGetValue(ri.SourceSchema, out item);
                Debug.Assert(item!=null);
                return item;
            }
        }

        /*
        public string MidValueString {
            get {
                return _location.ValueCheckRequired? "" : _location.MidValueString; //őEŏlQŊ肷Kv͂Ȃ낤
            }
        }
        */
    }

    public class RuntimeOscillatorGroupSet {
        private List<RuntimeOscillatorGroup> _data;
        public RuntimeOscillatorGroupSet() {
            _data = new List<RuntimeOscillatorGroup>();
        }
        public int Count {
            get {
                return _data.Count;
            }
        }
        public void Add(RuntimeOscillatorGroup grp) {
            _data.Add(grp);
        }
        public RuntimeOscillatorGroup this[int index] {
            get {
                return _data[index];
            }
        }

        //ValueCheckRequiredȗvfS񋓁BRuntimeOscillatorGroupRuntimeIndicatorElement̗
        public RuntimeOscillatorGroup[] GetValueCheckRequiredGroups(out RuntimeIndicatorElement[] elements) {
            List<RuntimeIndicatorElement> inds = new List<RuntimeIndicatorElement>();
            List<RuntimeOscillatorGroup> r = new List<RuntimeOscillatorGroup>();
            foreach(RuntimeOscillatorGroup g in _data) {
                if(g.IndicatorLocation.ValueCheckRequired) {
                    r.Add(g);
                    foreach(RuntimeIndicator ri in g.Oscillators) {
                        for(int i=0; i<ri.ElementCount; i++)
                            inds.Add(ri.ElementAt(i));
                    }
                }
            }

            elements = inds.ToArray();
            return r.ToArray();
        }

        public bool VisibleAny {
            get {
                foreach(RuntimeOscillatorGroup g in _data)
                    if(g.VisibleAny) return true;

                return false;
            }
        }
    }

}
