/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/DaytimeTradeBasedChartDocument.cs#12 $
 * $DateTime: 2008/04/17 18:21:41 $
 * 
 * ʖ̃`[gƔA^C\ZbVEhLgEr[
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;
using Bellagio.Environment;

using Travis.LocationOperation;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

namespace Bellagio.Chart {
    //Quoteg`[ghLgB܂͂PERETT|[gB
    //炳ɁAA^Cf[^pAvC\pAƂɕ
    public abstract class IntraDayTradeBasedChartDocument : ChartDocumentBase {
        protected IntraDayTrade _intraDayTrade;
        protected RealtimeIta _realtimeIta; //͖ɂA邢͐ݒɂȂƂ
        protected int _scale;
        protected ConcreteQuote _priceRecord; //_lastMinuteCandle͊܂܂Ȃ
        protected ChartSectionInfo _sectionInfo;

        private BTime _tempTime;

        public IntraDayTradeBasedChartDocument(int scale) {
            Debug.Assert(scale==1 || scale==3 || scale==5); //͂PCRCT̂݃T|[g
            _scale = scale;
            _tempTime = new BTime(0);
            _sectionInfo = ChartSectionInfo.Empty;
        }
        protected override Quote SourceQuote {
            get { return _intraDayTrade.Minutely; }
        }
        public override int LastClosePrice {
            get {
                if(_intraDayTrade==null) return 0;
                RealtimeInfoString<int> p = _intraDayTrade.CurrentPriceInfo.LastClose;
                return p.IsEmpty? 10000 : p.Value; //OIl̂ȂƂ͂ȂK
            }
        }
        public IntraDayTrade IntraDayTrade {
            get {
                return _intraDayTrade;
            }
        }
        public RealtimeIta RealtimeIta {
            get {
                return _realtimeIta;
            }
        }
        public int Scale {
            get {
                return _scale;
            }
        }
        public override ChartSectionInfo SectionInfo {
            get {
                if(_intraDayTrade!=null && _stock!=null) AdjustSectionInfo();
                return _sectionInfo;
            }
        }


        public override bool IsTimeLabelRequired(int raw_time, out string str) {
            _tempTime.LetInt(raw_time);
            int step = _scale==1? 10 : _scale==3? 30 : 60; //_scaleɂ10,30,60
            //Ɖ肾ALStep̔{łȂĂ12:30, 16:30͏dvȂ̂ŕ\
            if((_tempTime.Minute % step)==0 || (raw_time==MarketUtil.GetGobaOpenTime(StockExchange.T).AsInt() || raw_time==MarketUtil.GetEveningOpenTime(StockExchange.O).AsInt())) {
                str = GetTimeLabel(raw_time);
                return true;
            }
            else if(_tempTime.AsInt() >= MarketUtil.GetGobaCloseTime(StockExchange.O).AsInt()) {
                //15:10̃x͂BRET̂Ƃ݂̂̏u
                str = GetTimeLabel(MarketUtil.GetGobaCloseTime(StockExchange.O).AsInt());
                return true;
            }
            else {
                str = null;
                return false;
            }
        }
        public override string GetTimeLabel(int raw_time) {
            //CujOZbV̎͒Kv
            if(MarketUtil.GetEveningOpenTime(StockExchange.O).AsInt() <= raw_time && raw_time <= MarketUtil.GetEveningCloseTime(StockExchange.O).AsInt()) {
                raw_time += 12 * 3600;
            }
            _tempTime.LetInt(raw_time);
            return BTime.FormatHHMM(_tempTime);
        }

        public override Candle GetCandleAt(CHARTPOSITION position) {
            int data_index = position.ToDataIndexSoft();
            return data_index==-1? null : GetCandleAtOrNull(data_index);
        }
        private Candle GetCandleAtOrNull(int data_index) {
            if(data_index < _priceRecord.Count)
                return _priceRecord.CandleAt(data_index);
            else { //߂ǂȍp^[
                Quote min = _intraDayTrade.Minutely;
                Candle y = null;
                int start = data_index * _scale; // [start, start+_scale)Ă
                for(int i=start; i<start + _scale; i++) {
                    Candle t = min.CandleAtOrNull(i);
                    if(t!=null)
                        y = Candle.Update(y, t);
                }
                if(_intraDayTrade.IsLastMinuteCandleAvailable) {
                    int index = _intraDayTrade.Minutely.Count; //ꂪLastMinuteCandlẽCfbNX
                    if(start <= index && index < start + _scale)
                        y = Candle.Update(y, _intraDayTrade.LastMinuteCandle);
                }
                return y;
            }
        }
        public override bool GetChartPositionAt(int raw_time, out CHARTPOSITION pos) {
            if(_intraDayTrade.IsLastMinuteCandleAvailable && _intraDayTrade.LastMinuteCandle.Time==raw_time) {
                pos = _sectionInfo.LastPosition;
                return true;
            }

            //TODO ExactlyƕłLłȂB͈͎wŌł@\QuoteɂȂ
            int index = _intraDayTrade.Minutely.FindExactly(raw_time); 
            
            if(index==-1) {
                pos = CHARTPOSITION.Empty(_sectionInfo);
                return false;
            }
            else {
                pos = _sectionInfo.GetChartPositionByData(index / _scale);
                return true;
            }
        }

        public override int GetDateOrTimeAt(CHARTPOSITION position) {
            int di = position.ToDataIndexSoft();
            if(di!=-1)
                return GetCandleAt(position).Time;
            else if(position.SectionType==ChartSectionType.Space && position.PositionInSection==0) { //xݐ擪
                ChartSectionInfo.Tag tag = _sectionInfo.GetTagAt(position.SectionIndex-1);
                return _priceRecord.CandleAt(tag.dataIndex + tag.length - 1).Time + _scale*60; //Õf[^ZNV̍ŏIPi߂
            }
            else
                return -1;
        }
        public override int GetNextDateOrTimeAt(CHARTPOSITION position) {
            int di = position.ToDataIndexSoft();
            if(di!=-1)
                return GetCandleAt(position).Time + _scale*60;
            else
                return -1;
        }


        protected override bool AdjustEvalContext(EvalContext context, int data_index) {
            if(IncludesLastMinute(data_index)) return false;
            //Eval͂PōsƂɒ
            _contextQuote.Set(_intraDayTrade.Minutely, 0, Math.Min(_scale*(data_index+1), _intraDayTrade.Minutely.Count));
            Candle c = GetCandleAtOrNull(data_index);
            context.CurrentTime = c==null? null : BTime.LetRaw(context.CurrentTime, c.Time);
            context.ContextValue = _contextQuote;
            return true;
        }
        public override void ResetSectionInfo() {
            _sectionInfo = ChartSectionInfo.Empty;
        }

        private bool IncludesLastMinute(int data_index) {
            return _intraDayTrade.IsLastMinuteCandleAvailable && data_index==_priceRecord.Count;
        }

        public void ClearLastIndicatorValueCache() {
            if(_priceRecord.Count > 0) {
                _indicatorValueCache.ClearByDataIndex(_priceRecord.Count-1);
            }
        }

        //ZNV̍쐬@CujOZbVlȂ̂ŕG

        private void AdjustSectionInfo() {
            int len; //ׂ̒
            int mc = _intraDayTrade.Minutely.Count;
            if(_intraDayTrade.IsLastMinuteCandleAvailable) mc++;

            if(mc > 0)
                len = ((mc-1) / _scale) + 1; //mc_scaleŊ؂Ȃ炻AłȂΐ؂グ
            else
                len = 0;

            MarketOpenTimeRange time_range = MarketOpenTimeRange.GetFor(_stock);
            int section_count;
            int last_data_len;
            time_range.IndexToSection(mc, out section_count, out last_data_len);
            section_count++; //IndexToSectionł̓ANeBuȃZNVڂĂʒu邽
            last_data_len = last_data_len==0? 0 : ((last_data_len-1) / _scale) + 1;

            if(_sectionInfo.IsEmpty || _sectionInfo.DataSectionCount!=section_count) { //쐬̕KvƂ
                Debug.Assert(section_count <= 3);
                int space_in_section = 5;// BellagioRoot.FixedPreferences.Chart.CandleCountBetweenSections;
                if(section_count==3)
                    _sectionInfo = new ChartSectionInfo(new ChartSectionType[] { ChartSectionType.Data, ChartSectionType.Space, ChartSectionType.Data, ChartSectionType.Space, ChartSectionType.Data },
                        new int[] { time_range.LengthAsMin(0)/_scale, space_in_section, time_range.LengthAsMin(1)/_scale, space_in_section, last_data_len });
                else if(section_count==2)
                    _sectionInfo = new ChartSectionInfo(new ChartSectionType[] { ChartSectionType.Data, ChartSectionType.Space, ChartSectionType.Data },
                        new int[] { time_range.LengthAsMin(0)/_scale, space_in_section, last_data_len });
                else if(last_data_len>0)
                    _sectionInfo = new ChartSectionInfo(ChartSectionType.Data, last_data_len);
                else
                    _sectionInfo = ChartSectionInfo.Empty;

                int fl = _indicators.FutureLength;
                if(fl > 0)
                    _sectionInfo.AppendLast(ChartSectionType.Forward, fl);
            }
            else { //̒łƂ
                if(len > 0)
                    _sectionInfo.UpdateLength(_sectionInfo.LastData.index, last_data_len);
                else
                    _sectionInfo = ChartSectionInfo.Empty;
            }
        }

    }

    //Oŗ^QuoteɂChartDocument
    public class ExternalIntraDayTradeChartDocument : IntraDayTradeBasedChartDocument {
        public ExternalIntraDayTradeChartDocument(IntraDayTrade q, int scale)
            : base(scale) {
            Debug.Assert(scale==1); //܂_priceRecord==_daytimeTrade.Minutely̑OȂ̂ł
            _stock = q.Stock;
            _intraDayTrade = q;
            ResetSectionInfo();
        }

        public override void ReloadQuote() {
            //
        }

        public override void ResetSectionInfo() {
            base.ResetSectionInfo();
            _priceRecord = _scale==1? _intraDayTrade.Minutely : QuoteConverter.Shrink(_intraDayTrade.Minutely, _scale);
            _documentStatus = BellagioDocumentStatus.Complete;
        }
    }
}
