﻿using System;
using System.Collections.Generic;
using System.Text;
using FDK;

namespace StrokeStyleT
{
	public class Cチップ : IComparable
	{
		public const int n最大音量 = 4;
		public const int n最小音量 = 1;

		//------------------------
		// プロパティ(1) 譜面データ読み込み時に決定する項目	（増減させたらコンストラクタと CopyFrom() を修正のこと）

		/// <summary>
		/// <para>チップの種別。</para>
		/// </summary>
		public Eチップ eチップ;

		/// <summary>
		/// <para>チップの存在する小節の番号（0～)。</para>
		/// </summary>
		public int n小節番号;

		/// <summary>
		/// <para>チップの小節内における位置。0≦n小節内位置＜n小節解像度 を満たす整数。</para>
		/// </summary>
		public int n小節内位置;

		/// <summary>
		/// <para>チップが存在する小節の解像度(1～整数)。</para>
		/// </summary>
		public int n小節解像度;

		/// <summary>
		/// <para>チップの発声時刻。遅延が生じる分、描画時刻よりも遅く設定される。</para>
		/// <para>譜面の先頭（小節番号-1の先頭）からの時刻をミリ秒単位で表す。</para>
		/// </summary>
		public long n描画時刻ms;

		/// <summary>
		/// <para>チップの描画時刻。遅延を受ける発声時刻とは別に、チップが描画されるべき場所を示す。</para>
		/// <para>譜面の先頭（小節番号-1の先頭）からの時刻をミリ秒単位で表す。</para>
		/// </summary>
		public long n発声時刻ms;

		/// <summary>
		/// <para>チップの音量（小:1～4：大）。</para>
		/// </summary>
		public int n音量
		{
			get
			{
				return this._n音量;
			}
			set
			{
				if( value < 1 || value > 4 )
					throw new ArgumentException( string.Format( "音量の値域(1～4)を超える値({0})が指定されました。", value ) );

				this._n音量 = value;
			}
		}

		/// <summary>
		/// <para>チップの持つBPM値。</para>
		/// <para>eチップ==Eチップ.BPM の時のみ有効。</para>
		/// </summary>
		public double dbBPM;

		//------------------------
		// プロパティ(2) 演奏用のワーク		（増減させたらコンストラクタと CopyFrom() を修正のこと）

		/// <summary>
		/// <para>チップが見える場合は true。</para>
		/// </summary>
		public bool b可視;

		/// <summary>
		/// <para>チップがヒットされた場合は true。</para>
		/// </summary>
		public bool bヒット済
		{
			get;
			set;
		}
		public bool b未ヒット
		{
			get { return !this.bヒット済; }
			set { this.bヒット済 = !value; }
		}

		/// <summary>
		/// <para>チップが発声した場合は true。</para>
		/// </summary>
		public bool b発声済
		{
			get;
			set;
		}
		public bool b未発声
		{
			get { return !this.b発声済; }
			set { this.b発声済 = !value; }
		}

		//------------------------
		// プロパティ(3) SSTFEditor用の状態変数		（増減させたらコンストラクタと CopyFrom() を修正のこと）

		public int n譜面内絶対位置grid;
		public bool bドラッグ操作により選択中;
		public bool b選択が確定している;
		public bool b移動済;
		public string strチップ内文字列;
		public int n枠外レーン数;


		//------------------------
		// メソッド

		public Cチップ()
		{
			this.eチップ = Eチップ.Unknown;
			this.n小節番号 = -1;
			this.n小節内位置 = 0;
			this.n小節解像度 = 1;
			this.n描画時刻ms = CTimer.n未使用;
			this.n発声時刻ms = CTimer.n未使用;
			this.n音量 = 4;
			this.dbBPM = 120.0;

			this.b可視 = true;
			this.bヒット済 = false;
			this.b発声済 = false;

			this.n譜面内絶対位置grid = 0;
			this.bドラッグ操作により選択中 = false;
			this.b選択が確定している = false;
			this.b移動済 = true;
			this.strチップ内文字列 = null;
			this.n枠外レーン数 = 0;
		}
		public Cチップ( Cチップ srcChip )
		{
			this.CopyFrom( srcChip );
		}

		public void CopyFrom( Cチップ srcChip )
		{
			this.eチップ = srcChip.eチップ;
			this.n小節番号 = srcChip.n小節番号;
			this.n小節内位置 = srcChip.n小節内位置;
			this.n小節解像度 = srcChip.n小節解像度;
			this.n描画時刻ms = srcChip.n描画時刻ms;
			this.n発声時刻ms = srcChip.n発声時刻ms;
			this._n音量 = srcChip.n音量;
			this.dbBPM = srcChip.dbBPM;

			this.b可視 = srcChip.b可視;
			this.bヒット済 = srcChip.bヒット済;
			this.b発声済 = srcChip.b発声済;
			
			this.n譜面内絶対位置grid = srcChip.n譜面内絶対位置grid;
			this.bドラッグ操作により選択中 = srcChip.bドラッグ操作により選択中;
			this.b選択が確定している = srcChip.b選択が確定している;
			this.b移動済 = srcChip.b移動済;
			this.strチップ内文字列 = srcChip.strチップ内文字列;
			this.n枠外レーン数 = srcChip.n枠外レーン数;

			//this.dicチップの深さ = srcChips.dicチップの深さ;		// いらない
		}

		#region [ IComparable 実装 ]
		//-----------------
		// 概要:
		//     現在のインスタンスを同じ型の別のオブジェクトと比較して、並べ替え順序において、現在のインスタンスの位置が同じ型の別のオブジェクトの前、後ろ、または同じのいずれであるかを示す整数を返します。
		//
		// パラメータ:
		//   obj:
		//     このインスタンスと比較するオブジェクト。
		//
		// 戻り値:
		//     比較対象オブジェクトの相対順序を示す 32 ビット符号付き整数。戻り値の意味は次のとおりです。 
		//
		//     値		説明
		//     --------------------
		//     負数		this ＜ obj
		//     0		this ＝ obj
		//     正数		this ＞ obj
		//
		// 例外:
		//   System.ArgumentException:
		//     obj の型がこのインスタンスの型と異なります。
		//
		public int CompareTo( object obj )
		{
			var other = obj as Cチップ;

			if( this.n小節番号 < other.n小節番号 ) { return -1; }
			if( this.n小節番号 > other.n小節番号 ) { return +1; }

			double dbThis = (double) this.n小節内位置 / (double) this.n小節解像度;
			double dbOther = (double) other.n小節内位置 / (double) other.n小節解像度;

			if( dbThis < dbOther ) { return -1; }
			if( dbThis > dbOther ) { return +1; }


			// グリッドが完全に等しいなら、チップの種類ごとに定義された深度で順序を決める。

			if( this.dicチップの深さ[ this.eチップ ] > this.dicチップの深さ[ other.eチップ ] ) { return -1; }
			if( this.dicチップの深さ[ this.eチップ ] < this.dicチップの深さ[ other.eチップ ] ) { return +1; }

			return 0;
		}
		//-----------------
		#endregion

		//------------------------
		private int _n音量;
		private Dictionary<Eチップ, int> dicチップの深さ = new Dictionary<Eチップ, int>() {
			#region [ *** ]
			//-----------------
			{ Eチップ.Ride_Cup, 50},
			{ Eチップ.HiHat_Open, 50},
			{ Eチップ.HiHat_HalfOpen, 50},
			{ Eチップ.HiHat_Close, 50},
			{ Eチップ.HiHat_Foot, 50},
			{ Eチップ.Snare, 50},
			{ Eチップ.Snare_OpenRim, 50},
			{ Eチップ.Snare_ClosedRim, 50},
			{ Eチップ.Snare_Ghost, 50},
			{ Eチップ.Tom1, 50},
			{ Eチップ.Tom1_Rim, 50},
			{ Eチップ.BPM, 50},
			{ Eチップ.Ride, 60},
			{ Eチップ.Splash, 60},
			{ Eチップ.Tom2, 60},
			{ Eチップ.Tom2_Rim, 60},
			{ Eチップ.LeftCrash, 70},
			{ Eチップ.China, 70},
			{ Eチップ.Tom3, 70},
			{ Eチップ.Tom3_Rim, 70},
			{ Eチップ.RightCrash, 70},
			{ Eチップ.Bass, 75},
			{ Eチップ.小節線, 80},
			{ Eチップ.拍線, 85},
			{ Eチップ.背景動画, 90},
			{ Eチップ.小節メモ, 99},
			{ Eチップ.Unknown, 99 },
			//-----------------
			#endregion
		};
	}
}
