﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>確定された場合、Global.Input.KeyAssign が修正され、保存される。</para>
	/// <para>キャンセルされた場合は何もしない。</para>
	/// </summary>
	public partial class C入力割当ウィンドウ : Form
	{
		public C入力割当ウィンドウ()
		{
			InitializeComponent();
		}

		public void tメイン処理( Form owner )
		{
			// 現在のキーアサインを temp にコピー。以降は、確定するまでこの Work のほうをいじる。

			this.tempKeyAssign = (CKeyAssign) Global.Input.KeyAssign.Clone();

			// 設定ウィンドウを初期化する。

			#region [ comboBox想定するドラム ]
			//-----------------
			this.comboBox想定するドラム.Items.Clear();

			foreach( var kvpMidi in Global.Input.MidiNoteNameMappings.Profiles )
				this.comboBox想定するドラム.Items.Add( kvpMidi.Key );

			this.comboBox想定するドラム.SelectedIndex = 0;
			//-----------------
			#endregion
			#region [ comboBoxパッド選択 ]
			//-----------------
			foreach( var obj in Enum.GetValues( typeof( E入力アサインパッド ) ) )
			{
				var pad = (E入力アサインパッド) obj;
				this.comboBoxパッド選択.Items.Add( pad.ToString() );	// SelectedIndex = E入力アサインパッド　という並びで Add() する。
			}
			this.comboBoxパッド選択.SelectedIndex = 0;
			//-----------------
			#endregion
			#region [ listBox現在の割り当て ]
			//-----------------
			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
			//-----------------
			#endregion
			#region [ textBoxFootPedal～ ]
			//-----------------
			this.textBoxFootPedal現在値.Text = "";
			this.textBoxFootPedal最小値.Text = ( this.tempKeyAssign.FootPedalMin >= 0 ) ? this.tempKeyAssign.FootPedalMin.ToString() : "";
			this.textBoxFootPedal最大値.Text = ( this.tempKeyAssign.FootPedalMax >= 0 ) ? this.tempKeyAssign.FootPedalMax.ToString() : "";
			//-----------------
			#endregion

			this.button追加.Enabled = false;
			this.button削除.Enabled = false;


			// 設定ウィンドウを表示し、入力処理タイマスレッドを起動する。

			Global.tダイアログ表示の前処理();

			Global.Input.Input管理.Dispose();
			using( Global.Input.Input管理 = new CInput管理( this.Handle ) )		// このウィンドウ上でのInput管理を開始。
			using( this.Timer = new Timer() )
			{
				this.Timer.Interval = 100;
				int nTick回数 = 0;

				this.Timer.Tick += ( o, args ) => {		// ドラム入力処理を登録。

					nTick回数++;

					Global.Input.Input管理.tポーリング( true, true );	// 生の入力値を扱うので、Input.tポーリング() ではなく Input管理.tポーリング() のほうを使用する。

					#region [ MIDIノート入力があれば処理する。]
					//-----------------
					for( int n = 0; n < Global.Input.Input管理.nMidiIn数; n++ )
					{
						foreach( var ie in Global.Input.Input管理.MidiIn( n ).list入力イベント )
						{
							if( ie.nKey != 255 )
							{
								// 「入力されたMIDIノート」リストを更新。
								// フットペダルコントロールチェンジは表示しない。

								if( nTick回数 >= 10 )	// 前回の入力から1秒以上間が空いてたら空行を挟む。
									this.t入力されたMIDIノートリストに空行を出力();
								nTick回数 = 0;

								this.t入力されたMIDIノートリストに1行出力( ie );
							}
							else
							{
								// フットペダル関連の数値を修正。

								this.textBoxFootPedal現在値.Text = ie.nVelocity.ToString();

								int n最小値 = 0;
								if( !string.IsNullOrEmpty( this.textBoxFootPedal最小値.Text ) )
									n最小値 = int.Parse( this.textBoxFootPedal最小値.Text );
								this.textBoxFootPedal最小値.Text = Math.Min( n最小値, ie.nVelocity ).ToString();

								int n最大値 = 0;
								if( !string.IsNullOrEmpty( this.textBoxFootPedal最大値.Text ) )
									n最大値 = int.Parse( this.textBoxFootPedal最大値.Text );
								this.textBoxFootPedal最大値.Text = Math.Max( n最大値, ie.nVelocity ).ToString();

								this.pictureBoxFootPedal.Refresh();
							}
						}
					}
					//-----------------
					#endregion

					#region [ 選択されている行があるなら追加/削除ボタンを有効化し、なければ無効化する。]
					//-----------------
					this.button追加.Enabled =
						( this.listView入力されたMIDIノート.SelectedItems.Count > 0 ) &&
						( !string.IsNullOrEmpty( this.listView入力されたMIDIノート.SelectedItems[ 0 ].Text ) );
					this.button削除.Enabled = ( this.listBox現在の割り当て.SelectedItem != null );
					//-----------------
					#endregion
				};
		
				// モーダルモードで起動する。閉じるまで処理が帰ってこない。

				this.Timer.Start();		// ドラムによるGUI操作を開始。
				this.dialogResult = this.ShowDialog( Global.App.Window );
				this.Timer.Stop();		// ドラムによるGUI操作を終了。
			}

			owner.Select();	// ダイアログが閉じたので、メインウィンドウをアクティブに戻す。

			Global.Input.Input管理.Dispose();
			Global.Input.Input管理 = new CInput管理( owner.Handle );

			Global.tダイアログ表示の後処理();


			// 確定処理。

			if( this.dialogResult == DialogResult.OK )
			{
				// 確定なら temp から本番へ複写し、保存。
				Global.Input.KeyAssign = (CKeyAssign) this.tempKeyAssign.Clone();
				CXMLFile<CKeyAssign>.t保存する( Global.Input.KeyAssign, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_KEY_ASSIGN ) );
			}
			else
			{
				// キャンセルなら temp はそのまま破棄。
			}

			// ※ 親フォームへの Global.Input.Input管理の再生成は呼び出し元で行うこと。
		}

		/// <summary>
		/// <para>確定されるまでは、すべてのキー変更をこれに対して行う。（初期状態は Global.KeyAssign の複製）</para>
		/// <para>確定ボタンでダイアログが終わったとき、この内容が Global.KeyAssign に複写される。</para>
		/// <para>確定されなかった（キャンセルされた）とき、この内容は破棄され、Global.KeyAssign の内容も変わらない。</para>
		/// </summary>
		CKeyAssign tempKeyAssign = new CKeyAssign();

		protected Timer Timer = null;	// CTimer じゃなく普通の Timer 。
		protected DialogResult dialogResult = DialogResult.OK;

		private void t入力されたMIDIノートリストに空行を出力()
		{
			this.listView入力されたMIDIノート.Items.Add( "" );
			this.listView入力されたMIDIノート.EnsureVisible( this.listView入力されたMIDIノート.Items.Count - 1 );
		}
		private void t入力されたMIDIノートリストに1行出力( CInputEvent ie )
		{
			// strノート名, str押されたか放されたか の確定。

			string strノート名 = this.t現在選択されているMIDI機器でのノート名を返す( ie.nKey );

			if( string.IsNullOrEmpty( strノート名 ) )
				strノート名 = "";
			else
				strノート名 = " (" + strノート名 + ")";

			string str押されたか放されたか = ( ie.b押された ) ? "NoteON" : "NoteOFF";


			// 最下行を追加＆表示。

			this.listView入力されたMIDIノート.Items.Add( new ListViewItem() {
				Text = string.Format( "{4}, ID:{0}, #{1}{2}, {3}", ie.ID, ie.nKey, strノート名, str押されたか放されたか, ( ie.ID * 1000 + ie.nKey ).ToString( "00000" ) ),
				ForeColor = ( ie.b押された ) ? Color.Black : Color.Silver,
			} );
			this.listView入力されたMIDIノート.EnsureVisible( this.listView入力されたMIDIノート.Items.Count - 1 );
		}
		private void t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する()
		{
			// 描画停止。

			this.listBox現在の割り当て.SuspendLayout();

			
			// リストをクリア。

			this.listBox現在の割り当て.Items.Clear();


			// 現在のパッドの KeyAssign を順番にリストに追加。

			var ePad = (E入力アサインパッド) this.comboBoxパッド選択.SelectedIndex;		// SelectedIndex = E入力アサインパッド　という並びである前提。
			var Pad = this.tempKeyAssign.Pads[ (int) ePad ];

			foreach( var key in Pad.Keys )
			{
				// ノート名 の確定。

				string strノート名 = this.t現在選択されているMIDI機器でのノート名を返す( key.Note );
				if( string.IsNullOrEmpty( strノート名 ) )
					strノート名 = "";
				else
					strノート名 = " (" + strノート名 + ")";


				// リストボックスにノート名を登録。

				this.listBox現在の割り当て.Items.Add( string.Format( "ID:{0}, #{1}{2}", key.DeviceID, key.Note, strノート名 ) );
			}


			// 「すべて削除」ボタン　→　割り当てが１行でもあれば Enable 、無ければ Disable 。

			this.buttonすべて削除.Enabled = ( this.listBox現在の割り当て.Items.Count > 0 );


			// 描画再開。

			this.listBox現在の割り当て.ResumeLayout();
		}
		private string t現在選択されているMIDI機器でのノート名を返す( int nNote )
		{
			string strMIDI機器名 = (string) this.comboBox想定するドラム.SelectedItem;		// ※ 現在ではまだ、入力デバイス(ie.ID)別にノート名を返す機能はない。

			if( Global.Input.MidiNoteNameMappings.Profiles.ContainsKey( strMIDI機器名 ) &&
				Global.Input.MidiNoteNameMappings.Profiles[ strMIDI機器名 ].ContainsKey( nNote ) )
			{
				return Global.Input.MidiNoteNameMappings.Profiles[ strMIDI機器名 ][ nNote ];
			}
			return null;
		}

		private void buttonFootPedalリセット_Click( object sender, EventArgs e )
		{
			this.textBoxFootPedal現在値.Text = "";
			this.textBoxFootPedal最小値.Text = "";
			this.textBoxFootPedal最大値.Text = "";
		}
		private void buttonすべて削除_Click( object sender, EventArgs e )
		{
			var result = MessageBox.Show( this, "割り当てられているすべてのノートを削除しますか？", "確認", MessageBoxButtons.YesNo, MessageBoxIcon.Asterisk );
			if( result == DialogResult.No )
				return;

			var ePad = (E入力アサインパッド) this.comboBoxパッド選択.SelectedIndex;		// SelectedIndex = E入力アサインパッド　という並びである前提。
			var Keys = this.tempKeyAssign.Pads[ (int) ePad ].Keys;

			Keys.Clear();	// 全削除

			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
		}
		private void button削除_Click( object sender, EventArgs e )
		{
			int n削除行番号 = this.listBox現在の割り当て.SelectedIndex;

			// SelectedIndex = E入力アサインパッド　という並びである前提。
			var ePad = (E入力アサインパッド) this.comboBoxパッド選択.SelectedIndex;
			var Keys = this.tempKeyAssign.Pads[ (int) ePad ].Keys;

			// 行は Pad.Keys 順に表示されているので、選択されている行番号が Pad.Keys での削除インデックスに等しい。
			Keys.RemoveAt( n削除行番号 );

			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
		}
		private void button追加_Click( object sender, EventArgs e )
		{
			#region [ 選択されているMIDI入力ノートから、MIDI機器IDとノート番号を得る。]
			//-----------------
			string strIDNote = this.listView入力されたMIDIノート.SelectedItems[ 0 ].Text.Split( ',' )[ 0 ];		// nMidiIn番号×1000 ＋ nノート番号 を "00000" で表現した文字列。
			int nMIDI機器ID = int.Parse( strIDNote.Substring( 0, 2 ) );
			int nノート番号 = int.Parse( strIDNote.Substring( 2, 3 ) );
			//-----------------
			#endregion

			#region [ tempAssignKey に既に登録されているMIDI機器＆ノートなら削除する。]
			//-----------------
			foreach( var obj in Enum.GetValues( typeof( E入力アサインパッド ) ) )
			{
				var Pad = this.tempKeyAssign.Pads[ (int) obj ];
				for( int i = Pad.Keys.Count - 1; i >= 0; i-- )
				{
					if( Pad.Keys[ i ].DeviceID == nMIDI機器ID &&
						Pad.Keys[ i ].Note == nノート番号 )
					{
						Pad.Keys.RemoveAt( i );
						continue;
					}
				}
			}
			//-----------------
			#endregion
			#region [ tempAssignKey の現在のパッドにノートを追加する。]
			//-----------------
			var ePad = (E入力アサインパッド) this.comboBoxパッド選択.SelectedIndex;		// SelectedIndex = E入力アサインパッド　という並びである前提。
			this.tempKeyAssign.Pads[ (int) ePad ].Keys.Add(
				new CKeyAssign.Key() {
					DeviceGUID = null,
					DeviceID = nMIDI機器ID,
					Note = nノート番号
				} );
			//-----------------
			#endregion

			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
		}
		private void comboBoxパッド選択_SelectedIndexChanged( object sender, EventArgs e )
		{
			if( this.comboBoxパッド選択.SelectedItem == null )
				return;		// 起動直後はnullで来るので除外（準正常）。

			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
		}
		private void comboBox想定するドラム_SelectedIndexChanged( object sender, EventArgs e )
		{
			if( this.comboBoxパッド選択.SelectedItem == null )
				return;		// 起動直後はnullで来るので除外（準正常）。

			this.t現在選択中のパッドに合わせて現在の割り当てリストボックスを更新する();
		}
		private void pictureBoxFootPedal_Paint( object sender, PaintEventArgs e )
		{
			var sz全体領域 = this.pictureBoxFootPedal.ClientSize;
			var rc全体バー = new Rectangle( 24, 16, 16, sz全体領域.Height - 16 * 2 );
			int n現在値 = ( string.IsNullOrEmpty( this.textBoxFootPedal現在値.Text ) ) ? -1 : int.Parse( this.textBoxFootPedal現在値.Text );
			int n最小値 = ( string.IsNullOrEmpty( this.textBoxFootPedal最小値.Text ) ) ? -1 : int.Parse( this.textBoxFootPedal最小値.Text );
			int n最大値 = ( string.IsNullOrEmpty( this.textBoxFootPedal最大値.Text ) ) ? -1 : int.Parse( this.textBoxFootPedal最大値.Text );
			double db踏み込み割合 = n現在値 / 127.0;		// 開放:0.0～1.0:踏み込み

			#region [ 全体バーの枠表示 ]
			//-----------------
			e.Graphics.FillRectangle( Brushes.Silver, rc全体バー );
			e.Graphics.DrawRectangle( Pens.Black, rc全体バー );
			//-----------------
			#endregion

			#region [ 現在位置マーク（三角）を表示 ]
			//-----------------
			if( n現在値 < 0 )	// まだ踏まれて無くても
				n現在値 = 0;	// とりあえず三角を表示。

			int y = rc全体バー.Top + (int) ( rc全体バー.Height * db踏み込み割合 );

			e.Graphics.FillPolygon(
				Brushes.Black,
				new Point[] {
						new Point( rc全体バー.Right, y ),
						new Point( rc全体バー.Right + 10, y - 5 ),
						new Point( rc全体バー.Right + 10, y + 5 ),
					} );
			//-----------------
			#endregion

			#region [ 最小値から最大値までグラデ表示 ]
			//-----------------
			if( n最小値 >= 0 && n最大値 >= 0 )
			{
				using( var br縦グラデ = new System.Drawing.Drawing2D.LinearGradientBrush(
					new Point( rc全体バー.X, rc全体バー.Y ),
					new Point( rc全体バー.X, rc全体バー.Bottom ),
					Color.FromArgb( 255, 255, 255, 0 ),
					Color.FromArgb( 255, 255, 0, 0 ) ) )
				{
					var rc = rc全体バー;
					rc.Y = rc全体バー.Y + (int) ( ( n最小値 / 127.0 ) * rc全体バー.Height );
					rc.Height = (int) ( ( ( n最大値 - n最小値 ) / 127.0 ) * rc全体バー.Height );
					e.Graphics.FillRectangle( br縦グラデ, rc );
				}
			}
			//-----------------
			#endregion

			e.Graphics.DrawRectangle( Pens.Black, rc全体バー );
		}
		private void textBoxFootPedal最小値_TextChanged( object sender, EventArgs e )
		{
			this.tempKeyAssign.FootPedalMin = ( string.IsNullOrEmpty( this.textBoxFootPedal最小値.Text ) ) ? -1 : int.Parse( this.textBoxFootPedal最小値.Text );
			this.pictureBoxFootPedal.Refresh();
		}
		private void textBoxFootPedal最大値_TextChanged( object sender, EventArgs e )
		{
			this.tempKeyAssign.FootPedalMax = ( string.IsNullOrEmpty( this.textBoxFootPedal最大値.Text ) ) ? -1 : int.Parse( this.textBoxFootPedal最大値.Text );
			this.pictureBoxFootPedal.Refresh();
		}
	}
}
