﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>「MIDIノート」と「名前」の機種別マッピング。代表的な電子ドラムに関して固定的に定義し、XML形式ファイルで保存する。</para>
	/// <para> Kit によってノートと名前が異なる場合があるが、ここでは代表的なもの（たいていは GeneralMIDI Kit）のみ定義する。</para>
	/// </summary>
	[Serializable]
	public class CMidiNoteNameMappings : ISerializableXML		// XML化対象クラスは public であり、StrokeStyleT.ISerializableXML を実装すること。
	{
		// XML化対象。

		/// <summary>
		/// <para>Profiles&lt;機器名,ノードリスト&gt;</para>
		/// <para>ノードリスト：&lt;ノート番号, ノート名&gt;</para>
		/// </summary>
		public CSerializableDictionary<string, CSerializableDictionary<int, string>> Profiles;

		
		// XML化対象クラスはパラメータなしの public コンストラクタを持つこと。
		public CMidiNoteNameMappings()
		{
			this.Profiles = new CSerializableDictionary<string, CSerializableDictionary<int, string>>();

			this.Profiles.Add( "General MIDI", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 35, "Acoustic Bass Drum" },
				{ 36, "Bass Drum 1" },
				{ 37, "Side Stick" },
				{ 38, "Acoustic Snare" },
				{ 39, "Hand Clap" },
				{ 40, "Electric Snare" },
				{ 41, "Low Floor Tom (Tom6)" }, 
				{ 42, "Closed Hi-Hat" },
				{ 43, "High Floor Tom (Tom5)" },
				{ 44, "Pedal Hi-Hat" },
				{ 45, "Low Tom (Tom4)" },
				{ 46, "Open Hi-Hat" },
				{ 47, "Low-Mid Tom (Tom3)" },
				{ 48, "Hi-Mid Tom (Tom2)" },
				{ 49, "Crash Cymbal 1" },
				{ 50, "High Tom (Tom1)" },
				{ 51, "Ride Cymbal  1" },
				{ 52, "Chinese Cymbal" },
				{ 53, "Ride Bell" },
				{ 54, "Tambourine" },
				{ 55, "Splash Cymbal" },
				{ 56, "Cowbell" },
				{ 57, "Crash Cymbal 2" },
				{ 58, "Vibraslap" },
				{ 59, "Ride Cymbal 2" },
				{ 60, "BongoH" },
				{ 61, "BongoL" },
				{ 62, "CongaHMute" },
				{ 63, "CongaHOpen" },
				{ 64, "CongaL" },
				{ 65, "TimbareH" },
				{ 66, "TimbareL" },
				{ 67, "AgogoH" },
				{ 68, "AgogoL" },
				{ 69, "Cabasa" },
				{ 70, "Maracas" },
				{ 71, "WhistleShort" },
				{ 72, "WhistleLong" },
				{ 73, "GuiroShort" },
				{ 74, "GuiroLong" },
				{ 75, "Claves" },
				{ 76, "WoodBlockH" },
				{ 77, "WoodBlockL" },
				{ 78, "CuicaMute" },
				{ 79, "CuicaOpen" },
				{ 80, "TriangleMute" },
				{ 81, "TriangleOpen" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "YAMAHA DTXTREME (Kit1)", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 31, "Snare" },
				{ 33, "Bass1" },
				{ 34, "Snare Rim" },
				{ 36, "Bass2" },
				{ 42, "HHClose" },
				{ 43, "Tom4" },
				{ 44, "FootClose" },
				{ 45, "Tom3" },
				{ 46, "HHOpen" },
				{ 47, "Tom2" },
				{ 48, "Tom1" },
				{ 49, "Crash" },
				{ 51, "Ride Rim" },
				{ 52, "China" },
				{ 53, "RidB Drk" },
				{ 56, "Cowbell1" },
				{ 57, "Crash Rim" },
				{ 59, "Ride" },
				{ 84, "BellTree" },
				{ 86, "Tom1 Rim" },
				{ 87, "Tom2 Rim" },
				{ 88, "Tom3 Rim" },
				{ 89, "Tom4 Rim" },
				{ 90, "HH Rim" },
				{ 91, "FootSplash" },
				{ 92, "Cowbell2" },
				{ 93, "Cowbell Mute" },
				{ 94, "Crash Mute(Splash)" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "YAMAHA DTXPRESS IV (Kit1)", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 15, "pad10" },
				{ 16, "pad11" },
				{ 27, "SnrOffCl" },
				{ 31, "SnrOff" },
				{ 34, "SnrOffOp" },
				{ 36, "kick" },
				{ 37, "SnrCl" },
				{ 38, "Snare" },
				{ 40, "SnrOp" },
				{ 42, "hhCl" },
				{ 43, "tom3" },
				{ 44, "hhFtCl" },
				{ 46, "hhOp" },
				{ 47, "tom2" },
				{ 48, "tom1" },
				{ 49, "crashE" },
				{ 51, "ride" },
				{ 52, "rideE" },
				{ 53, "rideC" },
				{ 55, "crashC" },
				{ 56, "pad12" },
				{ 57, "pad9" },
				{ 59, "crash" },
				{ 78, "hhOpE" },
				{ 79, "hhClE" },
				{ 83, "hhSplsh" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "YAMAHA DTXPLORER", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 31, "Snare" },
				{ 33, "Bass" },
				{ 34, "Snare OpenRim" },
				{ 37, "Snare CloseRim" },
				{ 42, "HHClose" },
				{ 43, "Tom3" },
				{ 44, "HHFootClose" },
				{ 46, "HHOpen" },
				{ 47, "Tom2" },
				{ 48, "Tom1" },
				{ 49, "Crash" },
				{ 51, "Ride" },
				{ 52, "Ride Edge" },
				{ 55, "AUX" },
				{ 57, "Crash Edge" },
				{ 85, "HHFootSprash" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "YAMAHA DTXv2.0 (Kit33)", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 13, "Tom1 Rim" },
				{ 14, "Tom2 Rim" },
				{ 15, "Tom3 Rim" },
				{ 16, "HH Rim" },
				{ 17, "Tom4 Rim" },
				{ 20, "FootSprash" },
				{ 33, "Bass2" },
				{ 34, "Snare Rim" },
				{ 36, "Bass1" },
				{ 40, "Snare" },
				{ 42, "HHClose" },
				{ 43, "Tom4" },
				{ 44, "FootClose" },
				{ 45, "Tom3" },
				{ 46, "HHOpen" },
				{ 47, "Tom2" },
				{ 48, "Tom1" },
				{ 49, "Crash" },
				{ 53, "Ride Rim / PAD10/11" },
				{ 55, "Crash Rim" },
				{ 56, "PAD12" },
				{ 59, "Ride" },
				{ 83, "Crash Mute" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "Roland TD-20", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 22, "HHClose Rim" },
				{ 23, "BrushSweep" },
				{ 25, "Ride Edge" },
				{ 26, "HHOpen Rim" },
				{ 27, "AUX1" },
				{ 28, "AUX1 Rim" },
				{ 29, "AUX2" },
				{ 30, "AUX2 Rim" },
				{ 31, "AUX3" },
				{ 32, "AUX3 Rim" },
				{ 33, "AUX4" },
				{ 34, "AUX4 Rim" },
				{ 35, "Bass Rim" },
				{ 36, "Bass" },
				{ 37, "X-Stick" },
				{ 38, "Snare" },
				{ 39, "Tom4 Rim" },
				{ 40, "Snare Rim" },
				{ 41, "Tom4" },
				{ 42, "HHClose" },
				{ 43, "Tom3" },
				{ 44, "HHPedal" },
				{ 45, "Tom2" },
				{ 46, "HHOpen" },
				{ 47, "Tom2 Rim" },
				{ 48, "Tom1" },
				{ 49, "Crash1" },
				{ 50, "Tom1 Rim" },
				{ 51, "Ride" },
				{ 52, "Crash2 Rim" },
				{ 53, "Ride Rim" },
				{ 55, "Crash1 Rim" },
				{ 57, "Crash2" },
				{ 58, "Tom3 Rim" },
				{ 59, "Ride Edge Rim" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "Roland TD-12", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 22, "HHClose Rim" },
				{ 23, "BrushSweep" },
				{ 25, "Ride Edge" },
				{ 26, "HHOpen Rim" },
				{ 27, "AUX1" },
				{ 28, "AUX1 Rim" },
				{ 29, "AUX2" },
				{ 30, "AUX2 Rim" },
				{ 35, "Bass Rim" },
				{ 36, "Bass" },
				{ 37, "X-Stick" },
				{ 38, "Snare" },
				{ 40, "Snare Rim" },
				{ 42, "HHClose" },
				{ 43, "Tom3" },
				{ 44, "HHPedal" },
				{ 45, "Tom2" },
				{ 46, "HHOpen" },
				{ 47, "Tom2 Rim" },
				{ 48, "Tom1" },
				{ 49, "Crash1" },
				{ 50, "Tom1 Rim" },
				{ 51, "Ride" },
				{ 52, "Crash2 Rim" },
				{ 53, "Ride Rim" },
				{ 55, "Crash1 Rim" },
				{ 57, "Crash2" },
				{ 58, "Tom3 Rim" },
				{ 59, "Ride Edge Rim" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "Roland TD-9", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 0, "Tambourine1" },
				{ 1, "Tambourine2" },
				{ 2, "AfricaJingle" },
				{ 3, "MetalCrasher" },
				{ 4, "Bendir" },
				{ 5, "RainStick" },
				{ 6, "78Guiro" },
				{ 7, "78Tambourine" },
				{ 8, "808Clap" },
				{ 9, "808Cowbell1" },
				{ 10, "808Maracas" },
				{ 11, "909Clap" },
				{ 12, "Hl-Q" },
				{ 13, "MetalSlap" },
				{ 14, "Scratch1" },
				{ 15, "Scratch3" },
				{ 16, "Sticks" },
				{ 17, "Click" },
				{ 18, "Metro Click" },
				{ 19, "Metro Bell" },
				{ 20, "Clap1" },
				{ 21, "VibraSlap" },
				{ 22, "Custom HHE" },
				{ 24, "Beep" },
				{ 25, "Crotale" },
				{ 26, "Custom HHE" },
				{ 27, "16inch Maple T4" },
				{ 28, "16inch Maple T4R" },
				{ 29, "Guiro Short" },
				{ 30, "Guiro Long" },
				{ 31, "Cuica H" },
				{ 32, "Cuica L" },
				{ 33, "Cowbell1" },
				{ 34, "Cowbell2" },
				{ 35, "Custom K" },
				{ 36, "Make K" },
				{ 37, "CrossStick1" },
				{ 38, "Custom S" },
				{ 39, "16'' Maple T4R" },
				{ 40, "Custom SR" },
				{ 41, "16'' Maple T4" },
				{ 42, "Custom HH" },
				{ 43, "14'' Maple T3" },
				{ 44, "Custom HHE" },
				{ 45, "12'' Maple T2" },
				{ 46, "Custom HH" },
				{ 47, "12'' Maple T2R" },
				{ 48, "10'' Maple T1" },
				{ 49, "16'' Fast CrBw" },
				{ 50, "10'' Maple T1R" },
				{ 51, "20'' Custom Rd" },
				{ 52, "18'' Power CrE" },
				{ 53, "20'' Custom RdB" },
				{ 54, "Tambourine1" },
				{ 55, "16'' Fast CrE" },
				{ 56, "Cowbell3" },
				{ 57, "18'' Power CrBw" },
				{ 58, "14'' Maple T3R" },
				{ 59, "20'' Custom RdE" },
				{ 60, "BongoH" },
				{ 61, "BongoL" },
				{ 62, "Conga Open" },
				{ 63, "Conga Slap" },
				{ 64, "Conga Lo" },
				{ 65, "TimbaleH" },
				{ 66, "TimbaleL" },
				{ 67, "AgogoH" },
				{ 68, "AgogoL" },
				{ 69, "Cabasa" },
				{ 70, "Maracas" },
				{ 71, "Whistle Short" },
				{ 72, "Whistle" },
				{ 73, "Guiro Short" },
				{ 74, "Guiro Long" },
				{ 75, "Claves" },
				{ 76, "WoodBlockH" },
				{ 77, "WoodBlockL" },
				{ 78, "Cuica H" },
				{ 79, "Cuica L" },
				{ 80, "Triangle Cl/Op" },
				{ 81, "Triangle" },
				{ 82, "Shaker" },
				{ 83, "SleighBell" },
				{ 84, "BellTree" },
				{ 85, "Castanet" },
				{ 86, "Surdo Mute" },
				{ 87, "Surdo Open" },
				{ 88, "Repinique Rim" },
				{ 89, "Repinique M/O" },
				{ 90, "Conga Mute" },
				{ 91, "Conga Lo" },
				{ 92, "PendeiroJngl" },
				{ 93, "PendeiroThmb" },
				{ 94, "PendeiroSlap" },
				{ 95, "TreeChimes" },
				{ 96, "Crotale" },
				{ 97, "Gong" },
				{ 98, "Cajon Bass" },
				{ 99, "Cajon Open" },
				{ 100, "Cajon Slap" },
				{ 101, "Cowbell1 Tip" },
				{ 102, "WoodBlockH" },
				{ 103, "Caxixi" },
				{ 104, "TimbaleRim" },
				{ 105, "RimbalePaila" },
				{ 106, "Cuica H" },
				{ 107, "Surdo Open" },
				{ 108, "Surdo Mute" },
				{ 109, "PotDrum" },
				{ 110, "Quijada" },
				{ 111, "PotDrum Mute" },
				{ 112, "Djembe" },
				{ 113, "Djembe Slap" },
				{ 114, "Djembe Bass" },
				{ 115, "Taiko" },
				{ 116, "Wa-Daiko" },
				{ 117, "Tabla Na" },
				{ 118, "Tabla Te" },
				{ 119, "Tabla Ti" },
				{ 120, "Tabla Tum" },
				{ 121, "Baya Ge" },
				{ 122, "Baya Gin" },
				{ 123, "Baya Ka" },
				{ 124, "Baya Slide" },
				{ 125, "ConcertBD" },
				{ 126, "HandCymbal" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "Roland TD-7", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 35, "Kick2 (R1)" },
				{ 36, "Kick1 (T1)" },
				{ 38, "Snare1 (T2)" },
				{ 39, "Hand Clap (R5)" },
				{ 40, "Snare2 (R2)" },
				{ 41, "Tom4 (T7)" },
				{ 44, "PEDAL" },
				{ 45, "Tom3 (T6)" },
				{ 46, "OpenHiHat (T3R3)" },
				{ 48, "Tom2 (T5)" },
				{ 49, "Crash Cymbal (T9)" },
				{ 50, "Tom1 (T4)" },
				{ 51, "Ride Cymbal (T8)" },
				{ 52, "China Chimbal (R9)" },
				{ 53, "Ride Bell (R8)" },
				{ 55, "Crash Cymbal (R4)" },
				{ 56, "Cowbell (R6)" },
				{ 57, "Crash Cymbal (R7)" },
				//-----------------
				#endregion
			} );
			this.Profiles.Add( "Roland TD-6 (Kit1)", new CSerializableDictionary<int, string>() {
				#region [ *** ]
				//-----------------
				{ 18, "Bs Slide" },
				{ 19, "GtScrach" },
				{ 20, "Gt Slide" },
				{ 21, "CutGtDwn" },
				{ 22, "CutGtUp" },
				{ 23, "WahGtDw1" },
				{ 24, "WahGtUp1" },
				{ 25, "WahGtDw2" },
				{ 26, "WahGtUp2" },
				{ 27, "Hi-Q" },
				{ 28, "Mtl Slap" },
				{ 29, "Scrach 3" },
				{ 30, "Scrach 2" },
				{ 31, "Sticks" },
				{ 32, "Click" },
				{ 33, "MetroClk" },
				{ 34, "MetroBell" },
				{ 35, "Std1 2 K" },
				{ 36, "Std1 1 K" },
				{ 37, "CrsStk 3" },
				{ 38, "Std1 1 S" },
				{ 39, "Clap" },
				{ 40, "Std1 2 S" },
				{ 41, "Std 1 T6" },
				{ 42, "Std1 CH" },
				{ 43, "Std 1 T5" },
				{ 44, "Std1 PdH" },
				{ 45, "Std 1 T4" },
				{ 46, "Std1 EOH" },
				{ 47, "Std 1 T3" },
				{ 48, "Std 1 T2" },
				{ 49, "Med16 Cr" },
				{ 50, "Std 1 T1" },
				{ 51, "Pop Rd" },
				{ 52, "China18''" },
				{ 53, "Pop RdB" },
				{ 54, "Tambrn 1" },
				{ 55, "Splsh12''" },
				{ 56, "Cowbell1" },
				{ 57, "Quik16Cr" },
				{ 58, "VibraSlp" },
				{ 59, "Pop RdE" },
				{ 60, "R8Bng Hi" },
				{ 61, "R8Bng Lo" },
				{ 62, "Conga Mt" },
				{ 63, "Conga Sl" },
				{ 64, "Conga Op" },
				{ 65, "Tmbl1 Rm" },
				{ 66, "Tmbl1 Lo" },
				{ 67, "Agogo Hi" },
				{ 68, "Agogo Lo" },
				{ 69, "CasabaUp" },
				{ 70, "Maracas" },
				{ 71, "Whisl sh" },
				{ 72, "Whistle" },
				{ 73, "GuiroSht" },
				{ 74, "GiroLng1" },
				{ 75, "Claves" },
				{ 76, "WdBlk Hi" },
				{ 77, "WdBlk Lo" },
				{ 78, "CuicaMtl" },
				{ 79, "Cuica Op" },
				{ 80, "TringMt" },
				{ 81, "TringOp" },
				{ 82, "Shaker" },
				{ 83, "Sleibell" },
				{ 84, "BellTree" },
				{ 85, "castanet" },
				{ 86, "SurdoLMt" },
				{ 87, "SurdoLOp" },
				{ 88, "OFF" },
				{ 89, "R8Cng Hi" },
				{ 90, "TinyGong" },
				{ 91, "Gong" },
				{ 92, "PandroMt" },
				{ 93, "PandroOp" },
				{ 94, "PandroSl" },
				{ 95, "TreeChim" },
				{ 96, "Caxixi" },
				//-----------------
				#endregion
			} );
		}


		// ISerializableXML の実装

		public void t規定の初期化()
		{
		}
	}
}
