﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CInput : IDisposable
	{
		/// <summary>
		/// <para>入力デバイスの管理。</para>
		/// <para>任意の１つのウィンドウに関連づけられて生成される。</para>
		/// <para>例）ダイアログウィンドウなどで使用する場合は、一度メインウィンドウの Input管理 を Dispose し、ダイアログ用の Input管理 を生成する。</para>
		/// </summary>
		public CInput管理 Input管理
		{
			get
			{
				return this._Input管理;
			}
			set
			{
				this._Input管理 = value;

				// 内部状態を初期化。

				this.listMIDI入力イベント = new List<CInputEvent>();
			}
		}

		/// <summary>Key のリストを持つ Pad のリスト。</summary>
		public CKeyAssign KeyAssign
		{
			get;
			set;	// C入力割当ウィンドウから更新される。
		}

		/// <summary>MIDIコードからノート名を引き当てる。代表的なマシンについて定義している。</summary>
		public CMidiNoteNameMappings MidiNoteNameMappings
		{
			get;
			protected set;
		}

		/// <summary>
		/// <para>MIDI入力イベントのリスト。ポーリングするたびに更新される。</para>
		/// <para>MIDI入力以外のデバイスについては、Input管理.Keyboard などを直接参照すること。</para>
		/// </summary>
		public List<CInputEvent> listMIDI入力イベント
		{
			get;
			protected set;
		}


		public CInput()
		{
			//this._Input管理 = ...	→ ウィンドウに依存するので、ウィンドウ生成後に設定すること。
			this.MidiNoteNameMappings = CXMLFile<CMidiNoteNameMappings>.t読み込む( Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_MIDINOTE_NAME_MAPPINGS ) );
			this.KeyAssign = CXMLFile<CKeyAssign>.t読み込む( Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_KEY_ASSIGN ) );
			this.KeyAssign.tdicチップtoPadの初期化( this.KeyAssign );
			this.listMIDI入力イベント = new List<CInputEvent>();
		}

		#region [ IDispose 実装 ]
		//-----------------
		public void Dispose()
		{
			this.tmポーリング用PCタイマ.Dispose();

			if( this._Input管理 != null )	// 初期状態ではnull
				this._Input管理.Dispose();

			CXMLFile<CKeyAssign>.t保存する( this.KeyAssign, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_KEY_ASSIGN ) );
			CXMLFile<CMidiNoteNameMappings>.t保存する( this.MidiNoteNameMappings, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_MIDINOTE_NAME_MAPPINGS ) );
		}
		//-----------------
		#endregion

		public void tポーリング()
		{
			// 時刻補正用パラメータを更新。

			this.n前回のポーリングPCシステム時刻ms = this.n今回のポーリングPCシステム時刻ms;
			this.n今回のポーリングPCシステム時刻ms = this.tmポーリング用PCタイマ.nシステム時刻ms;
			this.n前回のポーリングST現在時刻ms = this.n今回のポーリングST現在時刻ms;
			this.n今回のポーリングST現在時刻ms = ( Global.SoundTimer != null ) ? Global.SoundTimer.n現在時刻ms : 0;


			// ポーリングを行う。

			this._Input管理.tポーリング( true, true );


			// ポーリングデータから MIDI入力 だけを拾い上げ、listMIDI入力イベント に格納する。

			this.listMIDI入力イベント = new List<CInputEvent>();	// ポーリングごとにクリアする。

			for( int nID = 0; nID < this._Input管理.nMidiIn数; nID++ )
			{
				IInputDevice dev = this._Input管理.MidiIn( nID );
				foreach( var ie in dev.list入力イベント )
				{
					ie.nTimeStamp = ( ie.nTimeStamp - n前回のポーリングPCシステム時刻ms ) + n前回のポーリングST現在時刻ms;	// PCシステム時刻をSoundTimerでの現在時刻に変換。
					this.listMIDI入力イベント.Add( ie );
				}
			}

		}
		public bool bチップが押された( Eチップ eチップ )
		{
			foreach( var ev in this.listMIDI入力イベント )
			{
				foreach( var key in Global.Input.KeyAssign.dicチップtoPad[ eチップ ].Keys )
				{
					if( string.IsNullOrEmpty( key.DeviceGUID ) )
					{
						// (A) Joystick以外の場合
						if( ev.ID == key.DeviceID && ev.nKey == key.Note && ev.b押された )
							return true;
					}
					else
					{
						// (B) Joystick の場合
						if( ev.guid.Equals( key.DeviceGUID ) && ev.nKey == key.Note && ev.b押された )
							return true;
					}
				}
			}
			return false;
		}
		
		public bool bシンバル類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.China ) ||
					this.bチップが押された( Eチップ.LeftCrash ) ||
					this.bチップが押された( Eチップ.Ride ) ||
					this.bチップが押された( Eチップ.Ride_Cup ) ||
					this.bチップが押された( Eチップ.RightCrash ) ||
					this.bチップが押された( Eチップ.Splash );
			}
		}
		public bool bスネア類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.Snare ) ||
					this.bチップが押された( Eチップ.Snare_ClosedRim ) ||
					this.bチップが押された( Eチップ.Snare_Ghost ) ||
					this.bチップが押された( Eチップ.Snare_OpenRim );
			}
		}
		public bool bハイタム類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.Tom1 ) ||
					this.bチップが押された( Eチップ.Tom1_Rim );
			}
		}
		public bool bロータム類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.Tom2 ) ||
					this.bチップが押された( Eチップ.Tom2_Rim );
			}
		}
		public bool bフロアタム類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.Tom3 ) ||
					this.bチップが押された( Eチップ.Tom3_Rim );
			}
		}
		public bool bハイハット類のいずれかが押された
		{
			get
			{
				return
					this.bチップが押された( Eチップ.HiHat_Close ) ||
					this.bチップが押された( Eチップ.HiHat_Foot ) ||
					this.bチップが押された( Eチップ.HiHat_HalfOpen ) ||
					this.bチップが押された( Eチップ.HiHat_Open );
			}
		}

		/// <summary>
		/// <para>ドラム入力でフォームコントロールの操作を行うメソッド。</para>
		/// <para>一定間隔で呼び出すこと。（System.Windows.Form.Timer.Tick イベントなどのハンドラを使うなど）</para>
		/// </summary>
		public void tドラムでFormを操作する( Form form )
		{
			this.tポーリング();

			foreach( var ie in this.listMIDI入力イベント )
			{
				if( !ie.b押された )
					continue;		// 押されていないキーは無視。

				if( this.bハイタム類のいずれかが押された )
				{
					#region [ 現在フォーカスされているコントロールを取得。]
					//-----------------
					Control active = form.ActiveControl;

					if( active == null )
						break;
					//-----------------
					#endregion
					#region [ (A) RadioButton … 前に移動する。]
					//-----------------
					if( ( active as RadioButton ) != null )
						SendKeys.SendWait( "{UP}" );
					//-----------------
					#endregion
					#region [ (B) CheckBox … チェックを反転する。]
					//-----------------
					else if( ( active as CheckBox ) != null )
						( (CheckBox) active ).Checked = !( (CheckBox) active ).Checked;
					//-----------------
					#endregion
					#region [ (C) NumericUpDown … 値を増やす。]
					//-----------------
					else if( ( active as NumericUpDown ) != null )
						( (NumericUpDown) active ).UpButton();
					//-----------------
					#endregion
					#region [ (D) TabControl … タブを次に移動。]
					//-----------------
					else if( ( active as TabControl ) != null )
					{
						var tabCtrl = active as TabControl;
						int nタブ番号 = tabCtrl.SelectedIndex + 1;

						if( nタブ番号 >= tabCtrl.TabPages.Count )
							nタブ番号--;

						tabCtrl.SelectedIndex = nタブ番号;
					}
					//-----------------
					#endregion
					#region [ (E) ListView … 次のアイテムにカーソルとフォーカスを移動。]
					//-----------------
					else if( ( active as ListView ) != null )
					{
						var listView = active as ListView;

						if( listView.Items.Count > 0 )	// 念のため
						{
							int n = listView.Items.IndexOf( listView.FocusedItem );

							if( ( n - 1 ) >= 0 )
							{
								listView.Items[ n - 1 ].Focused = true;
								listView.Items[ n - 1 ].Selected = true;
							}
						}
					}
					//-----------------
					#endregion
				}
				if( this.bロータム類のいずれかが押された )
				{
					#region [ 現在フォーカスされているコントロールを取得。]
					//-----------------
					Control active = form.ActiveControl;

					if( active == null )
						break;
					//-----------------
					#endregion
					#region [ (A) RadioButton … 次に移動する。]
					//-----------------
					if( ( active as RadioButton ) != null )
					{
						SendKeys.SendWait( "{DOWN}" );
					}
					//-----------------
					#endregion
					#region [ (B) CheckBox … チェックを反転する。]
					//-----------------
					else if( ( active as CheckBox ) != null )
					{
						( (CheckBox) active ).Checked = !( (CheckBox) active ).Checked;
					}
					//-----------------
					#endregion
					#region [ (C) NumericUpDown … 値を減らす。]
					//-----------------
					else if( ( active as NumericUpDown ) != null )
					{
						( (NumericUpDown) active ).DownButton();
					}
					//-----------------
					#endregion
					#region [ (D) TabControl … タブを前に移動 ]
					//-----------------
					else if( ( active as TabControl ) != null )
					{
						var tabCtrl = active as TabControl;
						int nタブ番号 = tabCtrl.SelectedIndex - 1;

						if( nタブ番号 < 0 )
							nタブ番号++;

						tabCtrl.SelectedIndex = nタブ番号;
					}
					//-----------------
					#endregion
					#region [ (E) ListView … 次のアイテムにカーソルとフォーカスを移動。]
					//-----------------
					else if( ( active as ListView ) != null )
					{
						var listView = active as ListView;

						if( listView.Items.Count > 0 )	// 念のため
						{
							int n = listView.Items.IndexOf( listView.FocusedItem );

							if( ( n + 1 ) < listView.Items.Count )
							{
								listView.Items[ n + 1 ].Focused = true;
								listView.Items[ n + 1 ].Selected = true;
							}
						}
					}
					//-----------------
					#endregion
				}
				if( this.bスネア類のいずれかが押された )
				{
					#region [ フォーカスを前に移動 ]
					//-----------------
					SendKeys.SendWait( "+{TAB}" );	// Shift+TAB
					//-----------------
					#endregion
				}
				if( this.bフロアタム類のいずれかが押された )
				{
					#region [ フォーカスを次に移動 ]
					//-----------------
					SendKeys.SendWait( "{TAB}" );
					//-----------------
					#endregion
				}
				if( this.bシンバル類のいずれかが押された )
				{
					#region [ アクティブコントロールを取得。]
					//-----------------
					Control active = form.ActiveControl;

					if( active == null )
						break;
					//-----------------
					#endregion
					#region [ (A) CheckBox … チェックを反転する。]
					//-----------------
					else if( ( active as CheckBox ) != null )
					{
						( (CheckBox) active ).Checked = !( (CheckBox) active ).Checked;
					}
					//-----------------
					#endregion
					#region [ (その他) 確定 ]
					//-----------------
					form.AcceptButton.PerformClick();
					//-----------------
					#endregion
				}
			}
		}

		/// <summary>
		/// <para>見つからなければ、eチップ==Eチップ.Unknown を返す（e演奏レーンは無効）。</para>
		/// </summary>
		public void t入力イベントに対応する演奏レーンとチップを取得する( CInputEvent ie入力イベント, out E演奏レーン e演奏レーン, out Eチップ eチップ )
		{
			foreach( var kvp in Global.Input.KeyAssign.dicチップtoPad )
			{
				eチップ = kvp.Key;
				CKeyAssign.Pad pad = kvp.Value;

				foreach( var key in pad.Keys )
				{
					if( string.IsNullOrEmpty( ie入力イベント.guid ) )
					{
						// (A) Joystick 以外の場合

						if( ie入力イベント.ID == key.DeviceID &&
							ie入力イベント.nKey == key.Note )
						{
							e演奏レーン = Global.Stage.演奏.tチップが属する演奏レーンを返す( eチップ );
							return;
						}
					}
					else
					{
						// (B) Joystick の場合

						if( ie入力イベント.guid.Equals( key.DeviceGUID ) &&
							ie入力イベント.nKey == key.Note )
						{
							e演奏レーン = Global.Stage.演奏.tチップが属する演奏レーンを返す( eチップ );
							return;
						}
					}
				}
			}


			// 対応するチップもレーンもなかった

			eチップ = Eチップ.Unknown;
			e演奏レーン = E演奏レーン.Unknown;
		}


		long n前回のポーリングPCシステム時刻ms = 0;
		long n今回のポーリングPCシステム時刻ms = 0;
		long n前回のポーリングST現在時刻ms = 0;
		long n今回のポーリングST現在時刻ms = 0;

		CTimer tmポーリング用PCタイマ = new CTimer( CTimer.E種別.MultiMedia );
		CInput管理 _Input管理;
	}
}
