﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	class CVirtualDrums : IDisposable
	{
		// プロパティ

		public const int nドラムキットのチップ別音声多重度 = 2;

		/// <summary>
		/// <para>ドラムキット。</para>
		/// <para>Config.KitListFiles で指定する。</para>
		/// </summary>
		public CKitList KitList;


		// メソッド

		public CVirtualDrums()
		{
			this.KitList = new CKitList();
		}
		
		public void tチップに対応するサウンド対応表を構築しサウンドインスタンスを生成する()
		{
			this.dicチップ対サウンド対応表 = new Dictionary<Eチップ, List<CSound>>();
			this.dicチップサウンド再生インデックス = new Dictionary<Eチップ, int>();

			// すべてのEチップについて…
			foreach( var obj in Enum.GetValues( typeof( Eチップ ) ) )
			{
				var eチップ = (Eチップ) obj;


				// 再生インデックス初期化。

				this.dicチップサウンド再生インデックス.Add( eチップ, 0 );


				// チップに対応するファイル名を取得。

				string path = this.KitList.tチップに対応するサウンドファイル名を取得する( eチップ );

				if( string.IsNullOrEmpty( path ) )
					continue;


				// サウンドを生成。

				this.dicチップ対サウンド対応表[ eチップ ] = new List<CSound>();

				for( int i = 0; i < CVirtualDrums.nドラムキットのチップ別音声多重度; i++ )
				{
					var sound = Global.SoundDevice.tサウンドを作成する( path );
					this.dicチップ対サウンド対応表[ eチップ ].Add( sound );

					if( sound != null )
						sound.n音量 = 100;		// 初期音量を最大音量（原音）に設定。
				}
			}
		}

		/// <summary>
		/// <para>n音量の値域は Global.nチップの最小音量 ～ Global.nチップの最大音量 まで。</para>
		/// </summary>
		public void tドラムサウンドを再生する( Eチップ eチップ, int n音量 )
		{
			#region [ HiHat の場合、現在再生されているHiHatサウンドがあればすべて再生停止する。]
			//-----------------
			if( this.tチップがHiHatである( eチップ ) )
			{
				foreach( var kvp in this.dicチップ対サウンド対応表 )
				{
					if( this.tチップがHiHatである( kvp.Key ) )
					{
						foreach( var bs in kvp.Value )
						{
							if( bs != null )
								bs.t停止する();
						}
					}
				}
			}
			//-----------------
			#endregion


			// 再生する DirectShow を取得。

			int n次に鳴らすサウンドのインデックス = this.dicチップサウンド再生インデックス[ eチップ ];
			var sound = this.dicチップ対サウンド対応表[ eチップ ][ n次に鳴らすサウンドのインデックス ];
			if( sound == null )
				return;


			// 音量を設定。

			double db縮小率 = (double) n音量 * ( 1.0 / ( Cチップ.n最大音量 - Cチップ.n最小音量 + 1 ) );
			sound.n音量 = (int) ( 100 * db縮小率 );


			// 位置を設定。Config.xml で左右配置を変えられるチップが対象。

			if( ( ( eチップ == Eチップ.China ) && ( Global.User.Config.ChinaLeft ) ) ||
				( ( eチップ == Eチップ.Splash ) && ( Global.User.Config.SplashLeft ) ) ||
				( ( eチップ == Eチップ.Ride ) && ( Global.User.Config.RideLeft ) ) ||
				( ( eチップ == Eチップ.Ride_Cup ) && ( Global.User.Config.RideLeft ) ) )
			{
				sound.n位置 = -35;
			}
			if( ( ( eチップ == Eチップ.China ) && ( !Global.User.Config.ChinaLeft ) ) ||
				( ( eチップ == Eチップ.Splash ) && ( !Global.User.Config.SplashLeft ) ) ||
				( ( eチップ == Eチップ.Ride ) && ( !Global.User.Config.RideLeft ) ) ||
				( ( eチップ == Eチップ.Ride_Cup ) && ( !Global.User.Config.RideLeft ) ) )
			{
				sound.n位置 = +35;
			}


			// 再生開始。

			sound.t先頭から再生する();


			// 次に鳴らすサウンドのローテーション。

			if( ++this.dicチップサウンド再生インデックス[ eチップ ] >= CVirtualDrums.nドラムキットのチップ別音声多重度 )
				this.dicチップサウンド再生インデックス[ eチップ ] = 0;
		}

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			if( this.dicチップ対サウンド対応表 != null )
			{
				foreach( var kvp in this.dicチップ対サウンド対応表 )
				{
					for( int i = 0; i < kvp.Value.Count; i++ )
					{
						if( kvp.Value[ i ] != null )
							kvp.Value[ i ].Dispose();
					}
				}
				this.dicチップ対サウンド対応表 = null;
			}

			this.KitList = new CKitList();
		}
		//-----------------
		#endregion


		Dictionary<Eチップ, List<CSound>> dicチップ対サウンド対応表 = null;
		Dictionary<Eチップ, int> dicチップサウンド再生インデックス = null;

		bool tチップがHiHatである( Eチップ eチップ )
		{
			return
				eチップ == Eチップ.HiHat_Close ||
				eチップ == Eチップ.HiHat_Foot ||
				eチップ == Eチップ.HiHat_HalfOpen ||
				eチップ == Eチップ.HiHat_Open;
		}
	}
}
