﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Diagnostics;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	[Serializable]
	public class CKitList : ISerializableXML		// XML化対象クラスは public であり、StrokeStyleT.ISerializableXML を実装すること。
	{
		// プロパティ（保存される）

		public string KitName = "";

		public string LeftCrash = "";		// 各サウンドのファイル名はすべて絶対パス。ファイル上ではマクロ付き。
		public string Ride = "";
		public string RideCup = "";
		public string China = "";
		public string Splash = "";
		public string HiHatClose = "";
		public string HiHatHalfOpen = "";
		public string HiHatOpen = "";
		public string FootPedal = "";
		public string Snare = "";
		public string SnareOpenRimShot = "";
		public string SnareClosedRimShot = "";
		public string SnareGhost = "";
		public string Bass = "";
		public string Tom1 = "";
		public string Tom1RimShot = "";
		public string Tom2 = "";
		public string Tom2RimShot = "";
		public string Tom3 = "";
		public string Tom3RimShot = "";
		public string RightCrash = "";

		
		// プロパティ（保存されない）

		[XmlIgnore]
		internal string this[ E仮想ドラム出力パッド pad ]
		{
			get
			{
				switch( pad )
				{
					case E仮想ドラム出力パッド.LeftCrash: return this.LeftCrash;
					case E仮想ドラム出力パッド.Ride: return this.Ride;
					case E仮想ドラム出力パッド.RideCup: return this.RideCup;
					case E仮想ドラム出力パッド.China: return this.China;
					case E仮想ドラム出力パッド.Splash: return this.Splash;
					case E仮想ドラム出力パッド.HiHatClose: return this.HiHatClose;
					case E仮想ドラム出力パッド.HiHatHalfOpen: return this.HiHatHalfOpen;
					case E仮想ドラム出力パッド.HiHatOpen: return this.HiHatOpen;
					case E仮想ドラム出力パッド.FootPedal: return this.FootPedal;
					case E仮想ドラム出力パッド.Snare: return this.Snare;
					case E仮想ドラム出力パッド.SnareOpenRimShot: return this.SnareOpenRimShot;
					case E仮想ドラム出力パッド.SnareClosedRimShot: return this.SnareClosedRimShot;
					case E仮想ドラム出力パッド.SnareGhost: return this.SnareGhost;
					case E仮想ドラム出力パッド.Bass: return this.Bass;
					case E仮想ドラム出力パッド.Tom1: return this.Tom1;
					case E仮想ドラム出力パッド.Tom1RimShot: return this.Tom1RimShot;
					case E仮想ドラム出力パッド.Tom2: return this.Tom2;
					case E仮想ドラム出力パッド.Tom2RimShot: return this.Tom2RimShot;
					case E仮想ドラム出力パッド.Tom3: return this.Tom3;
					case E仮想ドラム出力パッド.Tom3RimShot: return this.Tom3RimShot;
					case E仮想ドラム出力パッド.RightCrash: return this.RightCrash;
				}
				throw new IndexOutOfRangeException();
			}
			set
			{
				switch( pad )
				{
					case E仮想ドラム出力パッド.LeftCrash: this.LeftCrash = value; return;
					case E仮想ドラム出力パッド.Ride: this.Ride = value; return;
					case E仮想ドラム出力パッド.RideCup: this.RideCup = value; return;
					case E仮想ドラム出力パッド.China: this.China = value; return;
					case E仮想ドラム出力パッド.Splash: this.Splash = value; return;
					case E仮想ドラム出力パッド.HiHatClose: this.HiHatClose = value; return;
					case E仮想ドラム出力パッド.HiHatHalfOpen: this.HiHatHalfOpen = value; return;
					case E仮想ドラム出力パッド.HiHatOpen: this.HiHatOpen = value; return;
					case E仮想ドラム出力パッド.FootPedal: this.FootPedal = value; return;
					case E仮想ドラム出力パッド.Snare: this.Snare = value; return;
					case E仮想ドラム出力パッド.SnareOpenRimShot: this.SnareOpenRimShot = value; return;
					case E仮想ドラム出力パッド.SnareClosedRimShot: this.SnareClosedRimShot = value; return;
					case E仮想ドラム出力パッド.SnareGhost: this.SnareGhost = value; return;
					case E仮想ドラム出力パッド.Bass: this.Bass = value; return;
					case E仮想ドラム出力パッド.Tom1: this.Tom1 = value; return;
					case E仮想ドラム出力パッド.Tom1RimShot: this.Tom1RimShot = value; return;
					case E仮想ドラム出力パッド.Tom2: this.Tom2 = value; return;
					case E仮想ドラム出力パッド.Tom2RimShot: this.Tom2RimShot = value; return;
					case E仮想ドラム出力パッド.Tom3: this.Tom3 = value; return;
					case E仮想ドラム出力パッド.Tom3RimShot: this.Tom3RimShot = value; return;
					case E仮想ドラム出力パッド.RightCrash: this.RightCrash = value; return;
				}
				throw new IndexOutOfRangeException();
			}
		}


		// メソッド（保存されない）

		internal static CKitList t読み込む( string strFileName )
		{
			CKitList kitList = null;


			//  KitList.xml ファイルの読み込み

			kitList = CXMLFile<CKitList>.t読み込む( strFileName );

			if( string.IsNullOrEmpty( kitList.KitName ) )
				kitList.KitName = "(no name)";

	
			// 各 string プロパティのマクロを展開する。

			foreach( var obj in Enum.GetValues( typeof( E仮想ドラム出力パッド ) ) )
			{
				E仮想ドラム出力パッド ePad = (E仮想ドラム出力パッド) obj;
				kitList[ ePad ] = Folder.tファイルパス内のマクロを展開する( kitList[ ePad ] );
			}

			return kitList;
		}
		internal void t保存する( string strFileName )
		{
			#region [ 各 string プロパティをマクロに置換する。]
			//-----------------
			foreach( var obj in Enum.GetValues( typeof( E仮想ドラム出力パッド ) ) )
			{
				E仮想ドラム出力パッド ePad = (E仮想ドラム出力パッド) obj;
				this[ ePad ] = Folder.tファイルパスをマクロ付きパスに変換する( this[ ePad ] );
			}
			//-----------------
			#endregion

			CXMLFile<CKitList>.t保存する( this, strFileName );

			// ここから継続して使う場合があるので、元の状態に戻しておく。

			#region [ 各 string プロパティのマクロを展開する。]
			//-----------------
			foreach( var obj in Enum.GetValues( typeof( E仮想ドラム出力パッド ) ) )
			{
				E仮想ドラム出力パッド ePad = (E仮想ドラム出力パッド) obj;
				this[ ePad ] = Folder.tファイルパス内のマクロを展開する( this[ ePad ] );
			}
			//-----------------
			#endregion
		}
		
		internal string tチップに対応するサウンドファイル名を取得する( Eチップ eチップ )
		{
			switch( eチップ )
			{
				case Eチップ.LeftCrash: return this.LeftCrash;
				case Eチップ.Ride: return this.Ride;
				case Eチップ.Ride_Cup: return this.RideCup;
				case Eチップ.China: return this.China;
				case Eチップ.Splash: return this.Splash;
				case Eチップ.HiHat_Close: return this.HiHatClose;
				case Eチップ.HiHat_HalfOpen: return this.HiHatHalfOpen;
				case Eチップ.HiHat_Open: return this.HiHatOpen;
				case Eチップ.HiHat_Foot: return this.FootPedal;
				case Eチップ.Snare: return this.Snare;
				case Eチップ.Snare_OpenRim: return this.SnareOpenRimShot;
				case Eチップ.Snare_ClosedRim: return this.SnareClosedRimShot;
				case Eチップ.Snare_Ghost: return this.SnareGhost;
				case Eチップ.Bass: return this.Bass;
				case Eチップ.Tom1: return this.Tom1;
				case Eチップ.Tom1_Rim: return this.Tom1RimShot;
				case Eチップ.Tom2: return this.Tom2;
				case Eチップ.Tom2_Rim: return this.Tom2RimShot;
				case Eチップ.Tom3: return this.Tom3;
				case Eチップ.Tom3_Rim: return this.Tom3RimShot;
				case Eチップ.RightCrash: return this.RightCrash;
			}
			return null;
		}


		// ISerializableXML の実装

		public void t規定の初期化()
		{
		}
	}
}
