﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	public partial class Cユーザ選択ウィンドウ : CDrumsControlableFormBase
	{
		/// <summary>
		/// <para>ユーザ選択画面で「確定」押下時に選択されていたユーザ名が格納される。</para>
		/// <para>「キャンセル」された場合には null が格納される。</para>
		/// </summary>
		public string stg確定されたユーザ名 = null;
	
		public Cユーザ選択ウィンドウ( Form owner )
			:base( owner )
		{
			InitializeComponent();
			this.Load += Cユーザ選択ウィンドウ_Load;
			this.listViewユーザ一覧.ListViewItemSorter = new CompareViewItem();
		}

		private class CompareViewItem : IComparer
		{
			// 概要:
			//     Compares two objects and returns a value indicating whether one is less than,
			//     equal to, or greater than the other.
			//
			// パラメータ:
			//   x:
			//     The first object to compare.
			//
			//   y:
			//     The second object to compare.
			//
			// 戻り値:
			//     Value Condition Less than zero x is less than y. Zero x equals y. Greater
			//     than zero x is greater than y.
			//
			// 例外:
			//   System.ArgumentException:
			//     Neither x nor y implements the System.IComparable interface.  -or- x and
			//     y are of different types and neither one can handle comparisons with the
			//     other.
			public int Compare( object x, object y )
			{
				ListViewItem item1 = (ListViewItem) x;
				ListViewItem item2 = (ListViewItem) y;

				// Items[] の格納順に並ぶようにする。

				if( item1.Index < item2.Index )
					return -1;
				else if( item1.Index > item2.Index )
					return +1;
				else
					return 0;
			}
		}
		private int n現在選択中のユーザのインデックス = -1;
		private bool bOKorCancel = false;

		private void listViewユーザ一覧_SelectedIndexChanged( object sender, EventArgs e )
		{
			if( this.listViewユーザ一覧.SelectedIndices.Count == 0 )
			{
				// (A) 誰も選択されていない場合

				this.n現在選択中のユーザのインデックス = -1;	// 選択ユーザなし
				this.buttonユーザを確定.Enabled = false;		// 確定ボタン無効
				this.button削除.Enabled = false;				// 削除ボタン無効
			}
			else
			{
				// (B) 誰かが選択されている場合

				this.n現在選択中のユーザのインデックス = this.listViewユーザ一覧.SelectedIndices[ 0 ];	// 選択ユーザあり
				this.buttonユーザを確定.Enabled = true;													// 確定ボタン有効

				bool bSSTFViewerユーザ選択中 =
					this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Name.Equals( Properties.Resources.DEFAULT_VIEWER_USER_NAME, StringComparison.OrdinalIgnoreCase );

				this.button削除.Enabled = bSSTFViewerユーザ選択中 ? false : true;						// 削除ボタンは、選択ユーザが SSTFViewer用ユーザの場合は無効、それ以外は有効。
			}
		}
		private void listViewユーザ一覧_Enter( object sender, EventArgs e )
		{
			// 登録されているユーザが一人もいないなら無視。

			if( this.listViewユーザ一覧.Items.Count == 0 )
				return;


			// まだ控えてなかったら先頭のユーザに初期化。

			if( this.n現在選択中のユーザのインデックス < 0 )
				this.n現在選択中のユーザのインデックス = 0;

			
			// 控えておいたユーザにフォーカス＆選択。

			this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Focused = true;
			this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Selected = true;
			this.listViewユーザ一覧.Select();
		}
		private void listViewユーザ一覧_Leave( object sender, EventArgs e )
		{
			// 誰も選択されていないなら無視。

			if( this.listViewユーザ一覧.SelectedIndices.Count == 0 )
				return;


			// 現在選択中のユーザのインデックスを控えておく。

			this.n現在選択中のユーザのインデックス = this.listViewユーザ一覧.SelectedIndices[ 0 ];
		}
		private void listViewユーザ一覧_DoubleClick( object sender, EventArgs e )
		{
			this.buttonユーザを確定.PerformClick();
		}

		private void buttonユーザを確定_Click( object sender, EventArgs e )
		{
			// 誰も選択されていないなら無視。
			if( this.n現在選択中のユーザのインデックス < 0 )
				return;

			// 確定したユーザ名を取得する。
			this.stg確定されたユーザ名 = this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Name;
			this.bOKorCancel = true;


			// 確定されたユーザが次回から先頭に表示されるようにする。
			Global.User.UserList.Users.Remove( this.stg確定されたユーザ名 );
			Global.User.UserList.Users.Insert( 0, this.stg確定されたユーザ名 );

			// UserList.xml を保存する。
			CXMLFile<CUserList>.t保存する( Global.User.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
		}
		private void buttonキャンセル_Click( object sender, EventArgs e )
		{
			this.stg確定されたユーザ名 = null;
			this.bOKorCancel = true;
		}

		private void button新規作成_Click( object sender, EventArgs e )
		{
			var dlg = new Cユーザ登録ウィンドウ( this );
			dlg.ShowDialog( this );
			if( string.IsNullOrEmpty( dlg.stg新登録ユーザ名 ) )
				return;		// キャンセルされた

			// ユーザ一覧に追加する。
			this.listViewユーザ一覧.Items.Insert( 0, dlg.stg新登録ユーザ名, dlg.stg新登録ユーザ名, 0 );	// 先頭に追加。
			this.n現在選択中のユーザのインデックス = 0;
			this.listViewユーザ一覧.Sort();
			this.listViewユーザ一覧.Select();

			// UserList.xml の先頭に登録して保存する。
			Global.User.UserList.Users.Insert( 0, dlg.stg新登録ユーザ名 );
			CXMLFile<CUserList>.t保存する( Global.User.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
		}
		private void button削除_Click( object sender, EventArgs e )
		{
			// 誰も選択されていないなら無視。
			if( this.n現在選択中のユーザのインデックス < 0 )
				return;

			// 削除するユーザ名とインデックスを取得。
			string stg削除ユーザ名 = this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Name;
			int n削除前のインデックス = this.n現在選択中のユーザのインデックス;

			// 削除の確認。
			var dr = MessageBox.Show( this, "本当に削除しますか？" + Environment.NewLine +"ユーザデータもすべて削除されます。", "確認", 
				MessageBoxButtons.YesNo, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2  );
			if( dr == System.Windows.Forms.DialogResult.No )
				return;

			// ユーザ一覧 から削除する。（削除すると SelectedIndexChanged イベントが発生し、n現在選択中のユーザのインデックス は -1 になる。）
			this.listViewユーザ一覧.Items.RemoveAt( this.n現在選択中のユーザのインデックス );

			// 必ずユーザは１つ以上ある（SSTFEditor用ユーザは削除不可なので）という前提で、選択ユーザを変更。
			this.n現在選択中のユーザのインデックス = n削除前のインデックス - 1;

			if( this.n現在選択中のユーザのインデックス < 0 )
				this.n現在選択中のユーザのインデックス = 0;

			this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Focused = true;
			this.listViewユーザ一覧.Items[ this.n現在選択中のユーザのインデックス ].Selected = true;
			this.listViewユーザ一覧.Select();

			// UserList.xml から削除し、保存する。
			Global.User.UserList.Users.Remove( stg削除ユーザ名 );
			CXMLFile<CUserList>.t保存する( Global.User.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
		}

		private void Cユーザ選択ウィンドウ_Load( object sender, EventArgs e )
		{
			this.stg確定されたユーザ名 = Global.User.stgログインユーザ名.Get();

			// ユーザ一覧に UserList.xml の内容を表示。
			foreach( var name in Global.User.UserList.Users )
				this.listViewユーザ一覧.Items.Add( name, name, 0 );

			// ユーザが一人（SSTFEditor用ユーザ）しかいない場合、すぐに新規登録ウィンドウを起動する。
			if( this.listViewユーザ一覧.Items.Count == 1 )
				this.button新規作成.PerformClick();
		}
		private void Cユーザ選択ウィンドウ_FormClosing( object sender, FormClosingEventArgs e )
		{
			// OK ボタンや Cancel ボタンで閉じられた訳じゃない場合、ユーザ名は無効。
			if( !this.bOKorCancel )
				this.stg確定されたユーザ名 = null;
		}
	}
}
