﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	public partial class Cユーザ登録ウィンドウ : CDrumsControlableFormBase
	{
		public string stg新登録ユーザ名 = null;

		public Cユーザ登録ウィンドウ( Form owner )
			:base( owner )
		{
			InitializeComponent();
		}

		private void textBoxユーザ名_TextChanged( object sender, EventArgs e )
		{
			// ボックスに文字が入ってたら登録ボタンを有効化。それ以外は無効化。
			this.button登録.Enabled = !string.IsNullOrEmpty( this.textBoxユーザ名.Text );
		}
		private void button登録_Click( object sender, EventArgs e )
		{
			this.stg新登録ユーザ名 = this.textBoxユーザ名.Text;

			#region [ 既に存在しているユーザの場合はやり直し。]
			//-----------------
			foreach( var name in Global.User.UserList.Users )
			{
				if( name.Equals( this.stg新登録ユーザ名, StringComparison.OrdinalIgnoreCase ) )
				{
					MessageBox.Show( "すでに存在しているユーザです。\n別の名前を指定して下さい。", "警告", MessageBoxButtons.OK );
					this.stg新登録ユーザ名 = null;
					return;
				}
			}
			//-----------------
			#endregion

			#region [ パスとして不適切な文字列ならやり直し。]
			//-----------------
			if( this.stg新登録ユーザ名.Contains( @"\" ) ||	// '\' はダメ
				this.stg新登録ユーザ名.Contains( @"/" ) )	// '/' もダメ
			{
				MessageBox.Show( @"'\'または'/'は使用できません。", "警告", MessageBoxButtons.OK );
				return;
			}

			try
			{
				Folder.tパスの正当性を確認のうえ絶対パスに変換して返す( this.stg新登録ユーザ名, Folder.stgユーザ共通フォルダ );
			}
			catch( PathTooLongException )
			{
				MessageBox.Show( "ユーザ名が長すぎます。", "警告", MessageBoxButtons.OK );
				return;
			}
			catch
			{
				MessageBox.Show( "利用できない文字が含まれています。", "警告", MessageBoxButtons.OK );
				return;
			}
			//-----------------
			#endregion

			// ウィンドウを閉じる。
			this.DialogResult = DialogResult.OK;
			this.Close();
		}
	}
}
