﻿using System;
using System.Reflection;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class Global
	{
		public static readonly int nメジャー番号 = Assembly.GetExecutingAssembly().GetName().Version.Major;
		public static readonly int nマイナー番号 = Assembly.GetExecutingAssembly().GetName().Version.Minor;
		public static readonly int nリビジョン番号 = Assembly.GetExecutingAssembly().GetName().Version.Revision;
		public static readonly int nビルド番号 = Assembly.GetExecutingAssembly().GetName().Version.Build;

		public static CApplication App
		{
			get;
			protected set;
		}
		public static ISoundDevice SoundDevice
		{
			get;
			protected set;
		}
		public static CSoundTimer SoundTimer
		{
			get;
			protected set;
		}
		public static CInput Input
		{
			get;
			protected set;
		}
		public static SystemConfig SystemConfig
		{
			get;
			protected set;
		}
		public static CUser User
		{
			get;
			protected set;
		}
		public static CStage Stage
		{
			get;
			protected set;
		}
		public static Song Song
		{
			get;
			protected set;
		}
		public static Random Random
		{
			get;
			protected set;
		}
		public static CPlayerMode PlayerMode
		{
			get;
			protected set;
		}
		public static CVirtualDrums VirtualDrums
		{
			get;
			protected set;
		}

		public static void t初期化( CApplication app )
		{
			Global.App = app;
			Global.SoundDevice = null;
			Global.SoundTimer = null;
			Global.Input = new CInput();
			Global.SystemConfig = CXMLFile<SystemConfig>.t読み込む( Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_SYSTEM_CONFIG ) );
			Global.User = new CUser();
			Global.Stage = new CStage();
			Global.Song = new Song();
			Theme.t初期化();
			Global.Random = new System.Random( (int) new CTimer( CTimer.E種別.MultiMedia ).nシステム時刻ms );
			Global.PlayerMode = new CPlayerMode();
			Global.VirtualDrums = new CVirtualDrums();

			Global.tサウンドデバイスとすべての既存サウンドを再構築する(
				Global.SystemConfig.SoundDeviceType,
				Global.SystemConfig.SoundMaxDelay,
				Global.SystemConfig.SoundUpdatePeriod );

			Global.sdダイアログ開く = Global.SoundDevice.tサウンドを作成する( Path.Combine( Folder.stgテーマフォルダ, @"Sound open.mp3" ) );
			Global.sdダイアログ閉じる = Global.SoundDevice.tサウンドを作成する( Path.Combine( Folder.stgテーマフォルダ, @"Sound close.mp3" ) );
		}
		public static void t終了()
		{
			Global.tDisposeする( ref Global.sdダイアログ開く );
			Global.tDisposeする( ref Global.sdダイアログ閉じる );

			Global.tDisposeする( Global.VirtualDrums ); Global.VirtualDrums = null;
			Global.tDisposeする( Global.PlayerMode ); Global.PlayerMode = null;
			Global.Random = null;
			Global.tDisposeする( Global.Song ); Global.Song = null;
			Global.tDisposeする( Global.Stage ); Global.Stage = null;
			Global.tDisposeする( Global.User ); Global.User = null;
			CXMLFile<SystemConfig>.t保存する( Global.SystemConfig, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_SYSTEM_CONFIG ) );
			Global.SystemConfig = null;
			Global.tDisposeする( Global.Input ); Global.Input = null;	// Input管理もDisposeされる。
			Global.tDisposeする( Global.SoundDevice ); Global.SoundDevice = null;
			Global.tDisposeする( Global.SoundTimer ); Global.SoundTimer = null;	// Global.SoundDevice の後に解放すること。（SoundDevice から参照されているため）
			//Global.App.Dispose();	→ 呼び出し側でDisposeする。
		}

		public static void tDisposeする<T>( ref T obj )
		{
			if( obj == null )
				return;

			var d = obj as IDisposable;

			if( d != null )
			{
				d.Dispose();
				obj = default( T );
			}
		}
		public static void tDisposeする<T>( T obj )
		{
			if( obj == null )
				return;

			var d = obj as IDisposable;

			if( d != null )
				d.Dispose();
		}

		public static void tダイアログ表示の前処理()
		{
			if( Global.sdダイアログ開く != null )
				Global.sdダイアログ開く.t先頭から再生する();

			if( Global.App.Direct3D.b全画面モード )
				Global.App.tマウスカーソルの表示( true );
		}
		public static void tダイアログ表示の後処理()
		{
			if( Global.sdダイアログ閉じる != null )
				Global.sdダイアログ閉じる.t先頭から再生する();

			if( Global.App.Direct3D.b全画面モード )
				Global.App.tマウスカーソルの表示( false );
		}

		public static void tサウンドデバイスとすべての既存サウンドを再構築する( ESoundDeviceType type, int maxDelay, int updatePeriod = 0 )
		{
			#region [ 既に生成済みのサウンドがあれば初期状態に戻す（インスタンスを残したままリソースだけ解放する）。 ]
			//-----------------
			if( Global.SoundDevice != null )
				CSound.tすべてのサウンドを初期状態に戻す();
			//-----------------
			#endregion

			#region [ 構築済みであれば、Global.SoundDevice と Global.SoundTimer を解放する。]
			//-----------------
			if( Global.SoundDevice != null )
			{
				Global.tDisposeする( Global.SoundDevice ); Global.SoundDevice = null;
				Global.tDisposeする( Global.SoundTimer ); Global.SoundTimer = null;	// Global.SoundDevice を解放した後に解放すること。（Global.SoundDevice で参照されているため）
			}
			//-----------------
			#endregion

			#region [ 新しい Global.SoundDevice と Global.SoundTimer を構築する。]
			//-----------------
			switch( type )
			{
				case ESoundDeviceType.ExclusiveWASAPI:
					Global.SoundDevice = new CSoundDeviceWASAPI( CSoundDeviceWASAPI.EWASAPIデバイスモード.排他, maxDelay, updatePeriod );
					break;

				case ESoundDeviceType.SharedWASAPI:
					throw new Exception( "共有モードの WASAPI はサポートしません。" );

				case ESoundDeviceType.ASIO:
					Global.SoundDevice = new CSoundDeviceASIO( maxDelay );
					break;

				default:
					throw new Exception( string.Format( "未対応の SoundDeviceType です。[{0}]", type.ToString() ) );
			}

			// タイマも生成。
			Global.SoundTimer = new CSoundTimer( Global.SoundDevice );
			//-----------------
			#endregion

			#region [ 既に生成済みのサウンドがあればリソースを作り直す。]
			//-----------------
			CSound.tすべてのサウンドを再構築する( Global.SoundDevice );
			//-----------------
			#endregion
		}
		public static void tSongListをすべて読み込んでマージする( List<string> songListFiles )
		{
			Global.Song.list曲リスト = new List<SongNode>();

			// すべての SongList について…
			foreach( string str生ファイル名 in songListFiles )
			{
				// SongList XMLファイルを１つ読み込む。
				SongList list = SongList.t読み込む( str生ファイル名 );
				if( list == null )
					continue;

				// SongList のすべてのノードを Global.Song.list曲リスト へマージ。
				foreach( SongNode s in list.Songs )
					Global.Song.list曲リスト.Add( s );

				Trace.TraceInformation( "曲リストファイル {0} から {1} 曲を検出しました。",
					Folder.tファイルパスをマクロ付きパスに変換する( str生ファイル名 ), list.Songs.Count );
			}
		}

		protected static CSound sdダイアログ開く = null;
		protected static CSound sdダイアログ閉じる = null;
	}
}
