﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Threading.Tasks;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>オブジェクト自身をXMLファイルとして保存・読み込みするために必要な機能を提供する。</para>
	/// <para>・XML化対象のクラスは、[System.Serializable] 属性を持ち、パラメータなしの public コンストラクタを持っていること。（読み込み失敗時に new するため）</para>
	/// <para>・XML化対象のクラスは、StrokeStyleT.ISerializableXML を実装していること。（読み込み失敗時の初期化に使うため）</para>
	/// </summary>
	/// <typeparam name="T">XML化する対象のクラス。</typeparam>
	public class CXMLFile<T> where T : new()
	{
		public static T t読み込む( string stgXMLファイル名 )
		{
			string stgマクロ付きパス = Folder.tファイルパスをマクロ付きパスに変換する( stgXMLファイル名 );

			T target = default( T );

			#region [ T が ISerializableXML を実装していないなら例外発出。]
			//-----------------
			try {
				var Test = (ISerializableXML) target;
			}
			catch
			{
				throw new InvalidCastException( "XML化対象クラスが ISerializableXML を実装していません。" );
			}
			//-----------------
			#endregion
			
			try
			{
				Utils.tXMLファイルを読み込む( stgXMLファイル名, out target );
				Trace.TraceInformation( "XML形式ファイルの読み込みに成功しました。[{0}]", stgマクロ付きパス );
			}
			catch( FileNotFoundException )
			{
				Trace.TraceWarning( "ファイルが存在しません。規定値を使用します。[{0}]", stgマクロ付きパス );
				target = new T();
				( (ISerializableXML) target ).t規定の初期化();
			}
			catch( Exception e )
			{
				Utils.t例外の詳細をログに出力する( e );
				Trace.TraceWarning( "ファイルの読み込みに失敗しました。規定値を使用します。[{0}]", stgマクロ付きパス );
				target = new T();
				( (ISerializableXML) target ).t規定の初期化();
			}

			return target;
		}
		public static void t保存する<U>( U xml保存対象, string stgXMLファイル名 )
		{
			string stgマクロ付きパス = Folder.tファイルパスをマクロ付きパスに変換する( stgXMLファイル名 );

			try
			{
				Utils.tXMLファイルを保存する( stgXMLファイル名, xml保存対象 );
				Trace.TraceInformation( "XML形式ファイルの保存に成功しました。[{0}]", stgマクロ付きパス );
			}
			catch( Exception e )
			{
				Utils.t例外の詳細をログに出力する( e );
				Trace.TraceError( "XML形式ファイルの保存に失敗しました。", stgマクロ付きパス );
			}
		}
	}
}
