﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Xml.Schema;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>XML形式で保存・読み込み可能な Dictionary。</para>
	/// </summary>
	public class CSerializableDictionary<Tkey, Tvalue> : Dictionary<Tkey, Tvalue>, IXmlSerializable
	{
		public class KeyValue
		{
			public Tkey Key { get; set; }
			public Tvalue Value { get; set; }
			public KeyValue() { }
			public KeyValue( Tkey key, Tvalue value ) { Key = key; Value = value; }
		}

		// IXmlSerializable の実装

		public XmlSchema GetSchema()
		{
			return null;
		}
		public void ReadXml( XmlReader reader )
		{
			var s = new XmlSerializer( typeof( KeyValue ) );

			reader.Read();
			while( reader.NodeType != XmlNodeType.EndElement )
			{
				var kv = s.Deserialize( reader ) as KeyValue;
				if( kv != null )
					Add( kv.Key, kv.Value );
			}
			reader.Read();
		}
		public void WriteXml( XmlWriter writer )
		{
			var s = new XmlSerializer( typeof( KeyValue ) );

			foreach( var key in Keys )
				s.Serialize( writer, new KeyValue( key, this[ key ] ) );
		}
	}
}
