﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>ドラムで操作させたいウィンドウはこれを継承すること。</para>
	/// </summary>
	public class CDrumsControlableFormBase : Form
	{
		// 引数無しコンストラクタはデザイナー用のダミー。
		public CDrumsControlableFormBase()
		{
		}
		public CDrumsControlableFormBase( Form owner )
		{
			this.owner = owner;
			this.bFormClosing済み = false;
			this.Load += CDrumsControlableFormBase_Load;
			this.FormClosing += CDrumsControlableFormBase_FormClosing;
		}

		// 開始
		protected void CDrumsControlableFormBase_Load( object sender, EventArgs e )
		{
			// 表示位置を決定する。
			this.StartPosition = FormStartPosition.CenterParent;	// オーナーの中央

			// オーナーウィンドウでのInput管理を終了する。
			Global.Input.Input管理.Dispose();

			// このフォームでのInput管理を開始する。
			Global.Input.Input管理 = new CInput管理( this.Handle );

			// ドラム操作割り込み開始。
			this.timer = new System.Windows.Forms.Timer();
			this.timer.Tick += ( o, args ) => {
				if( !this.evドラム操作終了指示.WaitOne( 0 ) )
					Global.Input.tドラムでFormを操作する( this );
			};
			this.timer.Start();
		}

		// 終了
		protected void CDrumsControlableFormBase_FormClosing( object sender, FormClosingEventArgs e )
		{
			if( this.bFormClosing済み )
				return;		// なんか知らんが２回呼ばれることがある。

			// ドラム割り込み終了待ち。
			this.evドラム操作終了指示.Set();	// これ以降、Global.Input.tドラムでFormを操作する() は呼び出されない。
			this.timer.Stop();
			
			// このウィンドウでのInput管理を終了する。
			Global.Input.Input管理.Dispose();

			// オーナーウィンドウでのInput管理を再開する。
			Global.Input.Input管理 = new CInput管理( this.owner.Handle );

			// 終了処理完了。
			this.bFormClosing済み = true;
		}

		private bool bFormClosing済み;
		private Form owner = null;
		private System.Windows.Forms.Timer timer = null;		// System.Threading.Timer と競合する
		private ManualResetEvent evドラム操作終了指示 = new ManualResetEvent( false );
	}
}
