﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Reflection;
using FDK;

namespace StrokeStyleT
{
	internal enum E進行結果 : int
	{
		継続,
		完了,
		キャンセル,
		曲決定,
		クリア,
		GUI割込・演奏停止,
		GUI割込・演奏開始,
	}

	class CApplication : CApplicationBase
	{
		private enum E状態
		{
			待機,
			CAUTIONステージ活性化,
			CAUTIONステージ進行描画,
			CAUTIONステージ非活性化,
			オープニングステージ活性化,
			オープニングステージ進行描画,
			オープニングステージ非活性化,
			選曲ステージ活性化,
			選曲ステージ進行描画,
			選曲ステージ非活性化,
			曲読み込み,
			演奏ステージ活性化,
			演奏ステージ進行描画,
			演奏ステージ非活性化,
			クリアステージ活性化,
			クリアステージ進行描画,
			クリアステージ非活性化,
			結果ステージ活性化,
			結果ステージ進行描画,
			結果ステージ非活性化,
			演奏動画の停止と解放,
			演奏BGMの停止と解放,
			アプリ終了,

		}

		public CApplication()
		{
			Global.t初期化( this );		// Program.Main() から参照されるので、先にこれだけ初期化。
		}

		protected override bool On初期化()
		{
			// ログ出力を開始する。

			#region [ ログファイル出力用の Trace リスナを追加する。]
			//-----------------
			Trace.AutoFlush = true;
			Trace.IndentLevel = 0;

			string path = Path.Combine( Folder.stgログ出力フォルダ, Properties.Resources.LOG_FILE_NAME );

			try
			{
				Trace.Listeners.Add(
					new CTraceLogListener(
						new StreamWriter( path, false, System.Text.Encoding.GetEncoding( "shift-jis" ) ) ) );
			}
			catch( Exception e )
			{
				MessageBox.Show( string.Format( "{0} へのリスナ追加に失敗しました。\nログファイルは出力または上書きされません。\n---------\n{1}", path, e.ToString() ), "エラー", MessageBoxButtons.OK );
				//throw;	終了しない。
			}

			Trace.WriteLine( "" );
			Trace.Write( Properties.Resources.TITLE_NORMALMODE );
			Trace.WriteLine( string.Format( " {0}.{1} (rev.{2} build.{3})", Global.nメジャー番号, Global.nマイナー番号, Global.nリビジョン番号, Global.nビルド番号 ) );
			Trace.WriteLine( "Copyright 2009 2013 (C) ProjectSST All Rights Reserved." );
			Trace.WriteLine( "" );
			//-----------------
			#endregion


			// ウィンドウの初期設定を行い、表示する。
			
			var verInfo = FileVersionInfo.GetVersionInfo( Assembly.GetExecutingAssembly().Location );
			this.Window.Text = string.Format( "{0} {1}.{2} (rev.{3} build.{4})",
				Properties.Resources.TITLE_NORMALMODE,
				Global.nメジャー番号, Global.nマイナー番号, Global.nリビジョン番号, Global.nビルド番号 );
			this.Window.ClientSize = Theme.szウィンドウ;
			this.Window.Show();


			// Direct3D デバイスの作成と初期設定を行う。

			bool b全画面モード = false;
			bool b垂直帰線同期待ち = false;		// 常に false とする。CApplicationBase クラスで独自に垂直帰線同期待ちを行っているため。
			this.Direct3D.tデバイスを作成する( this.Window.Handle, b全画面モード, b垂直帰線同期待ち );

			#region [ ビューを設定する。]
			//-----------------
			float f視野角 = 45.0f;	// 度
			int nHeight = this.Window.ClientRectangle.Height;

			this.Direct3D.SetTransform(
				TransformState.View,
				Matrix.LookAtLH(
					new Vector3( 0f, 0f, (float) ( ( -nHeight / 2.0 ) / Math.Tan( Utils.DegreeToRadian( f視野角 / 2.0 ) ) ) ),	// カメラの位置
					new Vector3( 0f, 0f, 0f ),																					// 見ているターゲット
					new Vector3( 0f, 1f, 0f ) ) );																				// 上方向
			//-----------------
			#endregion
			#region [ 射影行列を設定する。]
			//-----------------
			this.Direct3D.SetTransform(
				TransformState.Projection,
				Matrix.PerspectiveFovLH(
					Utils.DegreeToRadian( f視野角 ),												// y 方向の視野角度（ラジアン単位）
					(float) this.Window.ClientSize.Width / this.Window.ClientSize.Height,			// アスペクト比。View の幅÷高さ。
					-100.0f,																		// z（近）
					100.0f ) );																		// z（遠）
			//-----------------
			#endregion
			#region [ レンダリングステートを設定する。]
			//-----------------
			this.Direct3D.SetRenderState( RenderState.Lighting, false );
			this.Direct3D.SetRenderState( RenderState.ZEnable, false );
			this.Direct3D.SetRenderState( RenderState.AntialiasedLineEnable, false );
			this.Direct3D.SetRenderState( RenderState.AlphaTestEnable, true );
			this.Direct3D.SetRenderState( RenderState.AlphaRef, 10 );
			this.Direct3D.SetRenderState( RenderState.MultiSampleAntialias, false );
			this.Direct3D.SetRenderState<RS_CmpFunc>( RenderState.AlphaFunc, RS_CmpFunc.Greater );
			this.Direct3D.SetRenderState( RenderState.AlphaBlendEnable, true );
			this.Direct3D.SetRenderState<RS_Blend>( RenderState.SrcBlend, RS_Blend.SourceAlpha );
			this.Direct3D.SetRenderState<RS_Blend>( RenderState.DestBlend, RS_Blend.InverseSourceAlpha );
			this.Direct3D.SetTextureStageState<TSS_TextureOperation>( 0, TextureStageState.AlphaOperation, TSS_TextureOperation.Modulate );
			this.Direct3D.SetTextureStageState( 0, TextureStageState.AlphaArgument1, 2 );
			this.Direct3D.SetTextureStageState( 0, TextureStageState.AlphaArgument2, 1 );
			//-----------------
			#endregion


			// 入力デバイスの初期化を行う。

			Global.Input.Input管理 = new CInput管理( this.Window.Handle );


			// 完了。

			return base.On初期化();
		}
		protected override void On終了()
		{
			// 終了処理。

			Global.t終了();


			// ログ出力を終了する。

			Trace.WriteLine( "" );
			Trace.WriteLine( "遊んでくれてありがとう！" );
	
			#region [ Traceリスナがあれば削除する。]
			//-----------------
			for( int i = Trace.Listeners.Count - 1; i >= 1; i-- )	// 1つ（出力ウィンドウ）以上の追加リスナがあれば、すべて削除。
			{
				Trace.IndentLevel = 0;
				Trace.Listeners[ i ].Close();
				Trace.Listeners[ i ].Dispose();
				Trace.Listeners.RemoveAt( i );
			}
			//-----------------
			#endregion
		}
		protected override void Onフロー制御()
		{
			// アプリの状態遷移図にそってフローが流れるようプログラミングする。
			// this.t遷移() が EXアプリ終了例外 を出せば catch して本スレッドを終了する。

			try
			{
				this.t遷移( E状態.CAUTIONステージ活性化 );
				this.t遷移( E状態.CAUTIONステージ進行描画 );
				this.t遷移( E状態.CAUTIONステージ非活性化 );

				this.t遷移( E状態.オープニングステージ活性化 );
				this.t遷移( E状態.オープニングステージ進行描画 );
				this.t遷移( E状態.オープニングステージ非活性化 );


			L選曲ステージ開始:

				// ここの時点でログインしてないなら終了。

				if( string.IsNullOrEmpty( Global.User.stgログインユーザ名.Get() ) )
					goto Lアプリ終了;

				this.t遷移( E状態.選曲ステージ活性化 );
			
			L選曲ステージ進行描画:

				this.t遷移( E状態.選曲ステージ進行描画 );

				if( this.e状態の処理結果 == E進行結果.キャンセル )
					goto Lアプリ終了;

				
				// ここの時点で、選択曲が Global.Song.r現在演奏中の曲 (SongNode) が登録されている。

				this.t遷移( E状態.曲読み込み );


				// 曲の読み込みに失敗したら、選曲ステージに戻る。

				if( this.e状態の処理結果 != E進行結果.完了 )
					goto L選曲ステージ進行描画;

				this.t遷移( E状態.選曲ステージ非活性化 );


				// ここの時点で、
				//   ・Global.Song.r現在演奏中の曲.ScoreFile	（選曲時）
				//   ・Global.PlayerMode.stg演奏ファイル名		（プレイヤーモード時）
				// のいずれかのファイルを読み込まれ、Global.Song.r現在演奏中の曲のスコア (Cスコア) が構築されている。


				this.t遷移( E状態.演奏ステージ活性化 );
				this.t遷移( E状態.演奏ステージ進行描画 );

				if( this.e状態の処理結果 == E進行結果.キャンセル )
				{
					this.t遷移( E状態.演奏動画の停止と解放 );
					this.t遷移( E状態.演奏BGMの停止と解放 );
					this.t遷移( E状態.演奏ステージ非活性化 );
					Utils.t完全なガベージコレクションを実施する();
					goto L選曲ステージ開始;
				}

				this.t遷移( E状態.演奏動画の停止と解放 );	// BGM の解放はまだ。
				this.t遷移( E状態.演奏ステージ非活性化 );

				this.t遷移( E状態.クリアステージ活性化 );
				this.t遷移( E状態.クリアステージ進行描画 );
				this.t遷移( E状態.クリアステージ非活性化 );

				this.t遷移( E状態.結果ステージ活性化 );
				this.t遷移( E状態.結果ステージ進行描画 );
				this.t遷移( E状態.演奏BGMの停止と解放 );	// BGM はここで解放。
				this.t遷移( E状態.結果ステージ非活性化 );
				goto L選曲ステージ開始;

			Lアプリ終了:
				this.t遷移( E状態.アプリ終了 );
			}
			catch( EXアプリ終了例外 )
			{
				return;	// 帰還＝スレッドを終了。
			}
		}
		protected override bool On進行()
		{
			#region [ アプリ終了チェック ]
			//-----------------
			if( this.bアプリケーションを終了する.Get() )
			{
				Trace.TraceInformation( "進行・フロー制御スレッドを終了します。" );
				this.t完了( PART_進行 );	// これを忘れると、フロー制御スレッドが WaitAll() から帰ってこないためスレッドを終了できない。
				this.t完了( PART_描画前 );	// 描画前・描画スレッドもついでにここでセットする。描画前・描画スレッドの終了チェックは親クラスにあり、このイベントにアクセスできないため。
				this.t完了( PART_描画 );	//
				return false;
			}
			//-----------------
			#endregion

			switch( this.e現在の状態[ PART_進行 ] )
			{
				#region [ 待機 ]
				//-----------------
				case E状態.待機:
					break;
				//-----------------
				#endregion
				#region [ CAUTIONステージ進行描画 ]
				//-----------------
				case E状態.CAUTIONステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ進行描画 ]
				//-----------------
				case E状態.オープニングステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ進行描画 ]
				//-----------------
				case E状態.選曲ステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ進行描画 ]
				//-----------------
				case E状態.演奏ステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ クリアステージ進行描画 ]
				//-----------------
				case E状態.クリアステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ進行描画 ]
				//-----------------
				case E状態.結果ステージ進行描画:
					this.t現在のステージの進行();
					break;
				//-----------------
				#endregion
				#region [ アプリ終了 ]
				//-----------------
				case E状態.アプリ終了:
					Trace.TraceInformation( "アプリケーションを終了します。" );
					Global.App.bアプリケーションを終了する.Set( true );
					this.t全完了();
					break;
				//-----------------
				#endregion
				#region [ その他 ]
				//-----------------
				default:
					this.t完了( PART_進行 );
					break;
				//-----------------
				#endregion
			}
			return true;
		}
		protected override void On描画前()
		{
			// デバイスがロックされる前、On描画() の直前に呼び出される。
			// 終了チェック（「bアプリケーションの終了」のチェック）は、実行頻度の高い On進行() のほうで行うのでここでは行わない。

			switch( this.e現在の状態[ PART_描画前 ] )
			{
				#region [ 待機 ]
				//-----------------
				case E状態.待機:
					break;
				//-----------------
				#endregion
				#region [ CAUTIONステージ活性化 ]
				//-----------------
				case E状態.CAUTIONステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.Caution;
					Global.Stage.Caution.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ CAUTIONステージ非活性化 ]
				//-----------------
				case E状態.CAUTIONステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ活性化 ]
				//-----------------
				case E状態.オープニングステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.オープニング;
					Global.Stage.オープニング.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ進行描画 ]
				//-----------------
				case E状態.オープニングステージ進行描画:
					this.t現在のステージの描画前();
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ非活性化 ]
				//-----------------
				case E状態.オープニングステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ活性化 ]
				//-----------------
				case E状態.選曲ステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.選曲;
					Global.Stage.選曲.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ進行描画 ]
				//-----------------
				case E状態.選曲ステージ進行描画:
					this.t現在のステージの描画前();
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ非活性化 ]
				//-----------------
				case E状態.選曲ステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 曲読み込み ]
				//-----------------
				case E状態.曲読み込み:
					{
						string path = ( Global.PlayerMode.bプレイヤーモードではない ) ? Global.Song.r現在演奏中の曲.ScoreFile : Global.PlayerMode.stg演奏ファイル名;

						Global.Song.r現在演奏中の曲のスコア = Global.Song.tスコアを読み込む( path );

						if( Global.Song.r現在演奏中の曲のスコア != null )
						{
							// 読み込み成功
							this.e状態の処理結果 = E進行結果.完了;
						}
						else
						{
							// 読み込み失敗
							//Global.Stage.選曲.Actフリップボード.t表示( "曲の読み込みに失敗しました。" );
							Debug.WriteLine( "曲の読み込みに失敗しました。" );
							this.e状態の処理結果 = E進行結果.キャンセル;
						}
					}
					this.bPresentスキップ = true;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ活性化 ]
				//-----------------
				case E状態.演奏ステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.演奏;
					Global.Stage.演奏.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ進行描画 ]
				//-----------------
				case E状態.演奏ステージ進行描画:
					this.t現在のステージの描画前();
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ非活性化 ]
				//-----------------
				case E状態.演奏ステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 演奏動画だけ停止と解放 ]
				//-----------------
				case E状態.演奏動画の停止と解放:
					{
						if( Global.Song.r現在演奏中のスコアの背景動画 != null )
							Global.Song.r現在演奏中のスコアの背景動画.t停止する();

						Global.tDisposeする( ref Global.Song.r現在演奏中のスコアの背景動画 );
						Global.tDisposeする( ref Global.Song.r現在演奏中の曲のスコア );
					}
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 演奏BGMの停止と解放 ]
				//-----------------
				case E状態.演奏BGMの停止と解放:
					{
						if( Global.Song.r現在演奏中のスコアのBGM != null )
							Global.Song.r現在演奏中のスコアのBGM.t停止する();

						Global.tDisposeする( ref Global.Song.r現在演奏中のスコアのBGM );
					}
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ クリアステージ活性化 ]
				//-----------------
				case E状態.クリアステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.クリア;
					Global.Stage.クリア.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ クリアステージ進行描画 ]
				//-----------------
				case E状態.クリアステージ進行描画:
					this.t現在のステージの描画前();
					break;
				//-----------------
				#endregion
				#region [ クリアステージ非活性化 ]
				//-----------------
				case E状態.クリアステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ活性化 ]
				//-----------------
				case E状態.結果ステージ活性化:
					Global.Stage.m現在のステージ = Global.Stage.結果;
					Global.Stage.結果.On活性化();
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ進行描画 ]
				//-----------------
				case E状態.結果ステージ進行描画:
					this.t現在のステージの描画前();
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ非活性化 ]
				//-----------------
				case E状態.結果ステージ非活性化:
					Global.Stage.m現在のステージ.On非活性化();
					Global.Stage.m現在のステージ = null;
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
				#region [ その他 ]
				//-----------------
				default:
					this.t完了( PART_描画前 );
					break;
				//-----------------
				#endregion
			}
		}
		protected override void On描画( IntPtr hDevice )
		{
			// デバイスのロック後、BeginScene ～ EndScene の間に呼び出される。
			// 終了チェック（「bアプリケーションの終了」のチェック）は、実行頻度の高い On進行() のほうで行うのでここでは行わない。

			switch( this.e現在の状態[ PART_描画 ] )
			{
				#region [ 待機 ]
				//-----------------
				case E状態.待機:
					//this.bPresentスキップ = ....		設定済みの状態で来るので上書きしてはいけない。
					break;
				//-----------------
				#endregion
				#region [ CAUTIONステージ活性化 ]
				//-----------------
				case E状態.CAUTIONステージ活性化:
					Global.Stage.Caution.Onリソースの作成( hDevice );
					this.bPresentスキップ = true;
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ CAUTIONステージ進行描画 ]
				//-----------------
				case E状態.CAUTIONステージ進行描画:
					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ活性化 ]
				//-----------------
				case E状態.オープニングステージ活性化:
					Global.Stage.オープニング.Onリソースの作成( hDevice );
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ オープニングステージ進行描画 ]
				//-----------------
				case E状態.オープニングステージ進行描画:
					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ活性化 ]
				//-----------------
				case E状態.選曲ステージ活性化:
					Global.Stage.選曲.Onリソースの作成( hDevice );
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ 選曲ステージ進行描画 ]
				//-----------------
				case E状態.選曲ステージ進行描画:
					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ活性化 ]
				//-----------------
				case E状態.演奏ステージ活性化:
					Global.Stage.演奏.Onリソースの作成( hDevice );
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ 演奏ステージ進行描画 ]
				//-----------------
				case E状態.演奏ステージ進行描画:

					#region [ プレイヤーモードの場合、コマンドライン配列を定期的にチェックし、必要有ればアクションを実行する。]
					//-----------------
					if( ( Global.PlayerMode.bプレイヤーモードである ) && ( Global.PlayerMode.arrayコマンドライン != null ) )		// 非 null なら実行。
					{
						var e結果 = Global.PlayerMode.tアクション解析・指示( Global.PlayerMode.arrayコマンドライン );

						Global.PlayerMode.arrayコマンドライン = null;		// 解析が終わったら、アクション実行前に null に戻すこと。（でないとまたこのif文にひっかかる）

						if( e結果 != E進行結果.完了 )		// 指示があった → アクションを実行へ移す（遷移する）
						{
							this.e状態の処理結果 = e結果;
							this.t全完了();
							this.bPresentスキップ = true;
							return;
						}
					}
					//-----------------
					#endregion

					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ クリアステージ活性化 ]
				//-----------------
				case E状態.クリアステージ活性化:
					Global.Stage.クリア.Onリソースの作成( hDevice );
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ クリアステージ進行描画 ]
				//-----------------
				case E状態.クリアステージ進行描画:
					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ活性化 ]
				//-----------------
				case E状態.結果ステージ活性化:
					Global.Stage.結果.Onリソースの作成( hDevice );
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
				#region [ 結果ステージ進行描画 ]
				//-----------------
				case E状態.結果ステージ進行描画:
					this.t現在のステージの描画( hDevice );
					break;
				//-----------------
				#endregion
				#region [ その他 ]
				//-----------------
				default:
					this.bPresentスキップ = true;
					this.t完了( PART_描画 );
					break;
				//-----------------
				#endregion
			}
		}
		protected override void Onリソースの作成()
		{
			base.Onリソースの作成();
		}
		protected override void Onリソースの解放()
		{
			base.Onリソースの解放();
		}

		private object objスレッド排他用 = new object();

		private const int PART_進行 = 0;
		private const int PART_描画前 = 1;
		private const int PART_描画 = 2;

		#region [ 各スレッドパートの状態。]
		//-----------------
		private volatile E状態[] e現在の状態 =
			new E状態[ 3 ] {
				E状態.待機,		// PART_進行
				E状態.待機,		// PART_描画前
				E状態.待機 };	// PART_描画
		//-----------------
		#endregion
		#region [ 進行・描画スレッドの現状態におけるタスク完了フラグ（遷移後、フロー制御スレッドが両者の完了を待機する） ]
		//-----------------
		/// <summary>
		/// <para>進行・描画スレッドについて、現状態の処理が完了したらこのイベントを Set() すること。</para>
		/// <para>Reset() は、フロー制御スレッドにて状態遷移後に行う。</para>
		/// </summary>
		private volatile ManualResetEvent[] ev状態タスクの完了 =
			new ManualResetEvent[ 3 ] {
				new ManualResetEvent( false ),		// THREAD_進行
				new ManualResetEvent( false ),		// THREAD_描画前
				new ManualResetEvent( false ) };	// THREAD_描画

		/// <summary>
		/// <para>スレッドのタスク完了フラグをセットし、スレッドの状態を「待機」にする。</para>
		/// </summary>
		private void t完了( int threadID )
		{
			this.e現在の状態[ threadID ] = E状態.待機;
			this.ev状態タスクの完了[ threadID ].Set();
		}
		private void t全完了()
		{
			this.t完了( PART_進行 );
			this.t完了( PART_描画前 );
			this.t完了( PART_描画 );
		}
		//-----------------
		#endregion
		#region [ アプリの状態遷移メソッド。]
		//-----------------
		// 状態遷移を行う。
		// EXアプリ終了例外が出たら、呼び出し元（フロー制御スレッド）はスレッドを終了すること。
		private void t遷移( E状態 e次の状態 )
		{
			lock( this.objスレッド排他用 )
			{
				Trace.TraceInformation( "「" + e次の状態 + "」状態へ遷移します。" );

				// 状態遷移。
				this.e現在の状態[ PART_進行 ] = e次の状態;
				this.e現在の状態[ PART_描画前 ] = e次の状態;
				this.e現在の状態[ PART_描画 ] = e次の状態;

				// 完了フラグをリセット。
				this.ev状態タスクの完了[ PART_進行 ].Reset();
				this.ev状態タスクの完了[ PART_描画前 ].Reset();
				this.ev状態タスクの完了[ PART_描画 ].Reset();
			}

			// 進行・描画スレッドの処理が両方終わるまで待機する。
			// On進行() は「bアプリケーションを終了する」のフラグが立っていれば ev現状態の処理完了[] を２つとも Set() するので、
			// WaitAll() をすぐに抜けることができる。
			ManualResetEvent.WaitAll( this.ev状態タスクの完了 );

			// 終了チェック。

			if( this.bアプリケーションを終了する.Get() )
			{
				Trace.TraceInformation( "遷移: アプリケーションの終了フラグを検出しましたので、EXアプリ終了例外を発出します。" );
				throw new EXアプリ終了例外();	// フロー制御スレッドを終了させる戻り値代わり。戻り値で終了を通知するようにすると、呼び出し元のコードがうざくなる。
			}
		}
		private class EXアプリ終了例外 : Exception { };
		//-----------------
		#endregion
		#region [ 状態の結果。次の状態遷移決定の判断材料。]
		//-----------------
		/// <summary>
		/// <para>状態処理完了時の結果コード。</para>
		/// <para>ev状態処理完了通知イベントを Set() する前に、このプロパティに結果を格納しておくこと。</para>
		/// <para>フロー・進行・描画のどのスレッドがこれを格納するかは、そのときのアプリの状態によって異なる。</para>
		/// </summary>
		private volatile E進行結果 e状態の処理結果;
		//-----------------
		#endregion

		private void t現在のステージの進行()
		{
			lock( this.objスレッド排他用 )
			{
				#region [ 実行条件チェック ]
				//-----------------
				if( Global.Stage.m現在のステージ == null )
					return;
				if( Global.Stage.m現在のステージ.b活性化してない )
					throw new Exception( "活性化されていません。" );

				//-----------------
				#endregion

				// 入力のポーリング

				if( Global.Input != null &&
					Global.Input.Input管理 != null &&
					Global.Input.Input管理.hWnd == this.hWindow )	// 自分が Input管理 のオーナーであるときのみ更新。進行スレッドでは this.Window は参照しないこと。（GUIスレッドではないので）
				{
					Global.Input.tポーリング();
				}

				// 現在のステージの進行

				this.e状態の処理結果 = (E進行結果) Global.Stage.m現在のステージ.On進行();

				// 進行結果の判定

				if( this.e状態の処理結果 != E進行結果.継続 )
					this.t全完了();
			}
		}
		private void t現在のステージの描画前()
		{
			lock( this.objスレッド排他用 )
			{
				#region [ 実行条件チェック ]
				//-----------------
				if( Global.Stage.m現在のステージ == null )
					return;
				if( Global.Stage.m現在のステージ.b活性化してない )
					return;
				//-----------------
				#endregion

				Global.Stage.m現在のステージ.On描画前();
			}
		}
		private void t現在のステージの描画( IntPtr hDevice )
		{
			lock( this.objスレッド排他用 )
			{
				#region [ 実行条件チェック ]
				//-----------------
				if( Global.Stage.m現在のステージ == null )
					return;
				if( Global.Stage.m現在のステージ.b活性化してない )
					return;
				//-----------------
				#endregion

				if( !Global.Stage.m現在のステージ.b初めての進行 )
				{
					this.Direct3D.tデバイスをクリアする( hDevice );
					Global.Stage.m現在のステージ.On描画( hDevice );
					this.bPresentスキップ = false;
				}
				else
				{
					this.Direct3D.tデバイスをクリアする( hDevice );
					this.bPresentスキップ = true;
				}
			}
		}
	}
}
