#pragma once

namespace FDK
{
	class CritSec
	{
	public:
		CritSec()
		{
			::InitializeCriticalSection( &m_criticalSection );
		}
		~CritSec()
		{
			::DeleteCriticalSection( &m_criticalSection );
		}

		void Lock()
		{
			::EnterCriticalSection( &m_criticalSection );
		}
		void Unlock()
		{
			::LeaveCriticalSection( &m_criticalSection );
		}

	private:
		CRITICAL_SECTION m_criticalSection;
	};
}
