#include "stdafx.h"
#include "refCXg[o.h"

namespace FDK
{
// public:
	HRESULT CXg[o::tWAVC[Wo( String^ fileName, [Out] MemoryStream^% msWaveImage )
	{
		HRESULT hr = S_OK;
		IMFSourceReader *pReader = NULL;
		IMFMediaType *pAudioType = NULL;    // PCM I[fBItH[}bg\B
		BinaryWriter^ bwWaveFile = nullptr;

		try
		{
			// ̓t@Cw肵 SourceReader 쐬B
			{
				pin_ptr<const wchar_t> fname = ::PtrToStringChars( fileName );
				tFAILEDȂA( hr = ::MFCreateSourceReaderFromURL( fname, NULL, &pReader ) );
			}


			// oWAVEt@CC[WC^[쐬B
				
			bwWaveFile = gcnew BinaryWriter( msWaveImage );


			// \[Xt@C񈳏k PCM I[fBI擾悤ASourceReader ݒ肷BPCMI[fBI^Cv pAudioType Ɏ󂯎B
				
			pAudioType = NULL;
			tFAILEDȂA( hr = ConfigureAudioStream( pReader, &pAudioType ) );


			// WAVEt@Cwb_oB
				
			DWORD cbHeader = 0;		// WAVE t@Cwb_̃TCYBoCgPʁB
			tFAILEDȂA( hr = WriteWaveHeader( bwWaveFile, pAudioType, &cbHeader ) );
				
				
			// I[fBIf[^t@CɃfR[hB
				
			DWORD cbAudioData = 0;	// t@Cɏo͂鑍 PCM I[fBIf[^TCYBoCgPʁB
			tFAILEDȂA( hr = WriteWaveData( bwWaveFile, pReader, &cbAudioData ) );
				
				
			// TCY RIFF wb_tB
				
			tFAILEDȂA( hr = FixUpChunkSizes( bwWaveFile, cbHeader, cbAudioData ) );

			#if _DEBUG
			// t@CɏóifobOpj
			//msWaveImage->WriteTo( gcnew FileStream( gcnew String( L"C:\\ProgramData\\StrokeStyleT\\test.wav" ), FileMode::Create ) );
			#endif
		}
		finally
		{
			// ܂ُ͈IB

			if( bwWaveFile != nullptr )
			{
				bwWaveFile->Close();
				delete bwWaveFile;
			}
			COM_SAFE_RELEASE( pAudioType );
			COM_SAFE_RELEASE( pReader );
		}
		return S_OK;
	}

// private;
	HRESULT CXg[o::ConfigureAudioStream( IMFSourceReader *pReader, [Out] IMFMediaType** ppAudioType )
	{
		HRESULT hr = S_OK;
        IMFMediaType *pUncompressedAudioType = NULL;
        IMFMediaType *pPartialType = NULL;

		try
		{
			// ŏ̃I[fBIXg[IȂׂ̂ẴXg[IɂB

			tFAILEDȂA( hr = pReader->SetStreamSelection( MF_SOURCE_READER_ALL_STREAMS, FALSE ) );
			tFAILEDȂA( hr = pReader->SetStreamSelection( MF_SOURCE_READER_FIRST_AUDIO_STREAM, TRUE ) );


	        // 񈳏k PCM I[fB\sSfBA^Cv쐬B
				
			tFAILEDȂA( hr = ::MFCreateMediaType( &pPartialType ) );
			tFAILEDȂA( hr = pPartialType->SetGUID( MF_MT_MAJOR_TYPE, MFMediaType_Audio ) );	// W[^Cv
			tFAILEDȂA( hr = pPartialType->SetGUID( MF_MT_SUBTYPE, MFAudioFormat_PCM ) );		// Tu^Cv

				
			// ̃fBA^Cv SourceReader ɃZbgBSourceReader ͕KvȃfR[_IɃ[hB

			tFAILEDȂA( hr = pReader->SetCurrentMediaType( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, NULL, pPartialType ) );
				
				
			// SȔ񈳏ktH[}bg擾B
				
			tFAILEDȂA( hr = pReader->GetCurrentMediaType( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, &pUncompressedAudioType ) );
				
				
			// Xg[IĂ邱Ƃۏ؂B
				
			tFAILEDȂA( hr = pReader->SetStreamSelection( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, TRUE ) );
				
				
			// PCM tH[}bgĂяoɕԂB
			*ppAudioType = pUncompressedAudioType;
			(*ppAudioType)->AddRef();
		}
		finally
		{
			// ܂ُ͈IB

			COM_SAFE_RELEASE( pUncompressedAudioType );
			COM_SAFE_RELEASE( pPartialType );
		}
		return S_OK;
	}
	HRESULT CXg[o::WriteWaveHeader( BinaryWriter^ bwFile, IMFMediaType *pAudioType, [Out] DWORD *pcbWritten )
	{
		HRESULT hr = S_OK;
		UINT32 cbFormat = 0;
		WAVEFORMATEX *pWav = NULL;
		*pcbWritten = 0;
			
		try
		{
			// PCM I[fBItH[}bg WAVEFORMATEX \̂ɕϊB
			
			tFAILEDȂA( hr = ::MFCreateWaveFormatExFromMFMediaType( pAudioType, &pWav, &cbFormat ) );
				
				
			// 'RIFF' wb_ƍŏ 'fmt ' `NoB
				
			bwFile->Write( (UInt32) 0x46464952 );    // 'RIFF'
			bwFile->Write( (UInt32) 0 );             // t@CTCY - 8ij
			bwFile->Write( (UInt32) 0x45564157 );    // 'WAVE'
			bwFile->Write( (UInt32) 0x20746d66 );    // 'fmt '
			bwFile->Write( (UInt32) cbFormat );      // fmt`NTCY
				
				
			// WAVEFORMATEX \̂oB

			for( UINT32 i = 0; i < cbFormat; i++ )
				bwFile->Write( (UCHAR) ((UCHAR*)pWav)[i] );

				
			// 'data' `N̊JnoB
				
			bwFile->Write( (UInt32) 0x61746164 );    // 'data'
			bwFile->Write( (UInt32) 0 );             // data `NTCYij
				
				
			// ŏIIȏݗʂvZB

			*pcbWritten = sizeof(UInt32) * 5 + cbFormat + sizeof(UInt32) * 2;
		}
		finally
		{
			// ܂ُ͈IB

			if( pWav )
				CoTaskMemFree( pWav );
		}
		return S_OK;
	}
	HRESULT CXg[o::WriteWaveData( BinaryWriter^ bwFile, IMFSourceReader *pReader, [Out] DWORD *pcbDataWritten )
	{
		HRESULT hr = S_OK;
		DWORD cbAudioData = 0;
		DWORD cbBuffer = 0;
		BYTE *pAudioData = NULL;
        IMFSample *pSample = NULL;
        IMFMediaBuffer *pBuffer = NULL;

		*pcbDataWritten = 0;

		try
		{
			// SourceReader I[fBITv擾B

			while( true )
			{
				DWORD dwFlags = 0;
					
				// ̃TvǂݍށB
					
				tFAILEDȂA( hr = pReader->ReadSample( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, 0, NULL, &dwFlags, NULL, &pSample ) );

				if( dwFlags & MF_SOURCE_READERF_CURRENTMEDIATYPECHANGED )		// fBA^Cvς炱ŔB
					break;

				if( dwFlags & MF_SOURCE_READERF_ENDOFSTREAM )					// Ō܂œǂݍ񂾂甲B
					break;
					
				if( pSample == NULL )		// TvȂxB
					continue;

					
				// TvI[fBIf[^bNẴ|C^擾B
					
				tFAILEDȂA( hr = pSample->ConvertToContiguousBuffer( &pBuffer ) );
				tFAILEDȂA( hr = pBuffer->Lock( &pAudioData, NULL, &cbBuffer ) );


				// ̃f[^o̓t@CɏށB

				for( DWORD i = 0; i < cbBuffer; i++ )
					bwFile->Write( (UCHAR) pAudioData[i] );


				// obt@̃bNB

				tFAILEDȂA( hr = pBuffer->Unlock() );
				pAudioData = NULL;
					
					
				// I[fBIf[^̏ݑʂZB

				cbAudioData += cbBuffer;


				// Tvƃobt@ÃTvցB

				COM_SAFE_RELEASE( pSample );
				COM_SAFE_RELEASE( pBuffer );
			}


			// 񂾑f[^ʂԂB

			*pcbDataWritten = cbAudioData;
		}
		finally
		{
			// ܂ُ͈IB

			if( pAudioData )
				pBuffer->Unlock();

			COM_SAFE_RELEASE( pSample );
			COM_SAFE_RELEASE( pBuffer );
		}
		return S_OK;
	}
	HRESULT CXg[o::FixUpChunkSizes( BinaryWriter^ bwFile, UInt32 cbHeader, DWORD cbAudioData )
	{
		// f[^TCYށB

		bwFile->Seek( cbHeader - sizeof(UInt32), System::IO::SeekOrigin::Begin );
		bwFile->Write( (UInt32) cbAudioData );


		// t@CTCYށB

		bwFile->Seek( sizeof(UInt32), System::IO::SeekOrigin::Begin );
		bwFile->Write( (UInt32)( cbHeader + cbAudioData - 8 ) );
			
		return S_OK;
	}
}