#include "stdafx.h"
#include "PresenterEngine.h"
#include "MediaTypeBuilders.h"
#include "CustomGUID.h"
#include "CMediaSessionNative.h"
#include "Direct3D9\CDirect3DNative.h"
#include "Direct3D9\DrawTexture.h"

namespace FDK
{
// public:
	PresenterEngine::PresenterEngine( HRESULT& hr )
	{
		this->m_hwnd = NULL;
		this->m_szVideo.cx = 0;
		this->m_szVideo.cy = 0;
		this->pTexture = NULL;
		this->b\v = true;
	}
	PresenterEngine::~PresenterEngine()
	{
		COM_SAFE_RELEASE( this->pTexture );
	}

	HRESULT PresenterEngine::GetService( REFGUID guidService, REFIID riid, void** ppv )
	{
		HRESULT hr = S_OK;

		if( riid == __uuidof(IDirect3DDeviceManager9) )	// { guidService = MR_VIDEO_ACCELERATION_SERVICE łȂ΂ȂȂcc
		{
			#pragma region [ *** ]
			//-----------------
			IDirect3DDeviceManager9 *pd3dm = CDirect3DNative::GetDirect3DDeviceManager();
			if( pd3dm == NULL )
			{
				hr = MF_E_UNSUPPORTED_SERVICE;
			}
			else
			{
				*ppv = pd3dm;
				pd3dm->AddRef();
			}
			//-----------------
			#pragma endregion
		}
		else
		{
			hr = MF_E_UNSUPPORTED_SERVICE;
		}

		return hr;
	}
	HRESULT PresenterEngine::tw肳ꂽtH[}bgp\ׂ( D3DFORMAT format )
	{
		HRESULT hr = S_OK;

		IDirect3D9Ex *pd3d9 = CDirect3DNative::GetDirect3DEx();
		if( pd3d9 == NULL )
			return D3DERR_INVALIDCALL;		// Direct3D9 ȂG[B

		UINT uAdapter;				// A_v^
		D3DDEVTYPE type;			// foCX^Cv
		D3DDISPLAYMODE mode;		// [h
		D3DDEVICE_CREATION_PARAMETERS params;

		// foCXr擾B
		HANDLE hDevice;
		IDirect3DDevice9 *pDev = NULL;
		hr = CDirect3DNative::tfoCXbN( true, &hDevice, &pDev );

		try
		{
			#pragma region [ foCXA_v^AfoCX^Cv擾B]
			//-----------------
			if( pDev )
			{
				// (A) D3DfoCXς݁B

				hr = pDev->GetCreationParameters( &params );
				if( FAILED( hr ) )
					return hr;

				uAdapter = params.AdapterOrdinal;
				type = params.DeviceType;
			}
			else
			{
				// (B) D3DfoCXB

				uAdapter = D3DADAPTER_DEFAULT;
				type = D3DDEVTYPE_HAL;
			}
			//-----------------
			#pragma endregion
			#pragma region [ foCX[h擾B]
			//-----------------
			hr = CDirect3DNative::GetDirect3DEx()->GetAdapterDisplayMode( uAdapter, &mode );
			if( FAILED( hr ) )
				return hr;
			//-----------------
			#pragma endregion
		}
		finally
		{
			CDirect3DNative::tfoCX̃bN( hDevice );
		}

		// w肳ꂽtH[}bgÃ݂foCXA_v^AfoCX^CvAfoCX[hŗp\H

		hr = pd3d9->CheckDeviceType( uAdapter, type, mode.Format, format, TRUE );

		return hr;
	}
	
	HRESULT PresenterEngine::SetVideoWindow( HWND hwnd )
	{
		m_hwnd = hwnd;
		return S_OK;
	}
	HWND    PresenterEngine::GetVideoWindow()
	{
		return m_hwnd;
	}
	void	PresenterEngine::SetVideoSize( LONG width, LONG height )
	{
		AutoLock lock( this->csTexture );	// eNX``撆ɕύXȂ悤bN

		this->m_szVideo.cx = width;
		this->m_szVideo.cy = height;
	}
	SIZE	PresenterEngine::GetVideoSize()
	{
		return this->m_szVideo;
	}

	HRESULT PresenterEngine::CreateVideoSamples( IMFMediaType *pMediaType, CVideoSampleList& videoSampleQueue )
	{
		#pragma region [ `FbN ]
		//-----------------
		if( this->m_hwnd == NULL || this->m_szVideo.cx == 0 || this->m_szVideo.cy == 0 )
			return MF_E_INVALIDREQUEST;

		if( pMediaType == NULL )
			return E_INVALIDARG;
		//-----------------
		#pragma endregion

		HRESULT hr = S_OK;
		IMFSample *pVideoSample = NULL;
		VideoTypeBuilder *pVideoType = NULL;
		UINT32 width = 0, height = 0;
		DWORD d3dFormat = 0;
		IDirect3DTexture9 *pTexture = NULL;
		IDirect3DSurface9 *pSurface = NULL;
		D3DCOLOR clrBlack = D3DCOLOR_ARGB( 0xFF, 0x00, 0x00, 0x00 );

		AutoLock( this->csTexture );		// eNX`bN

		this->ReleaseResources();
		COM_SAFE_RELEASE( this->pTexture );

		// fBA^CvtH[}bg擾B

		tFAILEDȂO( L"VideoTypeBuilder ̍쐬",
			hr = VideoTypeBuilder::Create( pMediaType, &pVideoType ) );
				
		tFAILEDȂO( L"fBA^CṽtH[}bg̎擾",
			hr = pVideoType->GetFourCC( &d3dFormat ) );


		// eNX`TCY擾B

		width = this->m_szVideo.cx;
		height = this->m_szVideo.cy;


		// D3DfoCXr擾B

		HANDLE hDevice;
		IDirect3DDevice9 *pdev = NULL;
		hr = CDirect3DNative::tfoCXbN( true, &hDevice, &pdev );

		if( SUCCEEDED( hr ) ) 
		{
			// rfITv쐬B

			for (int i = 0; i < PRESENTER_BUFFER_COUNT; i++)
			{
				// 쐬AݒB

				tFAILEDȂO( L"v[^peNX`̍쐬",
										hr = pdev->CreateTexture( width, height, 1, D3DUSAGE_RENDERTARGET, (D3DFORMAT)d3dFormat, D3DPOOL_DEFAULT, &pTexture, NULL ) );
					
				tFAILEDȂO( L"v[^peNX`̃T[tFCX̎擾",
										hr = pTexture->GetSurfaceLevel( 0, &pSurface ) );

				tFAILEDȂO( L"v[^pT[tFCX̓hԂ",
										hr = pdev->ColorFill( pSurface, NULL, clrBlack ) );

				tFAILEDȂO( L"v[^pT[tFCX̃rfITv̍쐬",
										hr = ::MFCreateVideoSampleFromSurface( pSurface, &pVideoSample ) );
					
				tFAILEDȂO( L"rfITvL[ւ̃rfITv̒ǉ",
										hr = videoSampleQueue.InsertBack( pVideoSample ) );

				tFAILEDȂO( L"rfITv̑ւ̃v[^peNX`̊蓖",
										hr = pVideoSample->SetUnknown( MFSamplePresenter_Texture, pTexture ) );

				// AցB
					
				COM_SAFE_RELEASE( pVideoSample );
				COM_SAFE_RELEASE( pSurface );
				COM_SAFE_RELEASE( pTexture );
			}

			// D3DfoCXB

			CDirect3DNative::tfoCX̃bN( hDevice );
		}

		// B
		COM_SAFE_RELEASE( pVideoType );
		return hr;
	}
	HRESULT PresenterEngine::tTv󂯎( IMFSample* pSample, LONGLONG llTarget )
	{
		#pragma region [ \vȂiÕeNX`܂`悳ĂȂjȂ牽ȂŋAB]
		//-----------------
		bool b\v;
		this->cs\v.Lock();
		b\v = this->b\v;
		this->cs\v.Unlock();

		if( ! b\v )
			return S_OK;
		//-----------------
		#pragma endregion

		HRESULT hr = S_OK;

		HANDLE hDevice = 0;
		IDirect3DDevice9 *pDevice = NULL;
		IDirect3DTexture9* pTexture = NULL;
		IUnknown* pUnknown = NULL;

		if( pSample )
		{
			tFAILEDȂO( L"rfITṽv[^peNX`̎擾",
				hr = pSample->GetUnknown( MFSamplePresenter_Texture, IID_IUnknown, (void**)&pUnknown ) );

			if( pUnknown )
			{
				tFAILEDȂO( L"rfITv IUnknown  IDirect3DTexture9 ̎擾",
					hr = pUnknown->QueryInterface( __uuidof(IDirect3DTexture9), (void**) &pTexture ) );

				{
					AutoLock lock( this->csTexture );		// eNX``悳Ȃ悤bN

					COM_SAFE_RELEASE( this->pTexture );		// ȑÔ͉̂

					this->pTexture = pTexture;	// ۊǁiQƃJE^j
					this->pTexture->AddRef();
				}

				AutoLock lock( this->cs\v );
				this->b\v = false;
			}
		}
		else
		{
			// TvȂƂ͉ȂB
		}

		COM_SAFE_RELEASE( pTexture );
		COM_SAFE_RELEASE( pUnknown );

		if( FAILED( hr ) )
		{
			if( hr == D3DERR_DEVICELOST || hr == D3DERR_DEVICENOTRESET || hr == D3DERR_DEVICEHUNG )
			{
				// We failed because the device was lost. Fill the destination rectangle.
				this->PaintFrameWithGDI();

				// Ignore. We need to reset or re-create the device, but this method
				// is probably being called from the scheduler thread, which is not the
				// same thread that created the device. The Reset(Ex) method must be
				// called from the thread that created the device.

				// The presenter will detect the state when it calls CheckDeviceState() 
				// on the next sample.
				hr = S_OK;
			}
		}
		return S_OK;
	}
	void PresenterEngine::t̃Tvv()
	{
		AutoLock lock( this->cs\v );
		this->b\v = true;
	}
	void PresenterEngine::tTv`悷( LPRECT prcSrc, LPRECT prcDest, UINT32 ux, UINT32 uZ )
	{
		if( this->pTexture == NULL )
			return;

		AutoLock lock( this->csTexture );		// eNX`ȂтɃTCYύXȂ悤bN

		RECT rcSrc;
		#pragma region [ ]` rcSrc ̌ ]
		//-----------------
		if( prcSrc )
		{
			rcSrc = *prcSrc;
		}
		else
		{
			rcSrc.left = 0;
			rcSrc.top = 0;
			rcSrc.right = this->m_szVideo.cx;
			rcSrc.bottom = this->m_szVideo.cy;
		}
		//-----------------
		#pragma endregion

		RECT rcDest;
		#pragma region [ ]` rcDest ̌ ]
		//-----------------
		if( prcDest && !::IsRectEmpty( prcDest ) )
			rcDest = *prcDest;
		else
			rcDest = rcSrc;
		//-----------------
		#pragma endregion

		float fg嗦X = (float)(rcDest.right - rcDest.left) / (float)(rcSrc.right - rcSrc.left);
		float fg嗦Y = (float)(rcDest.bottom - rcDest.top) / (float)(rcSrc.bottom - rcSrc.top);

		IDirect3DDevice9Ex *pDevice = CDirect3DNative::GetDirect3DDeviceEx();		// foCX MF ɂăbNĂƂOB
		DrawTexture::t2D`( pDevice, this->pTexture, (int) ux, ((uZ!=0) ? true : false), fg嗦X, fg嗦Y, rcDest.left, rcDest.top );
		return;
	}

	UINT PresenterEngine::RefreshRate()
	{
		return CDirect3DNative::GetDirect3DDisplayMode()->RefreshRate;
	}
	void PresenterEngine::ReleaseResources()
	{
	}

// protected:

	void PresenterEngine::PaintFrameWithGDI()
	{
		HDC hdc = ::GetDC( m_hwnd );

		if( hdc )
		{
			HBRUSH hBrush = ::CreateSolidBrush( RGB( 0, 0, 0 ) );

			if( hBrush )
			{
				RECT rc;
				::GetClientRect( m_hwnd, &rc );
				::FillRect( hdc, &rc, hBrush );
				::DeleteObject( hBrush );
			}

			::ReleaseDC( m_hwnd, hdc );
		}
	}
}
