#include "Stdafx.h"
#include "CustomEVRPresenter.h"
#include "\AutoLock.h"
#include "MediaTypeBuilders.h"
#include "CustomGUID.h"
#include "Direct3D9\CDirect3DNative.h"

namespace FDK
{
// public:

	HRESULT CustomEVRPresenter::CreateInstance( IUnknown *pUnkOuter, REFIID iid, void **ppv )
	{
		if( ppv == NULL )
			return E_POINTER;

		if( pUnkOuter != NULL )
			return CLASS_E_NOAGGREGATION;

		HRESULT hr = S_OK;
		CustomEVRPresenter *pObject = NULL;
			
		try
		{
			// JX^v[^̃CX^X𐶐B

			pObject = new CustomEVRPresenter( hr );
			if( pObject == NULL )
				return E_OUTOFMEMORY;
			tFAILEDȂO( L"JX^EVRv[^CX^X̐", hr );

			tFAILEDȂO( L"JX^EVRv[^ɑ΂ QueryInterface() ",
									hr = pObject->QueryInterface( iid, ppv ) );
		}
		finally
		{
			COM_SAFE_RELEASE( pObject );
		}

		return hr;
	}

	// IUnknown
	STDMETHODIMP CustomEVRPresenter::QueryInterface( REFIID riid, void **ppv )
	{
		if( ppv == NULL )
			return E_POINTER;

		if( riid == __uuidof(IUnknown) )
			*ppv = static_cast<IUnknown*>( static_cast<IMFVideoPresenter*>(this) );

		else if( riid == __uuidof(IMFVideoDeviceID) )
			*ppv = static_cast<IMFVideoDeviceID*>(this);

		else if( riid == __uuidof(IMFVideoPresenter) )
			*ppv = static_cast<IMFVideoPresenter*>(this);

		else if( riid == __uuidof(IMFClockStateSink) )
			*ppv = static_cast<IMFClockStateSink*>(this);

		else if( riid == __uuidof(IMFRateSupport) )
			*ppv = static_cast<IMFRateSupport*>(this);

		else if( riid == __uuidof(IMFGetService) )
			*ppv = static_cast<IMFGetService*>(this);

		else if( riid == __uuidof(IMFTopologyServiceLookupClient) )
			*ppv = static_cast<IMFTopologyServiceLookupClient*>(this);

		else if( riid == __uuidof(IMFVideoDisplayControl) )
			*ppv = static_cast<IMFVideoDisplayControl*>(this);

		else if( riid == __uuidof(IMFActivate) )
			*ppv = static_cast<IMFActivate*>(this);

		else if( riid == __uuidof(IMFAttributes) )
			*ppv = static_cast<IMFAttributes*>(this);

		#pragma region [ ̑̓G[ ]
		//-----------------
		else
		{
			*ppv = NULL;
			return E_NOINTERFACE;
		}
		//-----------------
		#pragma endregion

		this->AddRef();
		return S_OK;
	}
	STDMETHODIMP_( ULONG ) CustomEVRPresenter::AddRef()
	{
		return ::InterlockedIncrement( &this->nQƃJE^ );
	}
	STDMETHODIMP_( ULONG ) CustomEVRPresenter::Release()
	{
		ULONG uCount = ::InterlockedDecrement( &this->nQƃJE^ );

		if( uCount == 0 )
			delete this;
        
		return uCount;
	}

	// IMFGetService
	STDMETHODIMP CustomEVRPresenter::GetService( REFGUID guidService, REFIID riid, LPVOID *ppvObject )
	{
		if( ppvObject == NULL )
			return E_POINTER;

		if( guidService != MR_VIDEO_RENDER_SERVICE )	// MR_VIDEO_RENDER_SERVICE ȊÕT[rXID̓T|[gȂB
			return MF_E_UNSUPPORTED_SERVICE;

		HRESULT hr = S_OK;

		// ŏɃv[^GW GetService() B
		hr = m_pPresenterEngine->GetService( guidService, riid, ppvObject );

		// s QueryInterface() ֊ۓB
		if( FAILED( hr ) )
			hr = this->QueryInterface( riid, ppvObject );

		return hr;
	}
		
	// IMFTopologyServiceLookupClient 
	STDMETHODIMP CustomEVRPresenter::InitServicePointers( IMFTopologyServiceLookup *pLookup )
	{
		// from MSDN:
		//
		// EVR v[^ƂAv[^ IMFTopologyServiceLookupClient::InitServicePointers ĂяoB
		// ɂ́AEVR  IMFTopologyServiceLookup ւ̃|C^i[ĂB
		//
		// v[^́AIMFTopologyServiceLookup::LookupService ĂяoāAEVR ~LT[C^[tF[X|C^擾B
		//
		// ET[rX GUID  MR_VIDEO_RENDER_SERVICE ȂAEVR ֖₢킹B
		// ET[rX GUID  MR_VIDEO_MIXER_SERVICE ȂA~LT[֖₢킹B
		// 
		// v[^́AInitServicePointers ̎̒ŁAEVR ȉ̃C^[tF[X擾邱ƁB
		//
		//	IMediaEventSink			v[^ EVR ɃbZ[W𑗂@񋟂B̃C^[tF[X DirectShow SDK 
		//							`Ă邽߁AbZ[W Media Foundation Cxgł͂Ȃ DirectShow Cxgp^[ɏ]B
		//
		//	IMFClock				EVR ̃NbN\Bv[^͂̃C^[tFXgāAv[e[ṼTvXPW[B
		//							EVR ̓NbNłs邱Ƃł邽߁ÃC^[tF[X͗p\ł͂ȂȂB
		//							ȂALookupService ̃G[R[h𖳎邱ƁB
		//							܂ANbN IMFTimer BMedia Foundation pCvCł́ANbN IMFPresentationClock B
		//
		// ~LT[͈ȉ̃C^[tF[X擾邱ƁB
		//
		//	IMFTransform			v[^~LT[ƂƂł悤ɂB
		//
		//	IMFVideoDeviceID		v[^[~LT[̃foCX GUID ؂邱ƂłB

		if( pLookup == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		DWORD dwObjectCount = 0;

		AutoLock lock( m_ObjectLock );

		// Đ܂͒~ɏ邱Ƃ͋ȂB
		if( this->bĐ܂͈ꎞ~ł() )
			return MF_E_INVALIDREQUEST;

		// COM ̉
		COM_SAFE_RELEASE( m_pClock );
		COM_SAFE_RELEASE( m_pMixer );
		COM_SAFE_RELEASE( m_pMediaEventSink );

		#pragma region [ EVR  IMFClock 擾(m_pClock)B]
		//-----------------
		dwObjectCount = 1;

		hr = pLookup->LookupService(      
			MF_SERVICE_LOOKUP_GLOBAL,   // gpB
			0,                          // \B
			MR_VIDEO_RENDER_SERVICE,    // Ώۂ̃T[rXB
			__uuidof(IMFClock),         // Ώۂ̃C^[tF[XB
			(void**)&m_pClock,			// C^[tF[X̊i[ꏊizjB
			&dwObjectCount              // i[ꏊ̔z̗vfB
			);

		// EVR̓NbNĂȂmȂ̂ŁAhr ̐Es͖ȂB
			
		//-----------------
		#pragma endregion

		#pragma region [ Mixer(IMFTransform)擾(m_pMixer)B]
		//-----------------
		dwObjectCount = 1; 

		hr = pLookup->LookupService(
			MF_SERVICE_LOOKUP_GLOBAL, 
			0, 
			MR_VIDEO_MIXER_SERVICE,
			__uuidof(IMFTransform), 
			(void**)&m_pMixer, 
			&dwObjectCount
			);

		if( FAILED( hr ) )
			return hr;
		//-----------------
		#pragma endregion

		#pragma region [ Mixer  IMFVideoDeviceID 擾A`FbNB]
		//-----------------
		hr = this->t~LTDeviceIDmF]`ݒ肷( m_pMixer );	// mF邾ŕێ͂ȂB
		if( FAILED( hr ) )
			return hr;
		//-----------------
		#pragma endregion

		#pragma region [ EVR  IMediaEventSink 擾(m_pMediaEventSink)B]
		//-----------------
		dwObjectCount = 1;

		hr = pLookup->LookupService(
			MF_SERVICE_LOOKUP_GLOBAL,
			0,                                  
			MR_VIDEO_RENDER_SERVICE,            
			__uuidof(IMediaEventSink),                
			(void**)&m_pMediaEventSink,          
			&dwObjectCount                      
			);

		if( FAILED( hr ) )
			return hr;
		//-----------------
		#pragma endregion

		// ɐ̂ŃXe[^X stopped ɂB
		this->m_RenderState = RENDER_STATE_~;

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::ReleaseServicePointers()
	{
		// from MSDN:
		//
		// LoopupService œꂽC^[tF[X|C^ɂȂ鎞AEVR  IMFTopologyServiceLookupClient::ReleaseServicePointers ĂяoB
		// ̃\bh̓ł́AׂẴ|C^Av[^̏Ԃ shutdown ɃZbgB

		HRESULT hr = S_OK;

		// Xe[^XuVbg_Eς݁vɕςB
		{
			AutoLock lock( m_ObjectLock );
			this->m_RenderState = RENDER_STATE_Vbg_Eς;
		}

		// XPW[Ă邷ׂẴTvB
		this->Flush();

		// fBA^CvNAA֘A郊\[XiT[tFCXȂǁjB
		this->SetMediaType( NULL );

		// InitServicePointers() Ŏ擾eC^[tF[XB
		COM_SAFE_RELEASE( this->m_pClock );
		COM_SAFE_RELEASE( this->m_pMixer );
		COM_SAFE_RELEASE( this->m_pMediaEventSink );

		return S_OK;
	}

	// IMFVideoPresenter
	STDMETHODIMP CustomEVRPresenter::ProcessMessage( MFVP_MESSAGE_TYPE eMessage, ULONG_PTR ulParam )
	{
		// from MSDN:
		//
		// ProcessMessage \bh́AEVR ɂƂăv[^ƒʐMDIJjYłB
		// ȉ̃bZ[W`ĂBebZ[W̎̏ڍׂɂĂ͌qB


		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );
			
		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		switch( eMessage )
		{

		case MFVP_MESSAGE_FLUSH:

		// EVR _OpCvCɂf[^tbVB
		// v[^̓XPW[OĂ邷ׂẴrfIt[jׂłB

			return this->Flush();
				

		case MFVP_MESSAGE_INVALIDATEMEDIATYPE:

		// ~LT[̏o̓fBA^CvłB
		// v[^̓~LT[ƐVfBA^CvlSVG[VׂłB
		// v[^́AK؂ȃ^Cv܂ł́A MFVP_MESSAGE_INVALIDATEMEDIATYPE bZ[W󂯎ꍇB

			return this->RenegotiateMediaType();


		case MFVP_MESSAGE_PROCESSINPUTNOTIFY:

		// ~LT[V̓Tv󂯎邽тɁAEVR  MFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[Wv[^ɑMB   
		// ̃bZ[ẂA~LT[񋟉\ȃrfIt[Ă邾낤ƂĂB
		// ƂāAv[^̓~LT[ IMFTransform::ProcessOutput ĂяoB
		// \bhꍇ́Av[^̓Tvv[e[VpɃXPW[B

			return this->ProcessInputNotify();


		case MFVP_MESSAGE_BEGINSTREAMING:

		// Xg[~OJnꂽB
		// ̃bZ[Wɑ΂ēʂȃANVNKv͂ȂA\[X蓖ĂꍇɎgp邱ƂłB
	
			return this->BeginStreaming();


		case MFVP_MESSAGE_ENDSTREAMING:

		// Xg[~OIB
		// MFVP_MESSAGE_BEGINSTREAMING bZ[W󂯎Ɋ蓖ĂׂẴ\[X邱ƁB
    
			return this->EndStreaming();


		case MFVP_MESSAGE_ENDOFSTREAM:

		// v[e[VIB

			this->m_bEndStreaming = TRUE; 
        	return this->CheckEndOfStream();	// IĂ EC_COMPLETE Cxg EVR ɑB


		case MFVP_MESSAGE_STEP:

		// v[^ɁAN t[OփXebv邱ƂvĂB
		// v[^͎ N-1 ̃t[jAN Ԗڂ̃t[\ׂłB

			return this->PrepareFrameStep( ((DWORD)(ulParam)) );


		case MFVP_MESSAGE_CANCELSTEP:

		// t[̃XebsOLZꂽB

			return this->CancelFrameStep();
		}

		return E_INVALIDARG;
	}
	STDMETHODIMP CustomEVRPresenter::GetCurrentMediaType( IMFVideoMediaType **ppMediaType )
	{
		// from MSDN:
		//
		// GetCurrentMediaType \bh́Av[^̃fBA^CvԂB
		// fBA^Cv IMFVideoMediaType |C^ƂĕԂB
		// IMFMediaType  IMFVideoMediaType 擾ɂ́AQueryInterface gB

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		if( ppMediaType == NULL )
			return E_POINTER;

		if( this->m_pMediaType == NULL )
			return MF_E_NOT_INITIALIZED;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		// IMFMediaType  IMFVideoMediaType oĕԂB
		hr = this->m_pMediaType->QueryInterface( __uuidof(IMFVideoMediaType), (void**)&ppMediaType );
		return hr;
	}

	// IMFClockStateSink
	STDMETHODIMP CustomEVRPresenter::OnClockStart( MFTIME hnsSystemTime, LONGLONG llClockStartOffset )
	{
		// from MSDN:
		//
		// 1. v[^̃Xe[^X started ɃZbgB
		//
		// 2. llClockStartOffset  PRESENTATION_CURRENT_POSITION ł͂ȂȂAv[^̃TvL[tbVB
		//    i MFVP_MESSAGE_FLUSH bZ[W̎MƓBj
		//
		// 3. Õt[Xebv̗v܂ۗłꍇ́AvBȊȌꍇ́A~LT[̏o݂͂̏B
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;


		// (A) ~܂ĂȂԂJnꂽ

		if( this->bĐ܂͈ꎞ~ł() )
		{
			this->m_RenderState = RENDER_STATE_Đ;
    
			// If the clock position changes while the clock is active, it 
			// is a seek request. We need to flush all pending samples.
			if( llClockStartOffset != PRESENTATION_CURRENT_POSITION )
				this->Flush();
		}

		// (B) ~ԂJnꂽ
		else
		{
			this->m_RenderState = RENDER_STATE_Đ;

			// Possibly we are in the middle of frame-stepping OR have samples waiting 
			// in the frame-step queue. Deal with these two cases first:
			hr = this->StartFrameStep();
			if( FAILED( hr ) )
				return hr;
		}

		// ~LT[Vo̓Tv̎擾݂B
		this->ProcessOutputLoop();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockStop( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// 1. v[^̃Xe[^X stopped ɃZbgB
		// 2. v[^[̃TvL[tbVB
		// 3. ۗĂ邷ׂẴt[XebvLZB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		if( this->m_RenderState == RENDER_STATE_~ )
			return S_OK;	// łɒ~ԂȂX[B

		this->m_RenderState = RENDER_STATE_~;
		this->Flush();

		// If we are in the middle of frame-stepping, cancel it now.
		if( this->m_FrameStep.state != FRAMESTEP_ĂȂ )
			this->CancelFrameStep();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockPause( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// v[^̃Xe[^X paused ɃZbgB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) ) 
			return hr;

		this->m_RenderState = RENDER_STATE_ꎞ~;
		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockRestart( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// ̃\bh́Apaused Ԃ̂ƂɂĂ΂Ă͂ȂB
		// OnClockStart() ƓɈATvL[̃tbV͂ȂB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		if( this->m_RenderState != RENDER_STATE_ꎞ~ )
			return E_FAIL;	// ꎞ~ȂĂł̓_B

		this->m_RenderState = RENDER_STATE_Đ;

		// Possibly we are in the middle of frame-stepping OR we have samples waiting 
		// in the frame-step queue. Deal with these two cases first:
		hr = this->StartFrameStep();
		if( FAILED( hr ) )
			return hr;

		// Now resume the presentation loop.
		this->ProcessOutputLoop();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockSetRate( MFTIME hnsSystemTime, float fRate )
	{
		// from MSDN:
		//
		// 1. [[ɕύXꂽꍇ́At[XebsOLZB
		// 2. VNbN[gi[BNbN[ǵATv\^C~Oɉe^B
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		// Note: 
		// The presenter reports its maximum rate through the IMFRateSupport interface.
		// Here, we assume that the EVR honors the maximum rate.

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		if( ( this->m_fRate == 0.0f ) && ( fRate != 0.0f ) )
		{
			this->CancelFrameStep();
			this->m_FrameStep.samples.Clear();
		}

		this->m_fRate = fRate;

		// Tell the scheduler about the new rate.
		this->m_scheduler.tNbN[gݒ肷( fRate );

		return hr;
	}

	// IMFRateSupport
	STDMETHODIMP CustomEVRPresenter::GetSlowestRate( MFRATE_DIRECTION eDirection, BOOL bThin, float *pfRate )
	{
		// from MSDN:
		//
		// ŒᑬxȂꍇ 0 ԂB
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		if( pfRate == NULL )
			return E_POINTER;

		// There is no minimum playback rate, so the minimum is zero.
		*pfRate = 0; 

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::GetFastestRate( MFRATE_DIRECTION eDirection, BOOL bThin, float *pfRate )
	{
		// from MSDN:
		//
		// Đx́Aj^̃tbV[g𒴂Ă͂ȂȂB
		// Ȃ킿Aő呬xtbV[g[Hz]rfĨt[[g[fps] łB
		// rfĨt[[ǵAv[^̃fBA^CvɎw肳ĂB
		//
		// ԔĐȂAĐx͖łB̏ꍇ FLT_MAX lԂB
		// ۂɂ́A\[XƃfR[_͊ԔĐԂ̗vf̐󂯂邾낤B
		//
		// tĐꍇ́Aő呬x̕ԂB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		if( pfRate == NULL )
			return E_POINTER;

		// Get the maximum *forward* rate.
		float fMaxRate = this->GetMaxRate( bThin );

		if( eDirection == MFRATE_REVERSE )
			fMaxRate = -fMaxRate;

		*pfRate = fMaxRate;

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::IsRateSupported( BOOL bThin, float fRate, float *pfNearestSupportedRate )
	{
		// from MSDN:
		//
		// fRate ̐Βlv[^̍őĐx𒴂ꍇAMF_E_UNSUPPORTED_RATE ԂB
		// ő呬xɂẮAGetFastestRate ŏqׂ@ŌvZB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;
		float   fMaxRate = 0.0f;
		float   fNearestRate = fRate;   // If we support fRate, then fRate *is* the nearest.

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		// Find the maximum forward rate.
		// Note: We have no minimum rate (ie, we support anything down to 0).
		fMaxRate = this->GetMaxRate( bThin );

		if( fabsf( fRate ) > fMaxRate )
		{
			// The (absolute) requested rate exceeds the maximum rate.
			hr = MF_E_UNSUPPORTED_RATE;

			// The nearest supported rate is fMaxRate.
			fNearestRate = fMaxRate;
			if( fRate < 0 )
			{
				// Negative for reverse playback.
				fNearestRate = - fNearestRate;
			}
		}

		// Return the nearest supported rate.
		if( pfNearestSupportedRate != NULL )
			*pfNearestSupportedRate = fNearestRate;

		return hr;
	}

	// IMFVideoDeviceID
	STDMETHODIMP CustomEVRPresenter::GetDeviceID( IID* pDeviceID )
	{
		// from MSDN:
		//
		// WIȃ~LT[v[^́Aǂ Direct3D9 gp邽߁AfoCXGUID IID_IDirect3DDevice9 łB
		// WIȃ~LT[ƃJX^v[^Agꍇ́Av[^̃foCX GUID  IID_IDirect3DDevice9 łȂ΂ȂȂB
		// ̃R|[lguȂAVfoCXGUID`łB
		// ̃\bh́Av[^Vbg_EĂ鎞łKvB

		if( pDeviceID == NULL )
			return E_POINTER;

		*pDeviceID = __uuidof(IDirect3DDevice9);
		return S_OK;
	}

	// IMFVideoDisplayControl
	STDMETHODIMP CustomEVRPresenter::SetVideoPosition( const MFVideoNormalizedRect *pnrcSource, const LPRECT prcDest )
	{
		HRESULT hr = S_OK;

//		AutoLock lock( m_ObjectLock );

		#pragma region [ `FbN ]
		//-----------------
		if( pnrcSource == NULL && prcDest == NULL )
			return E_POINTER;

		if( pnrcSource )
		{
			if( ( pnrcSource->left > pnrcSource->right ) || ( pnrcSource->top > pnrcSource->bottom ) )
				return E_INVALIDARG;

			if( ( pnrcSource->left < 0 ) || ( pnrcSource->right > 1 ) || ( pnrcSource->top < 0 ) || ( pnrcSource->bottom > 1 ) )
				return E_INVALIDARG;
		}

		if( prcDest )
		{
			if( ( prcDest->left > prcDest->right ) || ( prcDest->top > prcDest->bottom ) )
				return E_INVALIDARG;
		}
		//-----------------
		#pragma endregion

		#pragma region [ ]`̎w肪ꍇ́A~LT[ɓo^B]
		//-----------------
		if( pnrcSource )
		{
			this->m_nrcSource = *pnrcSource;

			if( this->m_pMixer )
			{
				hr = this->SetMixerSourceRect( this->m_pMixer, this->m_nrcSource );

				if( FAILED( hr  ) )
					return hr;
			}
		}
		//-----------------
		#pragma endregion

		#pragma region [ ]`̎w肪ꍇ́AXVB]
		//-----------------
		if( prcDest )
		{
			RECT rcOldDest = this->m_rcDest;

			if( !::EqualRect( &rcOldDest, prcDest ) )		// `ύXꂽꍇB
			{
				this->m_rcDest = *prcDest;

				//// VfBA^Cv~LT[ƃlSVG[VB

				//if( this->m_pMixer )
				//{
				//	hr = this->RenegotiateMediaType();
				//	
				//	if( hr == MF_E_TRANSFORM_TYPE_NOT_SET )
				//	{
				//		// This error means that the mixer is not ready for the media type.
				//		// Not a failure case -- the EVR will notify us when we need to set
				//		// the type on the mixer.
				//		hr = S_OK;
				//	}
				//	else
				//	{
				//		if( FAILED( hr ) )
				//			return hr;

				//		// The media type changed. Request a repaint of the current frame.
				//		this->m_bRepaint = TRUE;
				//		this->ProcessOutput(); // Ignore errors, the mixer might not have a video frame.
				//	}
				//}
			}
		}
		//-----------------
		#pragma endregion

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::GetVideoPosition( MFVideoNormalizedRect* pnrcSource, LPRECT prcDest )
	{
		AutoLock lock( m_ObjectLock );

		if( pnrcSource == NULL || prcDest == NULL )
			return E_POINTER;

		*pnrcSource = this->m_nrcSource;
		*prcDest = this->m_rcDest;

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::SetVideoWindow( HWND hwndVideo )
	{
		AutoLock lock( m_ObjectLock );

		if( !::IsWindow( hwndVideo ) )
			return E_INVALIDARG;

		if( this->m_pPresenterEngine )
			this->m_pPresenterEngine->SetVideoWindow( hwndVideo );

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::GetVideoWindow( HWND* phwndVideo )
	{
		AutoLock lock( m_ObjectLock );

		if( phwndVideo == NULL )
			return E_POINTER;

		if( this->m_pPresenterEngine )
			*phwndVideo = this->m_pPresenterEngine->GetVideoWindow();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::RepaintVideo()
	{
		AutoLock lock( m_ObjectLock );

		HRESULT hr = S_OK;

		hr = this->tVbg_EԂȂG[Ԃ();
		if( FAILED( hr ) )
			return hr;

		// Ignore the request if we have not presented any samples yet.
		if( this->m_bPrerolled )
		{
			this->m_bRepaint = TRUE;
			this->ProcessOutput();
		}

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::SetRenderingPrefs( DWORD dwRenderFlags )
	{
		HRESULT hr = E_INVALIDARG;

		switch( dwRenderFlags )
		{

		case MFVideoRenderPrefs_DisplayChange:
			// EVR ɑ΂āAD3DfoCXύXꂽƂ EC_DISPLAY_CHANGED ʒmB
			if( this->m_pMediaEventSink )
				this->m_pMediaEventSink->Notify( EC_DISPLAY_CHANGED, 0, 0 );
			hr = S_OK;
			break;

		case MFVideoRenderPrefs_DisplaySample:
			// ŐṼTv`悷B
			if( this->m_pPresenterEngine )
				this->m_pPresenterEngine->tTv`悷( NULL, &this->m_rcDest, this->ueNX`̓x, this->ueNX`̉Z );
			hr = S_OK;
			break;

		case MFVideoRenderPrefs_RequestNextSample:
			if( this->m_pPresenterEngine )
				this->m_pPresenterEngine->t̃Tvv();
			hr = S_OK;
			break;
		}

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::GetNativeVideoSize( SIZE* pszVideo, SIZE* pszARVideo )
	{
		if( pszVideo )
			*pszVideo = this->m_pPresenterEngine->GetVideoSize();

		return S_OK;
	}

	// IMFActivate
	STDMETHODIMP CustomEVRPresenter::ActivateObject( REFIID riid, void **ppv )
	{
		HRESULT hr = CustomEVRPresenter::CreateInstance( NULL, riid, ppv );
		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::ShutdownObject()
	{
		return S_OK;
	}

	// IMFAttributes
	STDMETHODIMP CustomEVRPresenter::GetUINT32( REFGUID guidKey, UINT32 *punValue )
	{
		if( IsEqualGUID( guidKey, GUIDofeNX`̓x ) )
		{
			*punValue = this->ueNX`̓x;
		}
		else if( IsEqualGUID( guidKey, GUIDofeNX`̉Z ) )
		{
			*punValue = this->ueNX`̉Z;
		}
		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::SetUINT32( REFGUID guidKey, UINT32 unValue )
	{
		if( IsEqualGUID( guidKey, GUIDofeNX`̓x ) )
		{
			this->ueNX`̓x = unValue;

			if( this->ueNX`̓x > 255 )
				this->ueNX`̓x = 255;
		}
		else if( IsEqualGUID( guidKey, GUIDofeNX`̉Z ) )
		{
			this->ueNX`̉Z = unValue;
		}
		return S_OK;
	}

// protected:

	CustomEVRPresenter::CustomEVRPresenter( HRESULT &hr ) :
		m_RenderState( RENDER_STATE_Vbg_Eς ),
		m_pPresenterEngine( NULL ),
		m_pClock( NULL ),
		m_pMixer( NULL ),
		m_pMediaEventSink( NULL ),
		m_pMediaType( NULL ),
		m_bSampleNotify( FALSE ),
		m_bRepaint( FALSE ),
		m_bEndStreaming( FALSE ),
		m_bPrerolled( FALSE ),
		m_fRate( 1.0f ),
		m_TokenCounter( 0 ),
		m_SampleFreeCB( this, &CustomEVRPresenter::OnSampleFree )
	{
		hr = S_OK;
		this->nQƃJE^ = 1;
		this->g_DefaultFrameRate.Numerator  = 30;
		this->g_DefaultFrameRate.Denominator = 1;
		::SetRectEmpty( &this->m_rcDest );
		this->ueNX`̓x = 255;
		this->ueNX`̉Z = 0;

		// Initial source rectangle = (0,0,1,1)
		m_nrcSource.top = 0;
		m_nrcSource.left = 0;
		m_nrcSource.bottom = 1;
		m_nrcSource.right = 1;

		this->m_pPresenterEngine = new PresenterEngine( hr );
		if( this->m_pPresenterEngine == NULL)
			hr = E_OUTOFMEMORY;
			
		if( FAILED( hr ) )
		{
			SAFE_DELETE( this->m_pPresenterEngine );
			return;
		}

		this->m_scheduler.tR[obNݒ肷( this->m_pPresenterEngine );
	}
	CustomEVRPresenter::~CustomEVRPresenter()
	{
		// COM C^[tF[XB
		COM_SAFE_RELEASE( this->m_pClock );
		COM_SAFE_RELEASE( this->m_pMixer );
		COM_SAFE_RELEASE( this->m_pMediaEventSink );
		COM_SAFE_RELEASE( this->m_pMediaType );

		// ̑̃IuWFNgB
		SAFE_DELETE( this->m_pPresenterEngine );
	}

	HRESULT CustomEVRPresenter::tVbg_EԂȂG[Ԃ() const
	{
		if( this->m_RenderState == RENDER_STATE_Vbg_Eς )
			return MF_E_SHUTDOWN;

		return S_OK;
	}
	BOOL	CustomEVRPresenter::bĐ܂͈ꎞ~ł() const
	{
		return ( ( this->m_RenderState == RENDER_STATE_Đ ) || ( this->m_RenderState == RENDER_STATE_ꎞ~ ) );
	}
	BOOL	CustomEVRPresenter::IsScrubbing() const
	{
		return m_fRate == 0.0f;
	}
	void	CustomEVRPresenter::tEVRɃCxgʒm( long EventCode, LONG_PTR Param1, LONG_PTR Param2 )
	{
		// from MSDN:
		//
		// v[^́AEVR ɗlXȃCxgʒmȂ΂ȂȂB
		// sɂ́AEVR  IMediaEventSink gpB
		// ̃C^[tF[X EVR v[^ IMFTopologyServiceLookupClient::InitServicePointers() ĂяoɎ擾łB
		// iIMediaEventSink C^[tF[X͂Ƃ DirectShow ̃C^[tF[Xł邪AMedia Foundation łgpĂBj
		//

		if( this->m_pMediaEventSink )
			this->m_pMediaEventSink->Notify( EventCode, Param1, Param2 );
	}
	float	CustomEVRPresenter::GetMaxRate( BOOL bThin )
	{
		// Non-thinned:
		// If we have a valid frame rate and a monitor refresh rate, the maximum 
		// playback rate is equal to the refresh rate. Otherwise, the maximum rate 
		// is unbounded (FLT_MAX).

		// Thinned: The maximum rate is unbounded.

		float   fMaxRate = FLT_MAX;
		MFRatio fps = { 0, 0 };
		UINT    MonitorRateHz = 0; 

		if( !bThin && ( this->m_pMediaType != NULL ) )
		{
			GetFrameRate( this->m_pMediaType, &fps );
			MonitorRateHz = this->m_pPresenterEngine->RefreshRate();

			if( fps.Denominator && fps.Numerator && MonitorRateHz )
			{
				// Max Rate = Refresh Rate / Frame Rate
				fMaxRate = (float) ::MulDiv( MonitorRateHz, fps.Denominator, fps.Numerator );
			}
		}

		return fMaxRate;
	}
	float	CustomEVRPresenter::MFOffsetToFloat( const MFOffset& offset )
	{
		return (float)offset.value + (float)offset.value / 65536.0f;
	}

	// ~LT[
	HRESULT	CustomEVRPresenter::t~LTDeviceIDmF]`ݒ肷( IMFTransform *pMixer )
	{
		HRESULT hr = S_OK;
		IID deviceID = GUID_NULL;
		IMFVideoDeviceID *pDeviceID = NULL;

		try
		{
			// ~LT[foCXIDĂ邱ƂmFB
				
			tFAILEDȂO( L"~LT[ IMFVideoDeviceID ̎擾",
									hr = pMixer->QueryInterface( __uuidof(IMFVideoDeviceID), (void**)&pDeviceID ) );
				
			tFAILEDȂO( L"~LT[̃foCXID̎擾",
									hr = pDeviceID->GetDeviceID( &deviceID ) );

			if( !::IsEqualGUID( deviceID, __uuidof(IDirect3DDevice9) ) )
				tHRESULTtO( MF_E_INVALIDREQUEST, L"~LT[ DeviceID  IDirect3DDevice9 ł͂܂B" );

			// Set the zoom rectangle (ie, the source clipping rectangle).
			this->SetMixerSourceRect( pMixer, this->m_nrcSource );
		}
		finally
		{
			COM_SAFE_RELEASE( pDeviceID );
		}

		return hr;
	}

	// tH[}bg
	HRESULT	CustomEVRPresenter::CreateOptimalVideoType( IMFMediaType *pProposedType, IMFMediaType **ppOptimalType )
	{
		HRESULT hr = S_OK;
		RECT rcOutput;
		::ZeroMemory( &rcOutput, sizeof(rcOutput) );
		MFVideoArea displayArea;
		::ZeroMemory( &displayArea, sizeof(displayArea) );
		VideoTypeBuilder *pmtOptimal = NULL;

		try
		{
			tFAILEDȂO( L"fBA^Cvp VideoTypeBuilder ̍쐬",
									hr = VideoTypeBuilder::Create( &pmtOptimal ) );

			tFAILEDȂO( L"w肳ꂽfBA^Cv̕(CopyFrom)",
									hr = pmtOptimal->CopyFrom( pProposedType ) );


			// ȉAfBA^Cv̑CB

			tFAILEDȂO( L"MF_MT_PIXEL_ASPECT_RATIO ւ̃fBXvCPAR (1:1) ̐ݒ",
									hr = pmtOptimal->SetPixelAspectRatio( 1, 1 ) );

			#pragma region [ gFݒ肷Bł BT.709 gpB]
			//-----------------
			tFAILEDȂO( L"SetYUVMatrix( BT709 ) ",				hr = pmtOptimal->SetYUVMatrix( MFVideoTransferMatrix_BT709 ) );
			tFAILEDȂO( L"SetTransferFunction( 709 ) ",		hr = pmtOptimal->SetTransferFunction( MFVideoTransFunc_709 ) );
			tFAILEDȂO( L"SetVideoPrimaries( BT709 ) ",		hr = pmtOptimal->SetVideoPrimaries( MFVideoPrimaries_BT709 ) );
			tFAILEDȂO( L"SetVideoNominalRange( 16_235 ) ",	hr = pmtOptimal->SetVideoNominalRange( MFNominalRange_16_235 ) );
			tFAILEDȂO( L"SetVideoLighting( dim ) ",			hr = pmtOptimal->SetVideoLighting( MFVideoLighting_dim ) );
			//-----------------
			#pragma endregion

				
			#pragma region [ \[X̃IWiTCYGWɓo^B]
			//-----------------
			UINT32 w, h;
			tFAILEDȂO( L"\[X̃IWiTCY̎擾",
									hr = pmtOptimal->GetFrameDimensions( &w, &h ) );

			this->m_pPresenterEngine->SetVideoSize( w, h );	// o^
			//-----------------
			#pragma endregion

			#pragma region [ o͋` rcOutput \[X̃IWiTCYɐݒB]
			//-----------------
			rcOutput.right = w;
			rcOutput.bottom = h;
			//-----------------
			#pragma endregion
				
			tFAILEDȂO( L"MF_MT_FRAME_SIZE ւ Direct3D T[tFCXɊ]镝ƍ̎w", 
									hr = pmtOptimal->SetFrameDimensions( rcOutput.right, rcOutput.bottom ) );

			tFAILEDȂO( L"MF_MT_PAN_SCAN_ENABLED ւ FALSE l̐ݒ",
									hr = pmtOptimal->SetPanScanEnabled( FALSE ) );

			// MF_MT_GEOMETRIC_APERTURE ɂ́ADirect3D T[tFCX̋`ZbgB
			// ~LT[o̓t[𐶐ƁA\[X摜̋`ɕ`悳B
			// ̋`́AT[tFCX傫AT[tFCX̃Tu`ɂ邱ƂłB

			displayArea = MakeArea( 0, 0, rcOutput.right, rcOutput.bottom );

			tFAILEDȂO( L"SetGeometricAperture() ",	hr = pmtOptimal->SetGeometricAperture( displayArea ) );
			tFAILEDȂO( L"SetPanScanAperture() ",		hr = pmtOptimal->SetPanScanAperture( displayArea ) );
			tFAILEDȂO( L"SetMinDisplayAperture() ",	hr = pmtOptimal->SetMinDisplayAperture( displayArea ) );


			tFAILEDȂO( L"fBA^Cv ppOptimalType ւ̏o",
									hr = pmtOptimal->GetMediaType( ppOptimalType ) );
		}
		finally
		{
			COM_SAFE_RELEASE( pmtOptimal );
		}

		return hr;
	}
	HRESULT	CustomEVRPresenter::SetMediaType( IMFMediaType *pMediaType )
	{
		// Note: pMediaType can be NULL (to clear the type)

		// Clearing the media type is allowed in any state (including shutdown).
		if( pMediaType == NULL )
		{
			COM_SAFE_RELEASE( m_pMediaType );
			this->ReleaseResources();
			return S_OK;
		}

		HRESULT hr = S_OK;
		MFRatio fps = { 0, 0 };
		CVideoSampleList sampleQueue;


		IMFSample *pSample = NULL;

		// Cannot set the media type after shutdown.
		CHECK_HR(hr = tVbg_EԂȂG[Ԃ());

		// Check if the new type is actually different.
		// Note: This function safely handles NULL input parameters.
		if( this->AreMediaTypesEqual( m_pMediaType, pMediaType ) )  
			return S_OK; // Nothing more to do.

		// We're really changing the type. First get rid of the old type.
		COM_SAFE_RELEASE( m_pMediaType );
		this->ReleaseResources();

		// Initialize the presenter engine with the new media type.
		// The presenter engine allocates the samples. 

		CHECK_HR( hr = m_pPresenterEngine->CreateVideoSamples( pMediaType, sampleQueue ) );

		// Mark each sample with our token counter. If this batch of samples becomes
		// invalid, we increment the counter, so that we know they should be discarded. 
		for( CVideoSampleList::POSITION pos = sampleQueue.FrontPosition();
				pos != sampleQueue.EndPosition();
				pos = sampleQueue.Next(pos))
		{
			CHECK_HR(hr = sampleQueue.GetItemPos(pos, &pSample));
			CHECK_HR(hr = pSample->SetUINT32(MFSamplePresenter_SampleCounter, m_TokenCounter));

			COM_SAFE_RELEASE( pSample );
		}


		// Add the samples to the sample pool.
		CHECK_HR(hr = m_SamplePool.t( sampleQueue ) );

		// Set the frame rate on the scheduler. 
		if (SUCCEEDED(GetFrameRate(pMediaType, &fps)) && (fps.Numerator != 0) && (fps.Denominator != 0))
		{
			this->m_scheduler.tt[[gݒ肷(fps);
		}
		else
		{
			// NOTE: The mixer's proposed type might not have a frame rate, in which case 
			// we'll use an arbitary default. (Although it's unlikely the video source
			// does not have a frame rate.)
			this->m_scheduler.tt[[gݒ肷( g_DefaultFrameRate);
		}

		// Store the media type.
		m_pMediaType = pMediaType;
		m_pMediaType->AddRef();

	done:
		if (FAILED(hr))
		{
			ReleaseResources();
		}
		return hr;
	}
	HRESULT	CustomEVRPresenter::IsMediaTypeSupported( IMFMediaType *pMediaType )
	{
		HRESULT                 hr = S_OK;
		D3DFORMAT               d3dFormat = D3DFMT_UNKNOWN;
		BOOL                    bCompressed = FALSE;
		MFVideoInterlaceMode    InterlaceMode = MFVideoInterlace_Unknown;
		MFVideoArea             VideoCropArea;
		UINT32                  width = 0, height = 0;

		// fBA^Cṽbp[IuWFNg쐬B
		VideoTypeBuilder *pmtProposed = NULL;
		CHECK_HR( hr = VideoTypeBuilder::Create( pMediaType, &pmtProposed ));

		// ktH[}bg͋ۂB
		CHECK_HR(hr = pmtProposed->IsCompressedFormat(&bCompressed));
		if( bCompressed )
			CHECK_HR(hr = MF_E_INVALIDMEDIATYPE);

		// tH[}bg`FbNB
		CHECK_HR( hr = pmtProposed->GetFourCC( (DWORD*) &d3dFormat ) );
		CHECK_HR( hr = m_pPresenterEngine->tw肳ꂽtH[}bgp\ׂ( d3dFormat ) );

		// C^[X[h́AvObVû݋BC^[X͕sB
		CHECK_HR( hr = pmtProposed->GetInterlaceMode( &InterlaceMode ) );
		if( InterlaceMode != MFVideoInterlace_Progressive )
			CHECK_HR( hr = MF_E_INVALIDMEDIATYPE );

		// Validate the various apertures (cropping regions) against the frame size.
		// Any of these apertures may be unspecified in the media type, in which case 
		// we ignore it. We just want to reject invalid apertures.
		CHECK_HR( hr = pmtProposed->GetFrameDimensions( &width, &height ) );

		if (SUCCEEDED(pmtProposed->GetPanScanAperture(&VideoCropArea)))
			ValidateVideoArea(VideoCropArea, width, height);

		if (SUCCEEDED(pmtProposed->GetGeometricAperture(&VideoCropArea)))
			ValidateVideoArea(VideoCropArea, width, height);

		if (SUCCEEDED(pmtProposed->GetMinDisplayAperture(&VideoCropArea)))
			ValidateVideoArea(VideoCropArea, width, height);

	done:
		COM_SAFE_RELEASE( pmtProposed );
		return hr;
	}

	// bZ[WnhO
	HRESULT	CustomEVRPresenter::Flush()
	{
		m_bPrerolled = FALSE;

		// XPW[ɃtbVwB
		// XPW[͕\҂ĂTvĂ邩mȂB
		// ̌ĂяóAXPW[XbhׂẴTvj܂ŃubNB
		m_scheduler.tTvL[tbV();

		// t[XebvL[tbVB
		m_FrameStep.samples.Clear();

		if (m_RenderState == RENDER_STATE_~)
		{
			// ōĕ`悷B
			m_pPresenterEngine->tTv󂯎( NULL, 0 );
		}

		return S_OK; 
	}
	HRESULT	CustomEVRPresenter::RenegotiateMediaType()
	{
		// v[^́AEVR  MFVP_MESSAGE_INVALIDATEMEDIATYPE bZ[W󂯎͂łA
		// ~LT[̏o̓tH[}bgȉ̂悤ɐݒ肵Ȃ΂ȂȂB

		HRESULT hr = S_OK;
		BOOL bFoundMediaType = FALSE;
		IMFMediaType *pMixerType = NULL;
		IMFMediaType *pOptimalType = NULL;
		IMFVideoMediaType *pVideoType = NULL;

		if (!m_pMixer)
			return MF_E_INVALIDREQUEST;	// ~LT[Ȃ

		// Loop through all of the mixer's proposed output types.
		DWORD iTypeIndex = 0;
		while( !bFoundMediaType && ( hr != MF_E_NO_MORE_TYPES ) )
		{
			COM_SAFE_RELEASE( pMixerType );
			COM_SAFE_RELEASE( pOptimalType );


			// 1. ~LT[ IMFTransform::GetOutputAvailableType ĂяoA\ȏo̓^Cv擾B
			//    ̃^Cv́A~LT[̓Xg[琶邱ƂłtH[}bgƁAOtBbNfoCX̃rfIvZbVO\͂LqB

			hr = m_pMixer->GetOutputAvailableType( 0, iTypeIndex++, &pMixerType );
				
			if( FAILED( hr ) )	// ^CvsꍇA~LT[ GetOutputAvailableType \bh̖߂l MF_E_NO_MORE_TYPES ԂB
				break;

			// 2. v[^̃fBA^Cv_OtH[}bgƂĎgpł邩ۂmFB
			//    ^CvełȂꍇ́AXebv1 ɖ߂A~LT[̎̐^Cv擾B

			if (SUCCEEDED(hr))
			{
				hr = this->IsMediaTypeSupported( pMixerType );
			}

			// 3. IWi^CṽN[ƂĐVfBA^Cv쐬B

			if (SUCCEEDED(hr))
			{
				hr = this->CreateOptimalVideoType( pMixerType, &pOptimalType );
			}

			// 4. ~LT[Cꂽo̓^Cv󂯓邩ǂeXg邽߂ɁAMFT_SET_TYPE_TEST_ONLY tOw肵
			//    IMFTransform::SetOutputType ĂяoB
			//    ~LT[^Cv₵AXebv1ɖ߂Ď̃^Cv擾B

			if (SUCCEEDED(hr))
			{
				hr = m_pMixer->SetOutputType( 0, pOptimalType, MFT_SET_TYPE_TEST_ONLY );
			}

			// 5. Direct3D T[tFCX̃v[蓖ĂB
			//    ~LT[͂̃T[tFCXgčς݃rfIt[`悷B

			if (SUCCEEDED(hr))
			{
				hr = this->SetMediaType( pOptimalType );
			}

			// 6. tOȂ SetOutputType ĂяoA~LT[ɏo̓^CvZbgB
			//    Xebv4 ł̍ŏ SetOutputType ĂяoĂꍇǍĂяo邾낤B

			if (SUCCEEDED(hr))
			{
				hr = m_pMixer->SetOutputType(0, pOptimalType, 0);

				// If something went wrong, clear the media type.
				if (FAILED(hr))
					this->SetMediaType(NULL);
			}

			if (SUCCEEDED(hr))
			{
				bFoundMediaType = TRUE;		// 
			}
		}

		COM_SAFE_RELEASE(pMixerType);
		COM_SAFE_RELEASE(pOptimalType);
		COM_SAFE_RELEASE(pVideoType);

		return hr;
	}
	HRESULT	CustomEVRPresenter::ProcessInputNotify()
	{
		HRESULT hr = S_OK;

		// Set the flag that says the mixer has a new sample.
		m_bSampleNotify = TRUE;

		if (m_pMediaType == NULL)
		{
			// We don't have a valid media type yet.
			hr = MF_E_TRANSFORM_TYPE_NOT_SET;
		}
		else
		{
			// Try to process an output sample.
			ProcessOutputLoop();
		}
		return hr;
	}
	HRESULT	CustomEVRPresenter::BeginStreaming()
	{
		return m_scheduler.tXPW[[JXbhŊJn( m_pClock );
	}
	HRESULT	CustomEVRPresenter::EndStreaming()
	{
		return m_scheduler.tXPW[~[JXbhI();
	}
	HRESULT	CustomEVRPresenter::CheckEndOfStream()
	{
		if (!m_bEndStreaming)
		{
			// The EVR did not send the MFVP_MESSAGE_ENDOFSTREAM message.
			return S_OK; 
		}

		if (m_bSampleNotify)
		{
			// The mixer still has input. 
			return S_OK;
		}

		if( m_SamplePool.bTv݂Ă() )
		{
			// Samples are still scheduled for rendering.
			return S_OK;
		}

		// Everything is complete. Now we can tell the EVR that we are done.
		tEVRɃCxgʒm(EC_COMPLETE, (LONG_PTR)S_OK, 0);
		m_bEndStreaming = FALSE;
		return S_OK;
	}

	// TvǗ
	void	CustomEVRPresenter::ProcessOutputLoop()
	{
		HRESULT hr = S_OK;

		// Process as many samples as possible.
		while (hr == S_OK)
		{
			// If the mixer doesn't have a new input sample, break from the loop.
			if (!m_bSampleNotify)
			{
				hr = MF_E_TRANSFORM_NEED_MORE_INPUT;
				break;
			}

			// Try to process a sample.
			hr = ProcessOutput();

			// NOTE: ProcessOutput can return S_FALSE to indicate it did not process a sample.
			// If so, we break out of the loop.
		}

		if (hr == MF_E_TRANSFORM_NEED_MORE_INPUT)
		{
			// The mixer has run out of input data. Check if we're at the end of the stream.
			CheckEndOfStream();
		}
	}
	HRESULT	CustomEVRPresenter::ProcessOutput()
	{
		HRESULT     hr = S_OK;
		DWORD       dwStatus = 0;
		LONGLONG    mixerStartTime = 0, mixerEndTime = 0;
		MFTIME      systemTime = 0;
		BOOL        bRepaint = m_bRepaint; // Temporarily store this state flag.  

		MFT_OUTPUT_DATA_BUFFER dataBuffer;
		ZeroMemory(&dataBuffer, sizeof(dataBuffer));

		IMFSample *pSample = NULL;

		// 	1. NbNXe[^XmFB
		//     NbN paused ̏ꍇAMFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[ẂAꂪŏ̃rfIt[łȂ薳邱ƁB
		//     NbN running łA܂͂ꂪŏ̃rfIt[łꍇ́AB

		if ((m_RenderState != RENDER_STATE_Đ) &&  // ĐJnĂȂB
				!m_bRepaint &&                             // ĕ`vȂB
				m_bPrerolled                               // ߂Ă̕`悶ȂB
				)
		{
			return S_FALSE;
		}

		if (m_pMixer == NULL)
			return MF_E_INVALIDREQUEST;	// `𖞂Ă̂Ƀ~LT[Ȃ̂͂


		// 2. p\ȃTṽL[Tv𓾂B
		//    L[̏ꍇAׂ͂Ă̊蓖čς݃Tv\XPW[Ă邱ƂӖB
		//    ̏ꍇAMFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[W͂̎_ŖB
		//    ̃Tvp\ɂȂƂAɋLڂĂ菇JԂB

		hr = m_SamplePool.tv[Tvo( &pSample );
		if (hr == MF_E_SAMPLEALLOCATOR_EMPTY)
			return S_FALSE;
		CHECK_HR(hr);
    
		// ĕ`v̏ꍇ

		if (m_bRepaint)
		{
			SetDesiredSampleTime( pSample, m_scheduler.llŌ̃Tv(), m_scheduler.llt[Ԋu() );
			m_bRepaint = FALSE; // OK to clear this flag now.
		}

		// 	3.iIvVjNbNp\łꍇÃ݂NbN^CiT1jIMFClock::GetCorrelatedTimeŎ擾B
		else
		{

			// Not a repaint request. Clear the desired sample time; the mixer will
			// give us the next frame in the stream.
			ClearDesiredSampleTime(pSample);

			if (m_pClock)
			{
				// Latency: Record the starting time for the ProcessOutput operation. 
				(void)m_pClock->GetCorrelatedTime(0, &mixerStartTime, &systemTime);
			}
		}


		// 4. ~LT[ IMFTransform::ProcessOutput ĂяoB
		//    ꍇATv̓rfIt[܂łB
		//    sꍇAԂꂽR[h`FbN邱ƁB

		dataBuffer.dwStreamID = 0;
		dataBuffer.pSample = pSample;
		dataBuffer.dwStatus = 0;

		hr = m_pMixer->ProcessOutput(0, 1, &dataBuffer, &dwStatus);

		if (FAILED(hr))
		{
			HRESULT hr2 = m_SamplePool.tTvv[ɖ߂( pSample );

			if (FAILED(hr2))
				CHECK_HR(hr = hr2);

			// ProcessOutput 瓾ȉ̃G[R[h͒vIȎsł͂ȂB

			if (hr == MF_E_TRANSFORM_TYPE_NOT_SET)
			{
				// ~LT[͐VfBA^CvvĂB
				// ̃G[R[h擾ꍇA~LT[̏o̓^CvlSVG[V邱ƁB

				hr = RenegotiateMediaType();
			}
			else if (hr == MF_E_TRANSFORM_STREAM_CHANGE)
			{
				// ~LT[̏o̓^CvłB炭㗬̃tH[}bgύXłB
				// ̃G[R[h擾ꍇAv[^̃fBA^Cv NULL ɐݒ肷邱ƁB
				// EVR ͐VtH[}bgv邾낤B

				SetMediaType(NULL);
			}
			else if (hr == MF_E_TRANSFORM_NEED_MORE_INPUT)
			{
				// ~LT[́AVt[𐶐邽߂ɂȂ͂KvƂĂB
				// ̃G[R[h擾ꍇAEVR Xg[̏I[ɓBǂmFAB
				// ȊȌꍇ́ÃbZ[W𖳎邱ƁB

				// ~LT[ ProcessOutput() \bh MF_E_TRANSFORM_NEED_MORE_INPUT ԂꍇA
				// ́A~LT[o͂𐶐łȂƂӖ邽߁Av[^ m_fSampleNotify tONAB
				m_bSampleNotify = FALSE; 
			}
		}
		else	// ProcessOutput ꍇ
		{

			// 5.iIvVjNbNp\ȏꍇ́Ã݂NbN^C擾iT2jB
			//   ~LT[ɂēxʂ (T2 - T1) łB
			//   ̒lāAEVR  EC_PROCESSING_LATENCY Cxg𑗂邱ƁBEVR ͂̒liɗpB
			//   NbN͎gȂꍇ́AEC_PROCESSING_LATENCY 𑗐M闝R͂ȂB

			if (m_pClock && !bRepaint)
			{
				(void)m_pClock->GetCorrelatedTime(0, &mixerEndTime, &systemTime);

				LONGLONG latencyTime = mixerEndTime - mixerStartTime;
				tEVRɃCxgʒm(EC_PROCESSING_LATENCY, (LONG_PTR)&latencyTime, 0);
			}

			// 6.iIvVjTv IMFTrackedSample ₢킹AIMFTrackedSample::SetAllocator ĂяoB

			CHECK_HR(hr = TrackSample(pSample));

			// 7. Tvv[e[VpɃXPW[OB

			if ((m_FrameStep.state == FRAMESTEP_ĂȂ) || bRepaint)
			{
				CHECK_HR(hr = DeliverSample(pSample, bRepaint));
			}
			else
			{
				// We are frame-stepping (and this is not a repaint request).
				CHECK_HR(hr = DeliverFrameStepSample(pSample));
			}
			m_bPrerolled = TRUE; // We have presented at least one sample now.
		}

	done:
		// Release any events that were returned from the ProcessOutput method. 
		// (We don't expect any events from the mixer, but this is a good practice.)
		COM_SAFE_RELEASE(dataBuffer.pEvents);
		COM_SAFE_RELEASE(pSample);
		return hr;
	}
	HRESULT	CustomEVRPresenter::DeliverSample( IMFSample *pSample, BOOL bRepaint )
	{
		HRESULT hr = S_OK;
		PresenterEngine::D3DDEVICE_STATE state = PresenterEngine::D3DDEVICE_STATE_OK;

		// If we are not actively playing, OR we are scrubbing (rate = 0) OR this is a 
		// repaint request, then we need to present the sample immediately. Otherwise, 
		// schedule it normally.

		BOOL bPresentNow = ((m_RenderState != RENDER_STATE_Đ) ||  IsScrubbing() || bRepaint);

		if( SUCCEEDED( hr ) )
			hr = CDirect3DNative::tfoCX̏Ԃ擾();

		if( SUCCEEDED( hr ) )
			hr = m_scheduler.tVTv\邩XPW[L[ɓ( pSample, bPresentNow );

		if( hr == D3DERR_DEVICEREMOVED || hr == D3DERR_OUTOFVIDEOMEMORY )
			tEVRɃCxgʒm(EC_ERRORABORT, hr, 0);

		return hr;
	}
	HRESULT	CustomEVRPresenter::TrackSample( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		IMFTrackedSample *pTracked = NULL;

		CHECK_HR(hr = pSample->QueryInterface(__uuidof(IMFTrackedSample), (void**)&pTracked));
		CHECK_HR(hr = pTracked->SetAllocator(&m_SampleFreeCB, NULL)); 

	done:
		COM_SAFE_RELEASE(pTracked);
		return hr;
	}
	void	CustomEVRPresenter::ReleaseResources()
	{
		// Increment the token counter to indicate that all existing video samples
		// are "stale." As these samples get released, we'll dispose of them. 
		//
		// Note: The token counter is required because the samples are shared
		// between more than one thread, and they are returned to the presenter 
		// through an asynchronous callback (OnSampleFree). Without the token, we
		// might accidentally re-use a stale sample after the ReleaseResources
		// method returns.

		m_TokenCounter++;

		Flush();

		m_SamplePool.Clear();

		m_pPresenterEngine->ReleaseResources();
	}

	// t[XebsO
	HRESULT	CustomEVRPresenter::PrepareFrameStep( DWORD cSteps )
	{
		HRESULT hr = S_OK;

		// Cache the step count.
		m_FrameStep.steps += cSteps;

		// Set the frame-step state. 
		m_FrameStep.state = FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ;

		// If the clock is are already running, we can start frame-stepping now.
		// Otherwise, we will start when the clock starts.
		if (m_RenderState == RENDER_STATE_Đ)
		{
			hr = StartFrameStep();       
		}

		return hr;
	}
	HRESULT	CustomEVRPresenter::StartFrameStep()
	{
		HRESULT hr = S_OK;
		IMFSample *pSample = NULL;

		if (m_FrameStep.state == FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ)
		{

			// We have a frame-step request, and are waiting for the clock to start.
			// Set the state to "pending," which means we are waiting for samples.
			m_FrameStep.state = FRAMESTEP_NbN͎n܂ĂăTv҂Ă;

			// If the frame-step queue already has samples, process them now.
			while (!m_FrameStep.samples.IsEmpty() && (m_FrameStep.state == FRAMESTEP_NbN͎n܂ĂăTv҂Ă))
			{
				CHECK_HR(hr = m_FrameStep.samples.RemoveFront(&pSample));
				CHECK_HR(hr = DeliverFrameStepSample(pSample));
				COM_SAFE_RELEASE(pSample);

				// We break from this loop when:
				//   (a) the frame-step queue is empty, or
				//   (b) the frame-step operation is complete.
			}
		}
		else if (m_FrameStep.state == FRAMESTEP_ĂȂ)
		{
			// We are not frame stepping. Therefore, if the frame-step queue has samples, 
			// we need to process them normally.
			while (!m_FrameStep.samples.IsEmpty())
			{
				CHECK_HR(hr = m_FrameStep.samples.RemoveFront(&pSample));
				CHECK_HR(hr = DeliverSample(pSample, FALSE));
				COM_SAFE_RELEASE(pSample);
			}
		}

	done:
		COM_SAFE_RELEASE(pSample);
		return hr;
	}
	HRESULT	CustomEVRPresenter::DeliverFrameStepSample( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		IUnknown *pUnk = NULL;

		// For rate 0, discard any sample that ends earlier than the clock time.
		if (IsScrubbing() && m_pClock && IsSampleTimePassed(m_pClock, pSample))
		{
			// Discard this sample.
		}
		else if (m_FrameStep.state >= FRAMESTEP_`悷Tv̂ꂽ)
		{
			// A frame was already submitted. Put this sample on the frame-step queue, 
			// in case we are asked to step to the next frame. If frame-stepping is
			// cancelled, this sample will be processed normally.
			CHECK_HR(hr = m_FrameStep.samples.InsertBack(pSample));
		}
		else
		{
			// We're ready to frame-step.

			// Decrement the number of steps.
			if (m_FrameStep.steps > 0)
			{
				m_FrameStep.steps--;
			}

			if (m_FrameStep.steps > 0)
			{
				// This is not the last step. Discard this sample.
			}
			else if (m_FrameStep.state == FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ)
			{
				// This is the right frame, but the clock hasn't started yet. Put the
				// sample on the frame-step queue. When the clock starts, the sample
				// will be processed.
				CHECK_HR(hr = m_FrameStep.samples.InsertBack(pSample));
			}
			else
			{
				// This is the right frame *and* the clock has started. Deliver this sample.
				CHECK_HR(hr = DeliverSample(pSample, FALSE));

				// QI for IUnknown so that we can identify the sample later.
				// (Per COM rules, an object alwayss return the same pointer when QI'ed for IUnknown.)
				CHECK_HR(hr = pSample->QueryInterface(__uuidof(IUnknown), (void**)&pUnk));

				// Save this value.
				m_FrameStep.pSampleNoRef = (DWORD_PTR)pUnk; // No add-ref. 

				// NOTE: We do not AddRef the IUnknown pointer, because that would prevent the 
				// sample from invoking the OnSampleFree callback after the sample is presented. 
				// We use this IUnknown pointer purely to identify the sample later; we never
				// attempt to dereference the pointer.

				// Update our state.
				m_FrameStep.state = FRAMESTEP_`悷Tv̂ꂽ;
			}
		}
	done:
		COM_SAFE_RELEASE(pUnk);
		return hr;
	}
	HRESULT	CustomEVRPresenter::CompleteFrameStep( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		MFTIME hnsSampleTime = 0;
		MFTIME hnsSystemTime = 0;

		// Update our state.
		m_FrameStep.state = FRAMESTEP_Tv̕`͊;
		m_FrameStep.pSampleNoRef = NULL;

		// Notify the EVR that the frame-step is complete.
		tEVRɃCxgʒm(EC_STEP_COMPLETE, FALSE, 0); // FALSE = completed (not cancelled)

		// If we are scrubbing (rate == 0), also send the "scrub time" event.
		if (IsScrubbing())
		{
			// Get the time stamp from the sample.
			hr = pSample->GetSampleTime(&hnsSampleTime);
			if (FAILED(hr))
			{
				// No time stamp. Use the current presentation time.
				if (m_pClock)
				{
					(void)m_pClock->GetCorrelatedTime(0, &hnsSampleTime, &hnsSystemTime);
				}
				hr = S_OK; // (Not an error condition.)
			}

			tEVRɃCxgʒm(EC_SCRUB_TIME, LODWORD(hnsSampleTime), HIDWORD(hnsSampleTime));
		}
		return hr;
	}
	HRESULT	CustomEVRPresenter::CancelFrameStep()
	{
		FRAMESTEP_STATE oldState = m_FrameStep.state;

		m_FrameStep.state = FRAMESTEP_ĂȂ;
		m_FrameStep.steps = 0;
		m_FrameStep.pSampleNoRef = NULL;
		// Don't clear the frame-step queue yet, because we might frame step again.

		if (oldState > FRAMESTEP_ĂȂ && oldState < FRAMESTEP_Tv̕`͊)
		{
			// We were in the middle of frame-stepping when it was cancelled.
			// Notify the EVR.
			tEVRɃCxgʒm(EC_STEP_COMPLETE, TRUE, 0); // TRUE = cancelled
		}
		return S_OK;
	}

	// R[obN
	HRESULT	CustomEVRPresenter::OnSampleFree( IMFAsyncResult *pResult )
	{
		HRESULT hr = S_OK;
		IUnknown *pObject = NULL;
		IMFSample *pSample = NULL;
		IUnknown *pUnk = NULL;

		// Get the sample from the async result object.
		CHECK_HR(hr = pResult->GetObject(&pObject));
		CHECK_HR(hr = pObject->QueryInterface(__uuidof(IMFSample), (void**)&pSample));

		// If this sample was submitted for a frame-step, then the frame step is complete.
		if (m_FrameStep.state == FRAMESTEP_`悷Tv̂ꂽ) 
		{
			// QI the sample for IUnknown and compare it to our cached value.
			CHECK_HR(hr = pSample->QueryInterface(__uuidof(IMFSample), (void**)&pUnk));

			if (m_FrameStep.pSampleNoRef == (DWORD_PTR)pUnk)
			{
				// Notify the EVR. 
				CHECK_HR(hr = CompleteFrameStep(pSample));
			}

			// Note: Although pObject is also an IUnknown pointer, it's not guaranteed
			// to be the exact pointer value returned via QueryInterface, hence the 
			// need for the second QI.
		}

		m_ObjectLock.Lock();

		if (MFGetAttributeUINT32(pSample, MFSamplePresenter_SampleCounter, (UINT32)-1) == m_TokenCounter)
		{
			// Return the sample to the sample pool.
			CHECK_HR( hr = m_SamplePool.tTvv[ɖ߂( pSample ) );

			// Now that a free sample is available, process more data if possible.
			(void)ProcessOutputLoop();
		}

		m_ObjectLock.Unlock();

	done:
		if (FAILED(hr))
			tEVRɃCxgʒm(EC_ERRORABORT, hr, 0);

		COM_SAFE_RELEASE(pObject);
		COM_SAFE_RELEASE(pSample);
		COM_SAFE_RELEASE(pUnk);
		return hr;
	}

// private:

	RECT	CustomEVRPresenter::CorrectAspectRatio( const RECT& src, const MFRatio& srcPAR, const MFRatio& destPAR )
	{
		// Start with a rectangle the same size as src, but offset to the origin (0,0).
		RECT rc = {0, 0, src.right - src.left, src.bottom - src.top};

		// If the source and destination have the same PAR, there is nothing to do.
		// Otherwise, adjust the image size, in two steps:
		//  1. Transform from source PAR to 1:1
		//  2. Transform from 1:1 to destination PAR.

		if ((srcPAR.Numerator != destPAR.Numerator) || (srcPAR.Denominator != destPAR.Denominator))
		{
			// Correct for the source's PAR.

			if (srcPAR.Numerator > srcPAR.Denominator)
			{
				// The source has "wide" pixels, so stretch the width.
				rc.right = MulDiv(rc.right, srcPAR.Numerator, srcPAR.Denominator);
			}
			else if (srcPAR.Numerator < srcPAR.Denominator)
			{
				// The source has "tall" pixels, so stretch the height.
				rc.bottom = MulDiv(rc.bottom, srcPAR.Denominator, srcPAR.Numerator);
			}
			// else: PAR is 1:1, which is a no-op.


			// Next, correct for the target's PAR. This is the inverse operation of the previous.

			if (destPAR.Numerator > destPAR.Denominator)
			{
				// The destination has "wide" pixels, so stretch the height.
				rc.bottom = MulDiv(rc.bottom, destPAR.Numerator, destPAR.Denominator);
			}
			else if (destPAR.Numerator < destPAR.Denominator)
			{
				// The destination has "tall" pixels, so stretch the width.
				rc.right = MulDiv(rc.right, destPAR.Denominator, destPAR.Numerator);
			}
			// else: PAR is 1:1, which is a no-op.
		}

		return rc;
	}
	BOOL	CustomEVRPresenter::AreMediaTypesEqual( IMFMediaType *pType1, IMFMediaType *pType2 )
	{
		if ((pType1 == NULL) && (pType2 == NULL))
		{
			return TRUE; // Both are NULL.
		}
		else if ((pType1 == NULL) || (pType2 == NULL))
		{
			return FALSE; // One is NULL.
		}

		DWORD dwFlags = 0;
		HRESULT hr = pType1->IsEqual(pType2, &dwFlags);

		return (hr == S_OK);
	}
	HRESULT	CustomEVRPresenter::ValidateVideoArea( const MFVideoArea& area, UINT32 width, UINT32 height )
	{
		float fOffsetX = MFOffsetToFloat(area.OffsetX);
		float fOffsetY = MFOffsetToFloat(area.OffsetY);

		if ( ((LONG)fOffsetX + area.Area.cx > (LONG)width) ||
				((LONG)fOffsetY + area.Area.cy > (LONG)height) )
		{
			return MF_E_INVALIDMEDIATYPE;
		}
		else
		{
			return S_OK;
		}
	}
	HRESULT	CustomEVRPresenter::SetDesiredSampleTime( IMFSample *pSample, const LONGLONG& hnsSampleTime, const LONGLONG& hnsDuration )
	{
		if (pSample == NULL)
		{
			return E_POINTER;
		}

		HRESULT hr = S_OK;
		IMFDesiredSample *pDesired = NULL;

		hr = pSample->QueryInterface(__uuidof(IMFDesiredSample), (void**)&pDesired);
		if (SUCCEEDED(hr))
		{
			// This method has no return value.
			(void)pDesired->SetDesiredSampleTimeAndDuration(hnsSampleTime, hnsDuration);
		}

		COM_SAFE_RELEASE(pDesired);
		return hr;
	}
	HRESULT	CustomEVRPresenter::ClearDesiredSampleTime( IMFSample *pSample )
	{
		if (pSample == NULL)
		{
			return E_POINTER;
		}

		HRESULT hr = S_OK;
    
		IMFDesiredSample *pDesired = NULL;
		IUnknown *pUnkTexture = NULL;
    
		// We store some custom attributes on the sample, so we need to cache them
		// and reset them.
		//
		// This works around the fact that IMFDesiredSample::Clear() removes all of the
		// attributes from the sample. 

		UINT32 counter = MFGetAttributeUINT32(pSample, MFSamplePresenter_SampleCounter, (UINT32)-1);

		(void)pSample->GetUnknown(MFSamplePresenter_Texture, IID_IUnknown, (void**)&pUnkTexture);

		hr = pSample->QueryInterface(__uuidof(IMFDesiredSample), (void**)&pDesired);
		if (SUCCEEDED(hr))
		{
			// This method has no return value.
			(void)pDesired->Clear();

			CHECK_HR(hr = pSample->SetUINT32(MFSamplePresenter_SampleCounter, counter));

			if (pUnkTexture)
			{
				CHECK_HR(hr = pSample->SetUnknown(MFSamplePresenter_Texture, pUnkTexture));
			}
		}

	done:
		COM_SAFE_RELEASE(pUnkTexture);
		COM_SAFE_RELEASE(pDesired);
		return hr;
	}
	BOOL	CustomEVRPresenter::IsSampleTimePassed( IMFClock *pClock, IMFSample *pSample )
	{
		if (pSample == NULL || pClock == NULL)
		{
			return E_POINTER;
		}


		HRESULT hr = S_OK;
		MFTIME hnsTimeNow = 0;
		MFTIME hnsSystemTime = 0;
		MFTIME hnsSampleStart = 0;
		MFTIME hnsSampleDuration = 0;

		// The sample might lack a time-stamp or a duration, and the
		// clock might not report a time.

		hr = pClock->GetCorrelatedTime(0, &hnsTimeNow, &hnsSystemTime);

		if (SUCCEEDED(hr))
		{
			hr = pSample->GetSampleTime(&hnsSampleStart);
		}
		if (SUCCEEDED(hr))
		{
			hr = pSample->GetSampleDuration(&hnsSampleDuration);
		}

		if (SUCCEEDED(hr))
		{
			if (hnsSampleStart + hnsSampleDuration < hnsTimeNow)
			{
				return TRUE; 
			}
		}

		return FALSE;
	}
	HRESULT	CustomEVRPresenter::SetMixerSourceRect( IMFTransform *pMixer, const MFVideoNormalizedRect& nrcSource )
	{
		if (pMixer == NULL)
		{
			return E_POINTER;
		}

		HRESULT hr = S_OK;
		IMFAttributes *pAttributes = NULL;

		CHECK_HR(hr = pMixer->GetAttributes(&pAttributes));

		CHECK_HR(hr = pAttributes->SetBlob(VIDEO_ZOOM_RECT, (const UINT8*)&nrcSource, sizeof(nrcSource)));
        
	done:
		COM_SAFE_RELEASE(pAttributes);
		return hr;
	}
}

