#include "stdafx.h"
#include "refDeviceConstantConverter.h"

namespace FDK
{
// public:

	Key DeviceConstantConverter::DIKtoKey( int dik )
	{
		switch( dik )
		{
			case 1:
				return Key::Escape;

			case 2:
				return Key::D1;

			case 3:
				return Key::D2;

			case 4:
				return Key::D3;

			case 5:
				return Key::D4;

			case 6:
				return Key::D5;

			case 7:
				return Key::D6;

			case 8:
				return Key::D7;

			case 9:
				return Key::D8;

			case 10:
				return Key::D9;

			case 11:
				return Key::D0;

			case 12:
				return Key::Minus;

			case 13:
				return Key::Equals;

			case 14:
				return Key::Backspace;

			case 15:
				return Key::Tab;

			case 16:
				return Key::Q;

			case 17:
				return Key::W;

			case 18:
				return Key::E;

			case 19:
				return Key::R;

			case 20:
				return Key::T;

			case 21:
				return Key::Y;

			case 22:
				return Key::U;

			case 23:
				return Key::I;

			case 24:
				return Key::O;

			case 25:
				return Key::P;

			case 26:
				return Key::LeftBracket;

			case 27:
				return Key::RightBracket;

			case 28:
				return Key::Return;

			case 29:
				return Key::LeftControl;

			case 30:
				return Key::A;

			case 31:
				return Key::S;

			case 32:
				return Key::D;

			case 33:
				return Key::F;

			case 34:
				return Key::G;

			case 35:
				return Key::H;

			case 36:
				return Key::J;

			case 37:
				return Key::K;

			case 38:
				return Key::L;

			case 39:
				return Key::Semicolon;

			case 40:
				return Key::Apostrophe;

			case 41:
				return Key::Grave;

			case 42:
				return Key::LeftShift;

			case 43:
				return Key::Backslash;

			case 44:
				return Key::Z;

			case 45:
				return Key::X;

			case 46:
				return Key::C;

			case 47:
				return Key::V;

			case 48:
				return Key::B;

			case 49:
				return Key::N;

			case 50:
				return Key::M;

			case 51:
				return Key::Comma;

			case 52:
				return Key::Period;

			case 53:
				return Key::Slash;

			case 54:
				return Key::RightShift;

			case 55:
				return Key::NumberPadStar;

			case 56:
				return Key::LeftAlt;

			case 57:
				return Key::Space;

			case 58:
				return Key::CapsLock;

			case 59:
				return Key::F1;

			case 60:
				return Key::F2;

			case 61:
				return Key::F3;

			case 62:
				return Key::F4;

			case 63:
				return Key::F5;

			case 64:
				return Key::F6;

			case 65:
				return Key::F7;

			case 66:
				return Key::F8;

			case 67:
				return Key::F9;

			case 68:
				return Key::F10;

			case 69:
				return Key::NumberLock;

			case 70:
				return Key::ScrollLock;

			case 71:
				return Key::NumberPad7;

			case 72:
				return Key::NumberPad8;

			case 73:
				return Key::NumberPad9;

			case 74:
				return Key::NumberPadMinus;

			case 75:
				return Key::NumberPad4;

			case 76:
				return Key::NumberPad5;

			case 77:
				return Key::NumberPad6;

			case 78:
				return Key::NumberPadPlus;

			case 79:
				return Key::NumberPad1;

			case 80:
				return Key::NumberPad2;

			case 81:
				return Key::NumberPad3;

			case 82:
				return Key::NumberPad0;

			case 83:
				return Key::NumberPadPeriod;

			case 86:
				return Key::Oem102;

			case 87:
				return Key::F11;

			case 88:
				return Key::F12;

			case 100:
				return Key::F13;

			case 101:
				return Key::F14;

			case 102:
				return Key::F15;

			case 112:
				return Key::Kana;

			case 115:
				return Key::AbntC1;

			case 121:
				return Key::Convert;

			case 123:
				return Key::NoConvert;

			case 125:
				return Key::Yen;

			case 126:
				return Key::AbntC2;

			case 141:
				return Key::NumberPadEquals;

			case 144:
				return Key::PreviousTrack;

			case 145:
				return Key::AT;

			case 146:
				return Key::Colon;

			case 147:
				return Key::Underline;

			case 148:
				return Key::Kanji;

			case 149:
				return Key::Stop;

			case 150:
				return Key::AX;

			case 151:
				return Key::Unlabeled;

			case 153:
				return Key::NextTrack;

			case 156:
				return Key::NumberPadEnter;

			case 157:
				return Key::RightControl;

			case 160:
				return Key::Mute;

			case 161:
				return Key::Calculator;

			case 162:
				return Key::PlayPause;

			case 164:
				return Key::MediaStop;

			case 174:
				return Key::VolumeDown;

			case 176:
				return Key::VolumeUp;

			case 178:
				return Key::WebHome;

			case 179:
				return Key::NumberPadComma;

			case 181:
				return Key::NumberPadSlash;

			case 183:
				return Key::PrintScreen;

			case 184:
				return Key::RightAlt;

			case 197:
				return Key::Pause;

			case 199:
				return Key::Home;

			case 200:
				return Key::UpArrow;

			case 201:
				return Key::PageUp;

			case 203:
				return Key::LeftArrow;

			case 205:
				return Key::RightArrow;

			case 207:
				return Key::End;

			case 208:
				return Key::DownArrow;

			case 209:
				return Key::PageDown;

			case 210:
				return Key::Insert;

			case 211:
				return Key::Delete;

			case 219:
				return Key::LeftWindowsKey;

			case 220:
				return Key::RightWindowsKey;

			case 221:
				return Key::Applications;

			case 222:
				return Key::Power;

			case 223:
				return Key::Sleep;

			case 227:
				return Key::Wake;

			case 229:
				return Key::WebSearch;

			case 230:
				return Key::WebFavorites;

			case 231:
				return Key::WebRefresh;

			case 232:
				return Key::WebStop;

			case 233:
				return Key::WebForward;

			case 234:
				return Key::WebBack;

			case 235:
				return Key::MyComputer;

			case 236:
				return Key::Mail;

			case 237:
				return Key::MediaSelect;
		}
		return Key::Unknown;
	}
	int DeviceConstantConverter::KeyToDIK( Key key )
	{
		switch( key )
		{
			case Key::D0:
				return 11;

			case Key::D1:
				return 2;

			case Key::D2:
				return 3;

			case Key::D3:
				return 4;

			case Key::D4:
				return 5;

			case Key::D5:
				return 6;

			case Key::D6:
				return 7;

			case Key::D7:
				return 8;

			case Key::D8:
				return 9;

			case Key::D9:
				return 10;

			case Key::A:
				return 30;

			case Key::B:
				return 48;

			case Key::C:
				return 0x2e;

			case Key::D:
				return 0x20;

			case Key::E:
				return 0x12;

			case Key::F:
				return 0x21;

			case Key::G:
				return 0x22;

			case Key::H:
				return 0x23;

			case Key::I:
				return 0x17;

			case Key::J:
				return 0x24;

			case Key::K:
				return 0x25;

			case Key::L:
				return 0x26;

			case Key::M:
				return 50;

			case Key::N:
				return 0x31;

			case Key::O:
				return 0x18;

			case Key::P:
				return 0x19;

			case Key::Q:
				return 0x10;

			case Key::R:
				return 0x13;

			case Key::S:
				return 0x1f;

			case Key::T:
				return 20;

			case Key::U:
				return 0x16;

			case Key::V:
				return 0x2f;

			case Key::W:
				return 0x11;

			case Key::X:
				return 0x2d;

			case Key::Y:
				return 0x15;

			case Key::Z:
				return 0x2c;

			case Key::AbntC1:
				return 0x73;

			case Key::AbntC2:
				return 0x7e;

			case Key::Apostrophe:
				return 40;

			case Key::Applications:
				return 0xdd;

			case Key::AT:
				return 0x91;

			case Key::AX:
				return 150;

			case Key::Backspace:
				return 14;

			case Key::Backslash:
				return 0x2b;

			case Key::Calculator:
				return 0xa1;

			case Key::CapsLock:
				return 0x3a;

			case Key::Colon:
				return 0x92;

			case Key::Comma:
				return 0x33;

			case Key::Convert:
				return 0x79;

			case Key::Delete:
				return 0xd3;

			case Key::DownArrow:
				return 0xd0;

			case Key::End:
				return 0xcf;

			case Key::Equals:
				return 13;

			case Key::Escape:
				return 1;

			case Key::F1:
				return 0x3b;

			case Key::F2:
				return 60;

			case Key::F3:
				return 0x3d;

			case Key::F4:
				return 0x3e;

			case Key::F5:
				return 0x3f;

			case Key::F6:
				return 0x40;

			case Key::F7:
				return 0x41;

			case Key::F8:
				return 0x42;

			case Key::F9:
				return 0x43;

			case Key::F10:
				return 0x44;

			case Key::F11:
				return 0x57;

			case Key::F12:
				return 0x58;

			case Key::F13:
				return 100;

			case Key::F14:
				return 0x65;

			case Key::F15:
				return 0x66;

			case Key::Grave:
				return 0x29;

			case Key::Home:
				return 0xc7;

			case Key::Insert:
				return 210;

			case Key::Kana:
				return 0x70;

			case Key::Kanji:
				return 0x94;

			case Key::LeftBracket:
				return 0x1a;

			case Key::LeftControl:
				return 0x1d;

			case Key::LeftArrow:
				return 0xcb;

			case Key::LeftAlt:
				return 0x38;

			case Key::LeftShift:
				return 0x2a;

			case Key::LeftWindowsKey:
				return 0xdb;

			case Key::Mail:
				return 0xec;

			case Key::MediaSelect:
				return 0xed;

			case Key::MediaStop:
				return 0xa4;

			case Key::Minus:
				return 12;

			case Key::Mute:
				return 160;

			case Key::MyComputer:
				return 0xeb;

			case Key::NextTrack:
				return 0x99;

			case Key::NoConvert:
				return 0x7b;

			case Key::NumberLock:
				return 0x45;

			case Key::NumberPad0:
				return 0x52;

			case Key::NumberPad1:
				return 0x4f;

			case Key::NumberPad2:
				return 80;

			case Key::NumberPad3:
				return 0x51;

			case Key::NumberPad4:
				return 0x4b;

			case Key::NumberPad5:
				return 0x4c;

			case Key::NumberPad6:
				return 0x4d;

			case Key::NumberPad7:
				return 0x47;

			case Key::NumberPad8:
				return 0x48;

			case Key::NumberPad9:
				return 0x49;

			case Key::NumberPadComma:
				return 0xb3;

			case Key::NumberPadEnter:
				return 0x9c;

			case Key::NumberPadEquals:
				return 0x8d;

			case Key::NumberPadMinus:
				return 0x4a;

			case Key::NumberPadPeriod:
				return 0x53;

			case Key::NumberPadPlus:
				return 0x4e;

			case Key::NumberPadSlash:
				return 0xb5;

			case Key::NumberPadStar:
				return 0x37;

			case Key::Oem102:
				return 0x56;

			case Key::PageDown:
				return 0xd1;

			case Key::PageUp:
				return 0xc9;

			case Key::Pause:
				return 0xc5;

			case Key::Period:
				return 0x34;

			case Key::PlayPause:
				return 0xa2;

			case Key::Power:
				return 0xde;

			case Key::PreviousTrack:
				return 0x90;

			case Key::RightBracket:
				return 0x1b;

			case Key::RightControl:
				return 0x9d;

			case Key::Return:
				return 0x1c;

			case Key::RightArrow:
				return 0xcd;

			case Key::RightAlt:
				return 0xb8;

			case Key::RightShift:
				return 0x36;

			case Key::RightWindowsKey:
				return 220;

			case Key::ScrollLock:
				return 70;

			case Key::Semicolon:
				return 0x27;

			case Key::Slash:
				return 0x35;

			case Key::Sleep:
				return 0xdf;

			case Key::Space:
				return 0x39;

			case Key::Stop:
				return 0x95;

			case Key::PrintScreen:
				return 0xb7;

			case Key::Tab:
				return 15;

			case Key::Underline:
				return 0x93;

			case Key::Unlabeled:
				return 0x97;

			case Key::UpArrow:
				return 200;

			case Key::VolumeDown:
				return 0xae;

			case Key::VolumeUp:
				return 0xb0;

			case Key::Wake:
				return 0xe3;

			case Key::WebBack:
				return 0xea;

			case Key::WebFavorites:
				return 230;

			case Key::WebForward:
				return 0xe9;

			case Key::WebHome:
				return 0xb2;

			case Key::WebRefresh:
				return 0xe7;

			case Key::WebSearch:
				return 0xe5;

			case Key::WebStop:
				return 0xe8;

			case Key::Yen:
				return 0x7d;
		}
		return 0;
	}
}
