#include "stdafx.h"
#include "refCInputKeyboard.h"
#include "refDeviceConstantConverter.h"
#include "refCInputǗ.h"

namespace FDK
{
	CInputKeyboard::CInputKeyboard( IntPtr hWnd, IDirectInput8 *pDI )
	{
		HRESULT hr = S_OK;

		this->e̓foCX = E̓foCX::L[{[h;
		this->guid = nullptr;
		this->ID = 0;
		this->strfoCX = "Keyboard";

		this->bKeyPullUp = gcnew array<bool>( 256 );
		this->bKeyPushDown = gcnew array<bool>( 256 );
		this->bKeyState = gcnew array<bool>( 256 );

		#pragma region [ L[{[hfoCX𐶐B]
		//-----------------
		try
		{
			IDirectInputDevice8 *pdev;
			tFAILEDȂO( L"L[{[hfoCX̐", 
									hr = pDI->CreateDevice( GUID_SysKeyboard, &pdev, NULL ) );
			this->pDevice = pdev;
					
			tFAILEDȂO( L"L[{[hfoCX̋x̐ݒ",
									hr = this->pDevice->SetCooperativeLevel( (HWND)(void*)hWnd, DISCL_NOWINKEY | DISCL_FOREGROUND | DISCL_NONEXCLUSIVE ) );
					
			tFAILEDȂO( L"L[{[hfoCX̃tH[}bg̐ݒ",
									hr = this->pDevice->SetDataFormat( &c_dfDIKeyboard ) );

			DIPROPDWORD dipwd;
			dipwd.diph.dwSize = sizeof(DIPROPDWORD);
			dipwd.diph.dwHeaderSize = sizeof(DIPROPHEADER);
			dipwd.diph.dwObj = 0;
			dipwd.diph.dwHow = DIPH_DEVICE;
			dipwd.dwData = 32;
			tFAILEDȂO( L"L[{[hfoCX̃obt@TCY̐ݒ",
									hr = this->pDevice->SetProperty( DIPROP_BUFFERSIZE, &dipwd.diph ) );
		}
		catch( Exception^ )
		{
			COM_SAFE_RELEASE( this->pDevice );
			throw;
		}
		//-----------------
		#pragma endregion
		#pragma region [ L[{[hfoCX Acquire B]
		//-----------------
		hr = this->pDevice->Acquire();		// sĂAɉȂB
		//-----------------
		#pragma endregion

		// L[ԔzB
		for( int i = 0; i < this->bKeyState->Length; i++ )
			this->bKeyState[ i ] = false;

		// ^C}[𐶐B
		this->timer = gcnew CTimer( CTimer::E::MultiMedia );
	}
	CInputKeyboard::~CInputKeyboard()
	{
		COM_SAFE_RELEASE( this->pDevice );
		REF_SAFE_DELETE( this->timer );

		GC::SuppressFinalize( this );
		GC::KeepAlive( this );
	}
	
	void CInputKeyboard::t|[O( bool bWindowANeBu, bool bobt@͂gp )
	{
		HRESULT hr = S_OK;

		// ԃobt@NAB

		for( int i = 0; i < 256; i++ )
		{
			this->bKeyPushDown[ i ] = false;
			this->bKeyPullUp[ i ] = false;
		}

		// 擾|[O̓CxgXg쐬B

		if( bWindowANeBu && 
			this->pDevice != NULL &&
			SUCCEEDED( this->pDevice->Acquire() ) && 
			SUCCEEDED( this->pDevice->Poll() ) )
		{
			this->list̓Cxg = gcnew List<CInputEvent^>( 32 );

			if( bobt@͂gp )
			{
				#pragma region [ (A) obt@ ]
				//-----------------------------
				DIDEVICEOBJECTDATA bufferedData[32];
				DWORD dwItems = 32;
				hr = this->pDevice->GetDeviceData( sizeof(DIDEVICEOBJECTDATA), bufferedData, &dwItems, 0 );
				if( FAILED( hr ) || dwItems == 0 )
					return;

				for( DWORD i = 0; i < dwItems; i++ )
				{
					if( bufferedData[ i ].dwData != 0 )
					{
						#pragma region [ a. ꂽ ]
						//-----------------
						Key key = DeviceConstantConverter::DIKtoKey( bufferedData[ i ].dwOfs );
						if( key == Key::Unknown )
							continue;

						CInputEvent^ ev = gcnew CInputEvent();
						ev->guid = this->guid;
						ev->ID = this->ID;
						ev->nKey = (int) key;
						ev->bꂽ = true;
						ev->nTimeStamp = bufferedData[ i ].dwTimeStamp;
						ev->nVelocity = CInputǗ::nʏ퉹;
						this->list̓Cxg->Add( ev );
						this->bKeyState[ (int) key ] = true;
						this->bKeyPushDown[ (int) key ] = true;
						//-----------------
						#pragma endregion
					}
					else
					{
						#pragma region [ b. ꂽ ]
						//-----------------
						Key key = DeviceConstantConverter::DIKtoKey( bufferedData[ i ].dwOfs );
						if( key == Key::Unknown )
							continue;

						CInputEvent^ ev = gcnew CInputEvent();
						ev->guid = this->guid;
						ev->ID = this->ID;
						ev->nKey = (int) key;
						ev->bꂽ = false;
						ev->nTimeStamp = bufferedData[ i ].dwTimeStamp;
						ev->nVelocity = 0;
						this->list̓Cxg->Add( ev );
						this->bKeyState[ (int) key ] = false;
						this->bKeyPullUp[ (int) key ] = true;
						//-----------------
						#pragma endregion
					}
				}
				//-----------------------------
				#pragma endregion
			}
			else
			{
				#pragma region [ (B) ԓ ]
				//-----------------
				BYTE keys[ 256 ];
				hr = this->pDevice->GetDeviceState( 256, keys );
				if( FAILED( hr ) )
					return;

				for( int i = 0; i < 256; i++ )
				{
					if( keys[ i ] != 0 )
					{
						if( this->bKeyState[ i ] == false )
						{
							#pragma region [ a. Ă  O͗Ă ]
							//-----------------
							CInputEvent^ ev = gcnew CInputEvent();
							ev->guid = this->guid;
							ev->ID = this->ID;
							ev->nKey = i;
							ev->bꂽ = true;
							ev->nTimeStamp = this->timer->nVXems;
							ev->nVelocity = CInputǗ::nʏ퉹;
							this->list̓Cxg->Add( ev );
									
							this->bKeyState[ i ] = true;
							this->bKeyPushDown[ i ] = true;
							//-----------------
							#pragma endregion
						}
					}
					else
					{
						if( this->bKeyState[ i ] == true )
						{
							#pragma region [ b. Ă  O͉Ă ]
							//-----------------
							CInputEvent^ ev = gcnew CInputEvent();
							ev->guid = this->guid;
							ev->ID = this->ID;
							ev->nKey = i;
							ev->bꂽ = false;
							ev->nTimeStamp = this->timer->nVXems;
							ev->nVelocity = 0;
							this->list̓Cxg->Add( ev );
					
							this->bKeyState[ i ] = false;
							this->bKeyPullUp[ i ] = true;
							//-----------------
							#pragma endregion
						}
					}
				}
				//-----------------
				#pragma endregion
			}
		}
	}
}