#include "stdafx.h"
#include "CDirect3DNative.h"
#include "DrawTexture.h"
#include "refCTexture.h"

namespace FDK
{
// public:

	CTexture::CTexture()
	{
		this->t();
	}
	CTexture::~CTexture()
	{
		COM_SAFE_RELEASE( this->pTexture )

		GC::SuppressFinalize( this );
		GC::KeepAlive( this );
	}

	CTexture::CTexture( IntPtr hLockedDevice, String^ strt@C, D3DFormat format, bool b𓧉߂ )
	{
		this->teNX`쐬( hLockedDevice, strt@C, format, b𓧉߂ );
	}
	CTexture::CTexture( IntPtr hLockedDevice, String^ strt@C, D3DFormat format )
	{
		this->teNX`쐬( hLockedDevice, strt@C, format, false );
	}
	CTexture::CTexture( IntPtr hLockedDevice, String^ strt@C )
	{
		this->teNX`쐬( hLockedDevice, strt@C, D3DFormat::A8R8G8B8, false );
	}
	CTexture::CTexture( IntPtr hLockedDevice, Bitmap^ bitmap, D3DFormat format, bool b𓧉߂ )
	{
		this->teNX`쐬( hLockedDevice, bitmap, format, b𓧉߂ );
	}
	CTexture::CTexture( IntPtr hLockedDevice, Bitmap^ bitmap, D3DFormat format )
	{
		this->teNX`쐬( hLockedDevice, bitmap, format, false );
	}
	CTexture::CTexture( IntPtr hLockedDevice, Bitmap^ bitmap )
	{
		this->teNX`쐬( hLockedDevice, bitmap, D3DFormat::A8R8G8B8, false );
	}
	CTexture::CTexture( IntPtr hLockedDevice, int n, int n, D3DFormat format )
	{
		this->teNX`쐬( hLockedDevice, n, n, format );
	}
	CTexture::CTexture( IntPtr hLockedDevice, int n, int n )
	{
		this->teNX`쐬( hLockedDevice, n, n, D3DFormat::A8R8G8B8 );
	}

	CTexture^ CTexture::teNX`쐬( IntPtr hLockedDevice, String^ str, Font^ fttHg, D3DFormat TextureFormat )
	{
		SizeF sz̃TCY;
		Bitmap ^b = nullptr;
		Graphics^ g = nullptr;

		#pragma region [ ̃TCY(SizeF)[px] 擾B]
		//-----------------
		b = gcnew Bitmap( 1, 1 );
		g = Graphics::FromImage( b );
		{
			g->PageUnit = GraphicsUnit::Pixel;
			sz̃TCY = g->MeasureString( str, fttHg );
		}
		delete g;
		delete b;
		//-----------------
		#pragma endregion

		CTexture^ tx;

		#pragma region [ 擾TCỸeNX`쐬B ]
		//-----------------
		b = gcnew Bitmap( (int) sz̃TCY.Width, (int) sz̃TCY.Height, PixelFormat::Format32bppArgb );
		g = Graphics::FromImage( b );
		{
			g->DrawString( str, fttHg, Brushes::White, 0.0f, 0.0f );
			tx = gcnew CTexture( hLockedDevice, b, TextureFormat );
		}
		delete g;
		delete b;
		//-----------------
		#pragma endregion

		return tx;
	}
	CTexture^ CTexture::teNX`쐬( IntPtr hLockedDevice, String^ str, D3DFormat TextureFormat )
	{
		CTexture^ tx = nullptr;

		// WSVbNE16px ̃tHggpB
		Font^ fttHg = gcnew Font( FontFamily::GenericSansSerif, 16.0f, FontStyle::Regular, GraphicsUnit::Pixel );
		tx = CTexture::teNX`쐬( hLockedDevice, str, fttHg, TextureFormat );
		delete fttHg;

		return tx;
	}
	CTexture^ CTexture::teNX`쐬( IntPtr hLockedDevice, String^ str )
	{
		return CTexture::teNX`쐬( hLockedDevice, str, D3DFormat::A8R8G8B8 );
	}

	void CTexture::t3D`( IntPtr hLockedDevice, Matrix mat, System::Drawing::Rectangle rc摜̕`̈ )
	{
		HANDLE hDev = static_cast<HANDLE>( hLockedDevice.ToPointer() );

		#pragma region [ s`FbN ]
		//-----------------
		if( hLockedDevice == IntPtr::Zero || this->pTexture == NULL )
			return;
		//-----------------
		#pragma endregion

		RECT rc;
		rc.left = rc摜̕`̈.Left;
		rc.right = rc摜̕`̈.Right;
		rc.top = rc摜̕`̈.Top;
		rc.bottom = rc摜̕`̈.Bottom;

		IDirect3DDevice9Ex *pDevice = CDirect3DNative::tD3DfoCX擾( hDev );
		DrawTexture::t3D`( pDevice, this->pTexture, this->_nx, this->bZ, &Matrix::ToD3DXMATRIX( mat ),  &rc );
	}
	void CTexture::t3D`( IntPtr hLockedDevice, Matrix mat )
	{
		this->t3D`( hLockedDevice, mat, this->rcS摜 );
	}

	void CTexture::t2D`( IntPtr hLockedDevice, int x, int y, float depth, System::Drawing::Rectangle rc摜̕`̈ )
	{
		HANDLE hDev = static_cast<HANDLE>( hLockedDevice.ToPointer() );

		#pragma region [ s`FbN ]
		//-----------------
		if( hLockedDevice == IntPtr::Zero || this->pTexture == NULL )
			return;
		//-----------------
		#pragma endregion

		RECT rc;
		rc.left = rc摜̕`̈.Left;
		rc.right = rc摜̕`̈.Right;
		rc.top = rc摜̕`̈.Top;
		rc.bottom = rc摜̕`̈.Bottom;

		IDirect3DDevice9Ex *pDevice = CDirect3DNative::tD3DfoCX擾( hDev );
		DrawTexture::t2D`( pDevice, this->pTexture, this->_nx, this->bZ, this->vcgk{.X, this->vcgk{.Y, x, y, depth,  &rc );
	}
	void CTexture::t2D`( IntPtr hLockedDevice, int x, int y, System::Drawing::Rectangle rc摜̕`̈ )
	{
		this->t2D`( hLockedDevice, x, y, 1.0f, rc摜̕`̈ );
	}
	void CTexture::t2D`( IntPtr hLockedDevice, int x, int y )
	{
		this->t2D`( hLockedDevice, x, y, 1.0f, this->rcS摜 );
	}
	void CTexture::t2D`( IntPtr hLockedDevice, Point pt, float depth, System::Drawing::Rectangle rc摜̕`̈ )
	{
		this->t2D`( hLockedDevice, pt.X, pt.Y, depth, rc摜̕`̈ );
	}
	void CTexture::t2D`( IntPtr hLockedDevice, Point pt, System::Drawing::Rectangle rc摜̕`̈ )
	{
		this->t2D`( hLockedDevice, pt.X, pt.Y, 1.0f, rc摜̕`̈ );
	}
	void CTexture::t2D`( IntPtr hLockedDevice, Point pt )
	{
		this->t2D`( hLockedDevice, pt.X, pt.Y, 1.0f, this->rcS摜 );
	}

// protected:

	Size CTexture::tw肳ꂽTCY𒴂ȂœKȃeNX`TCYԂ( IDirect3DDevice9Ex *pDevice, Size szwTCY )
	{
		HRESULT hr = S_OK;

		D3DCAPS9 caps;
		::ZeroMemory( &caps, sizeof(D3DCAPS9) );

		tFAILEDȂO( L"w肳ꂽTCY𒴂ȂœKȃeNX`TCY̎擾",
								hr = pDevice->GetDeviceCaps( &caps ) );
				
		bool bNonPow2Conditional = ( caps.TextureCaps & D3DPTEXTURECAPS_NONPOW2CONDITIONAL ) != 0;
		bool bPow2 = ( caps.TextureCaps & D3DPTEXTURECAPS_POW2 ) != 0;
		bool bSquareOnly = ( caps.TextureCaps & D3DPTEXTURECAPS_SQUAREONLY ) != 0;
		int maxTextureWidth = caps.MaxTextureWidth;
		int maxTextureHeight = caps.MaxTextureHeight;

		Size size = Size( szwTCY.Width, szwTCY.Height );

		if( bPow2 && !bNonPow2Conditional )
		{
			int n = 1;
			do
			{
				n *= 2;
			}
			while( n <= szwTCY.Width );
			szwTCY.Width = n;
				
			n = 1;
			do
			{
				n *= 2;
			}
			while( n <= szwTCY.Height );
			szwTCY.Height = n;
		}

		if( szwTCY.Width > maxTextureWidth )
			szwTCY.Width = maxTextureWidth;

		if( szwTCY.Height > maxTextureHeight )
			szwTCY.Height = maxTextureHeight;

		if( bSquareOnly )
		{
			if( size.Width > size.Height )
			{
				size.Height = size.Width;
				return size;
			}
			if( size.Width < size.Height )
			{
				size.Width = size.Height;
			}
		}

		return size;
	}

// private:

	// RXgN^I[o[[hăRXgN^mŌĂяoƓe߂ႭɂȂ̂ŁAX̃\bhƂēƗB

	void CTexture::t()
	{
		this->bZ = false;
		this->_nx = 255;
		this->_szeNX`TCY = Size( 0, 0 );
		this->_sz摜TCY = Size( 0, 0 );
		this->_D3DFormat = D3DFMT_X8R8G8B8;
		this->vcgk{ = Vector3( 1.0, 1.0, 1.0 );
		this->_list`͈ = gcnew List<System::Drawing::Rectangle>();
	}

	// bNĂĂяoƁB
	void CTexture::teNX`쐬( IntPtr hLockedDevice, String^ strt@C, D3DFormat format, bool b𓧉߂ )
	{
		HRESULT hr = S_OK;
		HANDLE hDev = static_cast<HANDLE>( hLockedDevice.ToPointer() );
				
		this->t();

		if( !File::Exists( strt@C ) )		// ImageInformation ł FileNotFound O͕ԂĂȂ̂ŁAŎŃ`FbNB킩₷Ô߂ɁB
			throw gcnew FileNotFoundException( String::Format( "t@C݂܂B\n[{0}]", strt@C ) );
			
		pin_ptr<const wchar_t> fileName = ::PtrToStringChars( strt@C );

		D3DXIMAGE_INFO info;
		::ZeroMemory( &info, sizeof(D3DXIMAGE_INFO) );
		tFAILEDȂO( L"摜̎擾", hr = ::D3DXGetImageInfoFromFile( fileName, &info ) );
		this->d3dtH[}bg = format;
		this->sz摜TCY = Size( info.Width, info.Height );
		this->rcS摜 = System::Drawing::Rectangle( 0, 0, this->sz摜TCY.Width, this->sz摜TCY.Height );
		DWORD colorKey = ( b𓧉߂ ) ? 0xFF000000 : 0x00000000;

		IDirect3DDevice9Ex *pDevice = CDirect3DNative::tD3DfoCX擾( hDev );

		if( SUCCEEDED( hr ) )
		{					
			this->szeNX`TCY = this->tw肳ꂽTCY𒴂ȂœKȃeNX`TCYԂ( pDevice, this->sz摜TCY );

			IDirect3DTexture9 *pTexture = NULL;

			tFAILEDȂO( L"t@C̃eNX`̍쐬", 
									hr = ::D3DXCreateTextureFromFileEx(
												pDevice, 
												fileName,
												this->szeNX`TCY.Width,		// TCY D3DX_DEFAULT ɂƁAQ̗ݏɂꂽɉ摜߂ςXP[OĂ܂B
												this->szeNX`TCY.Height,	//
												1,
												0,
												(D3DFORMAT) format,
												D3DPOOL_DEFAULT,
												D3DX_FILTER_POINT,
												D3DX_FILTER_NONE,
												colorKey,
												NULL,
												NULL,
												&pTexture ) );

			this->pTexture = pTexture;

			D3DSURFACE_DESC desc;
			pTexture->GetLevelDesc( 0, &desc );
			this->szeNX`TCY.Width = desc.Width;
			this->szeNX`TCY.Height = desc.Height;
		}
	}
	void CTexture::teNX`쐬( IntPtr hLockedDevice, Bitmap^ bitmap, D3DFormat format, bool b𓧉߂ )
	{
		HRESULT hr = S_OK;
		HANDLE hDev = static_cast<HANDLE>( hLockedDevice.ToPointer() );

		this->t();

		this->d3dtH[}bg = format;
		this->sz摜TCY = Size( bitmap->Width, bitmap->Height );
		this->rcS摜 = System::Drawing::Rectangle( 0, 0, this->sz摜TCY.Width, this->sz摜TCY.Height );

		MemoryStream^ stream = gcnew MemoryStream();
		{
			bitmap->Save( stream, ImageFormat::Bmp );
			stream->Seek( 0L, System::IO::SeekOrigin::Begin );
			DWORD colorKey = ( b𓧉߂ ) ? 0xFF000000 : 0x00000000;

			IDirect3DDevice9Ex *pDevice = CDirect3DNative::tD3DfoCX擾( hDev );

			if( SUCCEEDED( hr ) )
			{					
				this->szeNX`TCY = this->tw肳ꂽTCY𒴂ȂœKȃeNX`TCYԂ( pDevice, this->sz摜TCY );

				IDirect3DTexture9 *pTexture = NULL;

				UINT nf[^ = (UINT)( stream->Length - stream->Position );
				array<Byte>^ rf[^obt@ = gcnew array<Byte>( nf[^ );
				UINT nǂݍ݊f[^ = 0;
				while( nǂݍ݊f[^ < nf[^ )
					nǂݍ݊f[^ += stream->Read( rf[^obt@, nǂݍ݊f[^, nf[^ - nǂݍ݊f[^ );
				pin_ptr<byte> pf[^obt@ = &rf[^obt@[ 0 ];

				tFAILEDȂO( L"Bitmap ̃eNX`̍쐬", 
										hr = ::D3DXCreateTextureFromFileInMemoryEx( 
													pDevice,
													pf[^obt@,
													nf[^,
													this->szeNX`TCY.Width,
													this->szeNX`TCY.Height,
													1,
													0,
													(D3DFORMAT) format,
													D3DPOOL_DEFAULT,
													D3DX_FILTER_POINT,
													D3DX_FILTER_NONE,
													colorKey,
													NULL,
													NULL,
													&pTexture ) );
				this->pTexture = pTexture;
			}
		}
		delete stream;
	}
	void CTexture::teNX`쐬( IntPtr hLockedDevice, int n, int n, D3DFormat format )
	{
		HRESULT hr = S_OK;
		HANDLE hDev = static_cast<HANDLE>( hLockedDevice.ToPointer() );

		this->t();

		this->d3dtH[}bg = format;
		this->sz摜TCY = Size( n, n );
		this->rcS摜 = System::Drawing::Rectangle( 0, 0, this->sz摜TCY.Width, this->sz摜TCY.Height );
				
		Bitmap^ bitmap = gcnew Bitmap( 1, 1 );
		{
			Graphics^ graphics = Graphics::FromImage( bitmap );
			graphics->FillRectangle( Brushes::Black, 0, 0, 1, 1 );
			delete graphics;

			MemoryStream^ stream = gcnew MemoryStream();
			{
				bitmap->Save( stream, ImageFormat::Bmp );
				stream->Seek( 0L, System::IO::SeekOrigin::Begin );
				DWORD colorKey = 0x00000000;

				IDirect3DDevice9Ex *pDevice = CDirect3DNative::tD3DfoCX擾( hDev );

				if( SUCCEEDED( hr ) )
				{					
					this->szeNX`TCY = this->tw肳ꂽTCY𒴂ȂœKȃeNX`TCYԂ( pDevice, this->sz摜TCY );

					IDirect3DTexture9 *pTexture = NULL;

					UINT nf[^ = (UINT)( stream->Length - stream->Position );
					array<Byte>^ rf[^obt@ = gcnew array<Byte>( nf[^ );
					UINT nǂݍ݊f[^ = 0;
					while( nǂݍ݊f[^ < nf[^ )
						nǂݍ݊f[^ += stream->Read( rf[^obt@, nǂݍ݊f[^, nf[^ - nǂݍ݊f[^ );
					pin_ptr<byte> pf[^obt@ = &rf[^obt@[ 0 ];

					tFAILEDȂO( L"Bitmap ̃eNX`̍쐬", 
											hr = ::D3DXCreateTextureFromFileInMemoryEx(
														pDevice,
														pf[^obt@,
														nf[^,
														this->szeNX`TCY.Width,
														this->szeNX`TCY.Height,
														1,
														0,
														(D3DFORMAT) format,
														D3DPOOL_DEFAULT,
														D3DX_FILTER_POINT,
														D3DX_FILTER_NONE,
														colorKey,
														NULL,
														NULL,
														&pTexture ) );
					this->pTexture = pTexture;
				}
			}
			delete stream;
		}
		delete bitmap;
	}
}
