﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;
using FDK.メディア;

namespace SST.ステージ
{
	/// <summary>
	///		固定幅(16×32px)の英数字記号フォントで、文字列を描画する。
	/// </summary>
	class コンソールフォント : FDK.Activity
	{
		public const float 改行幅 = 32f;

		public const float 文字幅 = 14f;    // 画像では文字幅は 16px だが、表示するときはちょっと狭くする。


		public コンソールフォント()
		{
			this.子リスト.Add( this._フォント白32x16 = new 画像( @"$(System)images\コンソールフォント白16x32.png" ) );

			this._文字の矩形領域 = new SharpDX.RectangleF[ 96 ];
			for( int i = 0; i < 96; i++ )
			{
				this._文字の矩形領域[ i ] = new SharpDX.RectangleF(
					x: ( i % 16 ) * 16,
					y: ( i / 16 ) * 32,
					width: 16,
					height: 32 );
			}
		}

		public void 進行描画する( グラフィックデバイス gd, float X, float Y, string 描画する文字列, float 不透明度0to1 = 1f )
		{
			if( null == this._フォント白32x16 )
				return;

			float 左端 = X;

			for( int i = 0; i < 描画する文字列.Length; i++ )
			{
				char ch = 描画する文字列[ i ];

				if( ch == '\n' )
				{
					// (A) 改行
					X = 左端;
					Y += 改行幅;
				}
				else
				{
					int n = this._表記可能文字.LastIndexOf( ch );

					if( 0 <= n )
					{
						// (B) 通常文字
						this._フォント白32x16.描画する( gd, X, Y, 不透明度0to1, 転送元矩形: this._文字の矩形領域[ n ] );
						X += this._文字の矩形領域[ n ].Width;
					}
					else
					{
						// (C) 未対応文字 → 空白扱い
						X += 文字幅;
					}
				}
			}
		}


		private 画像 _フォント白32x16 = null;

		private SharpDX.RectangleF[] _文字の矩形領域 = null;     // [96]

		private readonly string _表記可能文字 = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
	}
}
