package SWBase;

#----------------------------------------
# SWBBS Base
#----------------------------------------

#----------------------------------------
# SWBBS̏
#----------------------------------------
sub InitSW {
	my $cfg = $_[0];

	require "$cfg->{'DIR_LIB'}/const.pl";
	my $sow = &SWConst::InitConst(); # 萔̒`

	$sow->{'cfg'} = $cfg;

	require "$cfg->{'DIR_LIB'}/datetime.pl";
	require "$cfg->{'DIR_LIB'}/string.pl";
	require "$cfg->{'DIR_LIB'}/http.pl";
	require "$cfg->{'DIR_LIB'}/file.pl";
	require "$cfg->{'DIR_LIB'}/lock.pl";
	require "$cfg->{'DIR_LIB'}/debug.pl";
	require "$cfg->{'DIR_LIB'}/user.pl";
	require "$cfg->{'DIR_LIB'}/charsets.pl";

	$sow->{'dt'}     = SWDateTime->new($sow); # tϊp
	$sow->{'debug'} = SWDebug->new($sow);
	$sow->{'lock'} = SWLock->new($sow);
	$sow->{'lock'}->glock(); # t@CbN

	&LoadJcode($sow); # jcode.pl/JCode.pm ̓ǂݍ

	$sow->{'http'}   = SWHttp->new($sow); # HTTP̏
	$sow->{'query'}  = $sow->{'http'}->getquery(); # ͒l
	$sow->{'cookie'} = $sow->{'http'}->getcookie(); # NbL[
	$sow->{'filter'} = &GetCookieFilter($sow); # tB^pNbL[
	$sow->{'user'} = SWUser->new($sow);
	my %setcookie;
	$sow->{'setcookie'} = \%setcookie;

	($sow->{'ua'}, $sow->{'outmode'}) = &CheckUA($sow);

	$sow->{'charsets'} = SWCharsets->new($sow);
	&LoadBasicTextRS($sow);

	return $sow;
}

#----------------------------------------
# tB^pCookief[^̎擾
#----------------------------------------
sub GetCookieFilter {
	my $sow = $_[0];
	my $cookie = $sow->{'cookie'};
	my $i;

	my $pnofilters = &GetCookieValueStr($sow, 'pnofilter');
	my @pnofilter = split(/,/, $pnofilters . ',');
	my $livetypeses = &GetCookieValueStr($sow, 'livetypes');
	my @livetypes = split(/,/, $livetypeses . ',');
	for ($i = 0; $i < 4; $i++) {
		$livetypes[$i] = 0 if (!defined($livetypes[$i]));
	}
	my $typefilters = &GetCookieValueStr($sow, 'typefilter');
	my @typefilter = split(/,/, $typefilters . ',');
	for ($i = 0; $i < 4; $i++) {
		$typefilter[$i] = 0 if (!defined($typefilter[$i]));
	}

	my %filter = (
		pnofilter => \@pnofilter,
		livetypes => \@livetypes,
		typefilter => \@typefilter,
		layoutfilter => &GetCookieValueStr($sow, 'layoutfilter'),
		fixfilter => &GetCookieValueStr($sow, 'fixfilter'),
		mestypes => &GetCookieValueStr($sow, 'mestypes'),
		lumpfilter => &GetCookieValueStr($sow, 'lumpfilter'),
	);
	return \%filter;
}

#----------------------------------------
# ^NbL[̒l𓾂
#----------------------------------------
sub GetCookieValueStr {
	my $data = '';
	$data = $_[0]->{'cookie'}->{$_[1]} if (defined($_[0]->{'cookie'}->{$_[1]}));
	return $data;
}

#----------------------------------------
# [
#----------------------------------------
sub CheckUA {
	my $sow = $_[0];

	# F
	my $ua = '';
	my $envagent = $ENV{'HTTP_USER_AGENT'};
	$envagent = 'J-PHONE5.0' if (index($envagent, 'J-EMULATOR') == 0);
	my $is_upbrowser = index($envagent, 'UP.Browser');
	$ua = 'ihtml' if (index($envagent, 'DoCoMo') == 0);
	if (index($envagent, 'SoftBank') == 0) {
		$ua = 'sb';
	} elsif ((index($envagent, 'J-PHONE5.') == 0) || (index($envagent, 'Vodafone') == 0)) {
		$ua = 'vodax'
	} elsif (index($envagent, 'J-PHONE') == 0) {
		$ua = 'voda'
	}

	# UP.Browsern
	if ($is_upbrowser >= 0) {
		$envagent =~ /UP\.Browser\/(\d*)\./;
		if ($1 > 5) {
			$ua = 'au';
		} else {
			$ua = 'hdml';
		}
	}

	# uaF
	my @ualist = ('ihtml', 'hdml', 'au', 'voda', 'vodax', 'xhtml', 'html401', 'rss');
	foreach (@ualist) {
		$ua = $_ if ($sow->{'query'}->{'ua'} eq $_);
	}
	$ua = 'ihtml' if ($sow->{'query'}->{'ua'} eq 'mb');
	$ua = $sow->{'cfg'}->{'DEFAULT_UA'} if ($ua eq '');

	my $outmode = 'pc';
	$outmode = 'mb' if ($ua eq 'ihtml');
	$outmode = 'mb' if ($ua eq 'hdml');
	$outmode = 'mb' if ($ua eq 'au');
	$outmode = 'mb' if ($ua eq 'sb');
	$outmode = 'mb' if ($ua eq 'vodax');
	$outmode = 'mb' if ($ua eq 'voda');
	$outmode = 'rss' if ($ua eq 'rss');

	return ($ua, $outmode);
}

#----------------------------------------
# URLGR[h
#----------------------------------------
sub EncodeURL {
	my $url = $_[0];
	$url =~ s/(\W)/sprintf("%%%02X", ord($1))/eg;
	return $url;
}

#----------------------------------------
# {񃊃\[X̓ǂݍ
#----------------------------------------
sub LoadBasicTextRS {
	my $sow = $_[0];
	require "$sow->{'cfg'}->{'DIR_RS'}/trs_basic.pl";
	$sow->{'basictrs'} = &SWBasicTextRS::SWBasicTextRS($sow);

	return;
}

#----------------------------------------
# 񃊃\[X̓ǂݍ
#----------------------------------------
sub LoadTextRS {
	my ($sow, $vil) = @_;
	my $trsid = $vil->{'trsid'};

	my $fname = "$sow->{'cfg'}->{'DIR_RS'}/trs_$trsid.pl";
	$sow->{'debug'}->raise($sow->{'APLOG_WARNING'}, "񃊃\\[X $trsid ܂B", "trsid not found.[$trsid]") if (!(-e $fname));

	require "$fname";
	my $sub = '::SWTextRS_' . $trsid . '::GetTextRS';
	my $textrs = &$sub($sow);

	$sow->{'trsid'} = $trsid;
	$sow->{'textrs'} = $textrs;
}

#----------------------------------------
# \[X̓ǂݍ
#----------------------------------------
sub LoadVilRS {
	my ($sow, $vil) = @_;

	# \[X̓ǂݍ
	my $csidlist = $sow->{'csidlist'};
	my @keys = keys(%$csidlist);
	foreach (@keys) {
		$sow->{'charsets'}->loadchrrs($_);
	}
	&LoadTextRS($sow, $vil);
}

#----------------------------------------
# Mpl̐
#----------------------------------------
sub GetHiddenValues {
	my ($sow, $reqvals, $tab) = @_;
	my $net = $sow->{'html'}->{'net'};

	my $hidden = '';
	my @keys = keys(%$reqvals);
	foreach (@keys) {
		next if (!defined($reqvals->{$_}));
		next if ($reqvals->{$_} eq '');
		$hidden .= "\n$tab<input type=\"hidden\" name=\"$_\" value=\"$reqvals->{$_}\"$net>";
	}
	return $hidden;
}

#----------------------------------------
# Npl̐
#----------------------------------------
sub GetLinkValues {
	my ($sow, $reqvals) = @_;
	my $linkvalues = '';
	my $amp = '&';
	$amp = $sow->{'html'}->{'amp'} if (defined($sow->{'html'}->{'amp'}));

	my ($pkg, $fname, $line) = caller;

	my %shortquery = (
		cmd   => 'c',
		logid => 'l',
		mode  => 'm',
		order => 'o',
		pwd   => 'p',
		row   => 'r',
		turn  => 't',
		uid   => 'u',
		vid   => 'v',
	);

	my @keys = keys(%$reqvals);
	foreach (@keys) {
		next if (!defined($reqvals->{$_}));
		next if ($reqvals->{$_} eq '');
		$linkvalues .= $amp if ($linkvalues ne '');
		my $key = $_;
		$key = $shortquery{$_} if ((defined($shortquery{$_})) && ($sow->{'outmode'} eq 'mb'));
		my $data = &EncodeURL($reqvals->{$_});
		$linkvalues .= "$key=$data";
	}
	return $linkvalues;
}

#----------------------------------------
# pXg擾
#----------------------------------------
sub GetRequestValues {
	my ($sow, $reqkeys) = @_;
	my $query = $sow->{'query'};

	if ((defined($query->{'row'})) && ($query->{'row'} eq 'all')) {
		$query->{'row'} = '';
		$query->{'rowall'} = 'on'; # pȂ
	}

	my @basereqkeys;
	if ($query->{'cmd'} eq 'rss') {
		@basereqkeys = ('cmd', 'vid', 'row');
	} elsif (defined($query->{'vid'})) {
		@basereqkeys = ('ua', 'uid', 'pwd', 'order', 'row', 'css', 'vid', 'turn', 'mode', 'pno');
	} else {
		@basereqkeys = ('ua', 'uid', 'pwd', 'order', 'row', 'css');
	}
	push (@$reqkeys, @basereqkeys);

	my %reqvals = ();
	foreach (@$reqkeys) {
		$reqvals{$_} = $sow->{'query'}->{$_} if ((defined($sow->{'query'}->{$_})) && ($sow->{'query'}->{$_} ne ''));
	}
	return \%reqvals;
}

#----------------------------------------
# ʂ̎擾
#----------------------------------------
sub GetSayPoint {
	my ($sow, $vil, $text) = @_;
	my $saycnt = $sow->{'cfg'}->{'COUNTS_SAY'}->{$vil->{'saycnttype'}};

	my $point;
	if ($saycnt->{'COUNT_TYPE'} eq 'count') {
		$point = 1;
	} elsif ($saycnt->{'COUNT_TYPE'} eq 'point') {
		$text =~ s/<br( \/)?>/\n/ig;
		&ExtractChrRef(\$text);
		$point = &GetSayPointJuna($text);
	} else {
		$text =~ s/<br( \/)?>/\n/ig;
		&ExtractChrRef(\$text);
		$point = &GetSayPointJunaAlpha2($text);
	}

	return $point;
}

#----------------------------------------
# ʂ̎擾ilTRj
# 50oCg܂20ptAȉ14oCgƂ1ptB
# s͈SoCgi<br>ƂČvZjB
#----------------------------------------
sub GetSayPointJuna {
	my $text = $_[0];

	my $count = length($text);
	my $point = 20;
	$count -= 50;
	$count = 0 if ($count < 0);
	$point += int($count / 14);

	return $point;
}

#----------------------------------------
# ʂ̎擾ilTR⃿Q`Pj
# 60oCg܂25ptAȉ4oCgƂ1ptB
# s͈SoCgi<br>ƂČvZjB
#----------------------------------------
sub GetSayPointJunaAlpha2 {
	my $text = $_[0];

	my $count = length($text);
	my $point = 25;
	$count -= 60;
	$count = 0 if ($count < 0);
	$point += int($count / 4);

	return $point;
}

#----------------------------------------
# Jcode.pm/jcode.pl ̓ǂݍ
#----------------------------------------
sub LoadJcode {
	my $sow = $_[0];
	$sow->{'jcode'} = '';

	eval 'use Jcode;';
	if ($@ eq '') {
		$sow->{'jcode'} = 'pm';
	} else {
		eval "require \"$sow->{'cfg'}->{'FILE_JCODE'}\";";
		if ($@ eq '') {
			$sow->{'jcode'} = 'pl';
		}
	}

	return;
}

#----------------------------------------
# Jcode.pm/jcode.pl ŕR[hZbgϊ
#----------------------------------------
sub JcodeConvert {
	my $sow = $_[0];
	if ($sow->{'jcode'} eq 'pm') {
		&Jcode::convert($_[1], $_[2], $_[3]);
	} elsif ($sow->{'jcode'} eq 'pl') {
		&jcode::convert($_[1], $_[2], $_[3]);
	}
	return;
}

#----------------------------------------
# \peLXg̎擾
#----------------------------------------
sub GetSayCountText {
	my ($sow, $vil) = @_;
	my $saycnt = $sow->{'cfg'}->{'COUNTS_SAY'}->{$vil->{'saycnttype'}};
	my $unit = $sow->{'basictrs'}->{'SAYTEXT'}->{$sow->{'cfg'}->{'COUNTS_SAY'}->{$vil->{'saycnttype'}}->{'COUNT_TYPE'}}->{'UNIT_SAY'};
	my $curpl = $sow->{'curpl'};

	if ($vil->checkentried() < 0) {
		# Gg[
		return '';
	}

	my $say = $curpl->{'say'};
	my $maxsay = $saycnt->{'MAX_SAY'};
	if ($vil->{'turn'} == 0) {
		# v[Op
		$say = $curpl->{'psay'};
		$maxsay = $saycnt->{'MAX_PSAY'};
	}
	if ($curpl->{'live'} ne 'live') {
		# 扺
		$say = $curpl->{'gsay'};
		$maxsay = $saycnt->{'MAX_GSAY'};
	}
	if ($vil->isepilogue() > 0) {
		# Gs[Op
		$say = $curpl->{'esay'};
		$maxsay = $saycnt->{'MAX_ESAY'};
	}

	my $saytext = " $say$unit";

	return $saytext;
}

#----------------------------------------
# ANZXĂvC[̃f[^𓾂
# ĐlǗlΉ
#----------------------------------------
sub GetCurrentPl {
	my ($sow, $vil) = @_;
	my $query = $sow->{'query'};

	require "$sow->{'cfg'}->{'DIR_LIB'}/file_player.pl";
	my $plsingle = SWPlayer->new($sow);
	$plsingle->createpl($sow->{'uid'});
	$plsingle->{'jobname'}   = '';
	$plsingle->{'pno'}       = -1;
	$plsingle->{'live'}      = 'live';
	$plsingle->{'entrieddt'} = 0;
	$plsingle->{'emulated'}  = 0;

	my $curpl = $sow->{'curpl'};
	if (defined($curpl->{'uid'})) {
		my @keys = keys(%$curpl);
		foreach (@keys) {
			$plsingle->{$_} = $curpl->{$_};
		}
	}

	my $csidlist = $sow->{'csidlist'};
	my @keys = keys(%$csidlist);
	if ($vil->checkentried() < 0) {
		$plsingle->{'csid'}      = $keys[0];
		$plsingle->{'role'}      = $sow->{'ROLEID_UNDEF'};
		$plsingle->{'emulated'}  = 1;
	}

	if (($query->{'admin'} ne '') && ($sow->{'uid'} eq $sow->{'cfg'}->{'USERID_ADMIN'})) {
		# Ǘl[h
		$plsingle->{'cid'}       = $sow->{'cfg'}->{'CID_ADMIN'};
		$plsingle->{'csid'}      = $keys[0];
		$plsingle->{'emulated'}  = 1;
	} elsif (($query->{'maker'} ne '') && ($sow->{'uid'} eq $vil->{'makeruid'})) {
		# Đl[h
		$plsingle->{'cid'}       = $sow->{'cfg'}->{'CID_MAKER'};
		$plsingle->{'csid'}      = $keys[0];
		$plsingle->{'emulated'}  = 1;
	}

	if ($plsingle->{'emulated'} > 0) {
		return $plsingle;
	} else {
		return $curpl;
	}
}

#----------------------------------------
# R~bg󋵂IDԍ𓾂
#----------------------------------------
sub GetTotalCommitID {
	my ($sow, $vil) = @_;

	my $getlivepllist = $vil->getlivepllist();
	my $cntlivepl = @$getlivepllist;
	my $commitedpl = $vil->getcommitedpl();
	my $totalcommit = 0;
	$totalcommit = 1 if ($commitedpl > $cntlivepl / 3);
	$totalcommit = 2 if ($commitedpl > $cntlivepl * 2 / 3);
	$totalcommit = 3 if ($commitedpl == $cntlivepl);

	return $totalcommit;
}

#----------------------------------------
# UAOpera̎o[Wԍ𓾂
#----------------------------------------
sub GetOperaVersion {
	my $result = -1;
	if ($ENV{'HTTP_USER_AGENT'} =~ /Opera[ \/]\d+.\d+/) {
		my $operaid = $&;
		$operaid =~ /\d+.\d+/;
		$result = $&;
	}

	return $result;
}

#----------------------------------------
# 딚Ӄ`FbNKvȖEǂ
#----------------------------------------
sub CheckWriteSafetyRole {
	my ($sow, $vil) = @_;

	my $curpl = &SWBase::GetCurrentPl($sow, $vil);
	my $enablecheck = 0;
	$enablecheck = 1 if ($curpl->iswolf() > 0); # lT/T/qT
	$enablecheck = 1 if ($curpl->{'role'} eq $sow->{'ROLEID_CPOSSESS'}); # bl
	$enablecheck = 1 if ($curpl->{'role'} eq $sow->{'ROLEID_SYMPATHY'}); # 
	$enablecheck = 1 if ($curpl->{'role'} eq $sow->{'ROLEID_WEREBAT'}); # REl

	return $enablecheck;
}

#----------------------------------------
# QƂ̓WJ
#----------------------------------------
sub ExtractChrRef {
	my $text = shift;

	$$text =~ s/&lt\;/</g;
	$$text =~ s/&gt\;/>/g;
	$$text =~ s/&quot\;/\"/g;
	$$text =~ s/&amp\;/&/g;
}

#----------------------------------------
# QƂւ̃GXP[v
#----------------------------------------
sub EscapeChrRef {
	my $text = shift;

	$$text =~ s/&/&amp\;/g;
	$$text =~ s/&amp\;(#\d{3,}\;)/&$1/ig; # P`Q̕QƂ͔ÔߏRi蔲j
	$$text =~ s/&(#0*127;)/&amp\;$1/g; # 127͐R[hȂ̂ňꉞR
#	$$text =~ s/&\#0*160\;/ /g;

	$$text =~ s/</&lt\;/g;
	$$text =~ s/>/&gt\;/g;
	$$text =~ s/\"/&quot\;/g;
}

#----------------------------------------
# o
#----------------------------------------
sub ExitVillage {
	my ($sow, $vil, $exitpl, $logfile) = @_;

	$exitpl->{'delete'} = 1;
	my $chrname = $exitpl->getchrname();
	my $exitmes = $sow->{'textrs'}->{'EXITMES'};
	$exitmes =~ s/_NAME_/$chrname/g;
	$logfile->writeinfo('', $sow->{'MESTYPE_INFONOM'}, $exitmes);

	$sow->{'debug'}->writeaplog($sow->{'APLOG_POSTED'}, "Exit. [$exitpl->{'uid'}]");
}

1;