package SWFileVIndex;

#----------------------------------------
# ꗗf[^t@C
#----------------------------------------

#----------------------------------------
# ꗗf[^x
#----------------------------------------
sub GetVIndexDataLabel {
	my @datalabel = (
		'vid',
		'vname',
		'vcomment',
		'makeruid',
		'updhour',
		'updminite',
		'vstatus',
		'createdt',
	);
	return @datalabel;
}

#----------------------------------------
# RXgN^
#----------------------------------------
sub new {
	my ($class, $sow) = @_;
	my $self = {
		sow   => $sow,
	};

	return bless($self, $class);
}

#----------------------------------------
# ꗗf[^t@C̍XV𓾂
#----------------------------------------
sub getupdatedt {
	my $self = shift;
	my $sow = $self->{'sow'};
	my $filename = "$sow->{'cfg'}->{'FILE_VINDEX'}";

	return (stat($filename))[9];
}

#----------------------------------------
# ꗗf[^t@CJ
#----------------------------------------
sub openvindex {
	my $self = shift;
	my $sow = $self->{'sow'};
	my $fh = \*VINDEX;
	my $filename = "$sow->{'cfg'}->{'FILE_VINDEX'}";

	# t@CJ
	my $file = SWFile->new($self->{'sow'}, 'vindex', $fh, $filename, $self);
	if (!(-e $filename)) {
		$file->openfile('>', 'ꗗ', ''); # VK쐬
	}
	$file->openfile(
		'+<',
		'ꗗ',
		'',
	);
	$self->{'file'} = $file;

	seek($fh, 0, 0);
	my @data = <$fh>;

	# f[^x̓ǂݍ
	@data = ('<>') if (@data == 0);
	my $datalabel = shift(@data);
	my @datalabel = split(/<>/, $datalabel);
	@datalabel = $self->GetVIndexDataLabel() if (!defined($datalabel[0]));

	# f[^̓ǂݍ
	my $i = 0;
	my $datacnt = @data;
	my @vilist;
	my %vi;
	while ($i < $datacnt) {
		my %vindexsingle;
		chomp($data[$i]);
		$vindexsingle{'delete'} = 0; # 폜p
		@vindexsingle{@datalabel} = split(/<>/, $data[$i]);

		# zɃZbg
		$vilist[$i] = \%vindexsingle;
		$vi{$vindexsingle{'vid'}} = \%vindexsingle;
		$i++;
	}
	$self->{'vilist'} = \@vilist;
	$self->{'vi'}     = \%vi;

	return \%vindex;
}

#----------------------------------------
# ꗗf[^֒ǉ
#----------------------------------------
sub addvindex {
	my ($self, $vil) = @_;

	my %vindexsingle = (
		vid       => $vil->{'vid'},
		vname     => $vil->{'vname'},
		vcomment  => $vil->{'vcomment'},
		makeruid  => $vil->{'makeruid'},
		createdt  => $self->{'sow'}->{'time'},
		updhour   => $vil->{'updhour'},
		updminite => $vil->{'updminite'},
		vstatus   => $self->{'sow'}->{'VSTATUSID_PRO'},
		delete    => 0,
	);

	my $vilist = $self->{'vilist'};
	unshift(@$vilist, \%vindexsingle);
	return;
}

#----------------------------------------
# ꗗf[^̔z𓾂
#----------------------------------------
sub getvilist {
	my $self = shift;
	return $self->{'vilist'};
}

#----------------------------------------
# ݕW^is^Gs[Ȏ̐擾
#----------------------------------------
sub getactivevcnt {
	my $self = shift;
	my $vcnt = 0;

	foreach (@{$self->{'vilist'}}) {
		$vcnt++ if (($_->{'vstatus'} != $self->{'sow'}->{'VSTATUSID_END'}) && ($_->{'vstatus'} != $self->{'sow'}->{'VSTATUSID_SCRAPEND'}));
	}

	return $vcnt;
}

#----------------------------------------
# vidŎw肵ꗗf[^𓾂
#----------------------------------------
sub getvindex {
	my ($self, $vid) = @_;
	return $self->{'vi'}->{$vid};
}

#----------------------------------------
# ꗗf[^̏
#----------------------------------------
sub writevindex {
	my $self = shift;

	my $fh = $self->{'file'}->{'filehandle'};
	truncate($fh, 0);
	seek($fh, 0, 0);

	my @datalabel = $self->GetVIndexDataLabel();

	print $fh join("<>", @datalabel). "<>\n";

	my $vilist = $self->{'vilist'};
	my $vindexsingle = '';
	foreach $vindexsingle (@$vilist) {
		next if ($vindexsingle->{'delete'} > 0); # 폜
		print $fh join("<>", map{$vindexsingle->{$_}}@datalabel). "<>\n";
	}
}

#----------------------------------------
# ꗗXV
#----------------------------------------
sub updatevindex {
	my ($self, $vil, $vstatus) = @_;

	my $vindexsingle = $self->getvindex($vil->{'vid'});
	$vindexsingle->{'vname'}     = $vil->{'vname'};
	$vindexsingle->{'vcomment'}  = $vil->{'vcomment'};
	$vindexsingle->{'updhour'}   = $vil->{'updhour'};
	$vindexsingle->{'updminite'} = $vil->{'updminite'};
	$vindexsingle->{'vstatus'}   = $vstatus;

	$self->writevindex();
	return;
}

#----------------------------------------
# ꗗf[^t@C
#----------------------------------------
sub closevindex {
	my $self = shift;
	$self->{'file'}->closefile();
	return;
}

1;