package SWBoaLogCount;

#----------------------------------------
# SW-Boa Log Count Driver
#----------------------------------------

#----------------------------------------
# RXgN^
#----------------------------------------
sub new {
	my ($class, $sow, $vil, $turn, $mode) = @_;
	require "$sow->{'cfg'}->{'DIR_LIB'}/file_hash.pl";

	my $self = {
		sow      => $sow,
		vil      => $vil,
		turn     => $turn,
		version  => ' 2.0',
		startpos => 0,
	};
	bless($self, $class);

	# OJEgt@C̐VK쐬^J
	my $fnamelogcnt = $self->getfnamelogcnt();
	my @logcntdatalabel = $self->getlogcntdatalabel();
	$self->{'file'} = SWFileHash->new(
		$sow,
		$fnamelogcnt,
		\*LOGCNT,
		'logcnt',
		\@logcntdatalabel,
		'OJEgf[^',
		"[vid=$self->{'vil'}->{'vid'}]",
		$mode,
		$self->{'version'},
	);
	$self->{'file'}->read() if ($mode == 0);

	return $self;
}

#----------------------------------------
# OCfbNXf[^t@C̎擾
#----------------------------------------
sub getfnamelogcnt {
	my $self = shift;
	my $datafile = sprintf(
		"%s/%04d_%s",
		$self->{'sow'}->{'cfg'}->{'DIR_VIL'},
		$self->{'vil'}->{'vid'},
		$self->{'sow'}->{'cfg'}->{'FILE_LOGCNT'},
	);
	return $datafile;
}

#----------------------------------------
# OJEgf[^x
#----------------------------------------
sub getlogcntdatalabel {
	my $self = shift;
	my @datalabel;

	# Version 2.0
	@datalabel = (
		'countundef',
		'countinfo',
		'countinfosp',
		'countque',
		'countsay',
		'countthink',
		'countwolf',
		'countgrave',
		'countmaker',
		'countadmin',
		'countsympathy',
		'countwerebat',
		'countsayact',
	);

	return @datalabel;		
}

1;