﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Somali
{
    public partial class PreferencesForm : Form
    {
        public PreferencesForm()
        {
            InitializeComponent();
        }

        #region 下部ボタン
            private void buttonOK_Click(object sender, EventArgs e)
            {
                this.Close();
            }

            private void buttonCancel_Click(object sender, EventArgs e)
            {
                this.Close();
            }

            private void buttonApply_Click(object sender, EventArgs e)
            {
                this.buttonApply.Enabled = false;
            }
        #endregion

        private void PreferencesForm_Load(object sender, EventArgs e)
        {
            this.InitializeTreeView();
        }

        /// <summary>
        /// 設定項目ツリーの初期化
        /// </summary>
        private void InitializeTreeView()
        {
            this.treePreferences.Nodes.Clear();

            TreeNode treeNodeEditor = new TreeNode("表示");
            TreeNode treeNodeFont = new TreeNode("フォント");
            TreeNode[] treeNodeSubFolder = { treeNodeEditor, treeNodeFont };

            // 下位階層に対してまとめて項目（ノード）を追加
            TreeNode treeNodeEnv =
              new TreeNode( "全般", treeNodeSubFolder );

            TreeNode treeNodeFileType = new TreeNode("タイプ別設定");
            TreeNode[] treeNodeRoot = { treeNodeEnv, treeNodeFileType };

            // 最上位階層に対してまとめて項目（ノード）を追加
            this.treePreferences.Nodes.AddRange(treeNodeRoot);

            this.treePreferences.TopNode.Expand();
        }


    }
}
