﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Somali.Base;
using Somali.Models;

namespace Somali
{
    public partial class ExplorerForm : WeifenLuo.WinFormsUI.Docking.DockContent, IActionColleague
    {
        public enum NodeIcon : int
        {
            FolderClose = 0,
            FolderOpen,
            FileError,
            FilePlain,
        }

        private IActionMediator _mediator;
        public void SetMediator( IActionMediator mediator )
        {
            this._mediator = mediator;
        }

        #region コンストラクタ
        public ExplorerForm()
        {
            InitializeComponent();
        }

        public ExplorerForm( TreeNode root )
        {
            InitializeComponent();

            BindExplorerTree( root );
        }
        #endregion

        public WeifenLuo.WinFormsUI.Docking.DockState DefaultDockState
        {
            get { return WeifenLuo.WinFormsUI.Docking.DockState.DockLeft; }
        }
        public void Reflesh()
        {
            this.treeExplorer.Refresh();
        }
        public void Bind( Model model )
        {
            ExplorerModel exModel;
            if ( model.TryGetModelImpl( out exModel ) )
            {
                BindExplorerTree( exModel.ExplorerTree );
            }
        }
        public void Initialize() { }

        private void BindExplorerTree( TreeNode root )
        {
            if ( root != null )
            {
                this.treeExplorer.BeginUpdate();

                try
                {
                    this.treeExplorer.Nodes.Clear();
                    this.treeExplorer.Nodes.Add( root );
                    //this.treeExplorer.ExpandAll();
                }
                finally
                {
                    this.treeExplorer.EndUpdate();
                }
            }
        }

        private void treeExplorer_NodeMouseDoubleClick( object sender, TreeNodeMouseClickEventArgs e )
        {

        }

        private void treeExplorer_BeforeExpand( object sender, TreeViewCancelEventArgs e )
        {
            this._mediator.DispatchAction( new SomaliActionArgs( SomaliAction.ExpandExplorerNode, e.Node ) );
        }

    }
}
