﻿using System;
using System.Windows.Forms;

namespace Somali.Base
{
    /// <summary>
    /// WindowStateChanging イベントのデータを提供します。
    /// </summary>
    public class WindowStateChangingEventArgs : System.ComponentModel.CancelEventArgs
    {
        public WindowStateChangingEventArgs( FormWindowState windowState )
        {
            this._WindowState = windowState;
        }

        private FormWindowState _WindowState;
        /// <summary>
        /// 要求されたウィンドウ状態を取得します。
        /// </summary>
        public FormWindowState WindowState
        {
            get { return _WindowState; }
        }
    }
}
