﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Somali.Base
{
    public enum SomaliAction
    {
        Exit,
        ShowExplorer,
        ShowOutlineAnalizer,
        OpenSolution,
        OpenDir,
        OpenFile,
        JumpLine,
        ExpandExplorerNode,
        ApplyPreferences,

    }

    public class SomaliActionArgs : EventArgs
    {
        private SomaliAction _actionID;
        public SomaliAction ActionID
        {
            get { return this._actionID; }
        }

        private object _arg;
        public object Arg
        {
            get { return this._arg; }
        }

        private Type _argType;
        public Type ArgType
        {
            get { return this._argType; }
        }

        private string _path;
        public string Path
        {
            get { return this._path; }
        }

        private ulong _lineNum;
        public ulong LineNumber
        {
            get { return this._lineNum; }
        }

        public SomaliActionArgs( SomaliAction actionID )
            : this( actionID, null ) { }

        public SomaliActionArgs( SomaliAction actionID, object arg )
        {
            this._actionID = actionID;
            this._arg = arg;
            this._argType = (arg == null ? null : arg.GetType());

            this._path = String.Empty;
            this._lineNum = 0UL;

            switch ( actionID )
            {
                case SomaliAction.OpenSolution:
                case SomaliAction.OpenDir:
                case SomaliAction.OpenFile:
                    this._path = arg.ToString();
                    break;
                case SomaliAction.JumpLine:
                    UInt64.TryParse( arg.ToString(), out this._lineNum );
                    break;
            }
        }

    }
}
