﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Linq;
using System.Xml;

namespace XMLEditorMini.Logic
{
    sealed class File
    {
        /// <summary>
        /// Open/Saveに使われるFileDialogの初期ディレクトリを取得または設定します。
        /// </summary>
        public string InitialDirectory
        {
            set;
            get;
        }

        // Singleton Class
        private static Logic.File _instance = new Logic.File();
        private File()
        {
            InitialDirectory = Environment.GetFolderPath( Environment.SpecialFolder.Desktop );
        }

        public static Logic.File GetInstance()
        {
            return _instance;
        }

        public void OpenXmlFile( ref string filePath, TreeView tree )
        {
            XMLToTreeView xioProvider = new XMLToTreeView();
            OpenFileDialog dlgFile = new OpenFileDialog();
            dlgFile.InitialDirectory = InitialDirectory;
            dlgFile.Filter = "XMLドキュメント(*.xml)|*.xml";

            // get file path
            if ( dlgFile.ShowDialog() == DialogResult.OK )
            {
                filePath = dlgFile.FileName;
                InitialDirectory = Path.GetDirectoryName( filePath );

                tree.BeginUpdate();

                try
                {
                    //XMLファイルの読み出し
                    TreeNode root = xioProvider.SetXmlToTreeView( filePath );
                    tree.Nodes.Clear();
                    tree.Nodes.Add( root );
                    tree.ExpandAll();
                }
                finally
                {
                    tree.EndUpdate();
                }
            }

        }

    }
}
