﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Xml.Linq;
using System.Xml;
using System.Text;
using System.Windows.Forms;
using System.IO;

using Somali.XML;

namespace XMLEditorMini
{
    public partial class XMLEditorForm : Form
    {
        /// <summary>
        /// 開いているファイルパス
        /// </summary>
        private string _filePath;

        /// <summary>
        /// OpenDialogの初期ディレクトリ
        /// </summary>
        private string initialDirectory;


        private Logic.File logic = Logic.File.GetInstance();
        
        public XMLEditorForm()
        {
            InitializeComponent();

            initialDirectory = Environment.GetFolderPath( Environment.SpecialFolder.Desktop );
        }

        private void openToolStripMenuItem_Click( object sender, EventArgs e )
        {
            //XMLファイルの読み出し
            try
            {
                Logic.File.GetInstance().OpenXmlFile( ref _filePath, this._XMLTreeView );
            }
            catch ( XmlException ex )
            {
                MessageBox.Show( ex.Message );
            }
        }

        private void exitToolStripMenuItem_Click( object sender, EventArgs e )
        {
            this.Close();
        }

        private void _XMLTreeView_NodeMouseDoubleClick( object sender, TreeNodeMouseClickEventArgs e )
        {
            e.Node.BeginEdit();
        }

        private void saveToolStripMenuItem_Click( object sender, EventArgs e )
        {

        }
    }
}
