# -*- coding: utf-8 -*-
class AdminController < ApplicationController
  before_filter :admin_authorize

  def index
    @users = User.find(:all, order: 'is_active DESC')
    @projects = Project.find(:all, order: "created_by_user_id, is_active DESC")
    @default_config = DefaultConfig.all.first
  end

  def edit
    if params[:edit_user_id]
      @edit_user = User.find(params[:edit_user_id])
    elsif params[:edit_project_id]
      @edit_project = Project.find(params[:edit_project_id])
    end
  end

  def update
    if params[:project]
      edit_project = Project.find(params[:id])

      if edit_project.update_attributes(params[:project])
        redirect_to admin_index_url
      else
        render action: "edit"
      end

    elsif params[:user]
        edit_user = User.find(params[:id])

      if params[:user][:admins_password]
        # ユーザのパスワード変更を行う
        is_changed, message =
          change_password(edit_user, @user,
                          params[:user][:admins_password],
                          params[:user][:new_password],
                          params[:user][:new_password_confirm])

        if is_changed
          redirect_to edit_admin_url(id: edit_user.id, edit_user_id: edit_user.id), notice: message
        else
          redirect_to edit_admin_url(id: edit_user.id, edit_user_id: edit_user.id), alert: message
        end
        return
      end

      edit_user.is_admin =
        params[:user][:is_admin].to_s == "true" if params[:user][:is_admin]

      respond_to do |format|
        if edit_user.update_attributes(params[:user])
          format.html { redirect_to admin_index_url }
          format.json { head :ok }
        else
          format.html { render action: "edit" }
          format.json { render json: edit_user.errors,
            status: :unprocessable_entity }
        end
      end
    end
  end
end
