package demo.soba;

import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.DataDependence;
import soba.core.method.DataFlowEdge;
import soba.util.files.ClasspathUtil;
import soba.util.graph.DirectedGraph;
import demo.util.MemoryInfo;

public class ControlAndDataDependencePerformance {

	public static void main(String[] args) {
		long start = System.currentTimeMillis();
		
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		for (ClassInfo c: program.getClasses()) {
			for (MethodInfo m: c.getMethods()) {
				DataDependence dd = m.getDataDependence();
				for (DataFlowEdge e: dd.getEdges()) {
//					System.out.println(e.toString());
				}
				DirectedGraph cd = m.getControlDependence();
				for (int src = 0; src < cd.getVertexCount(); src++) {
					for (int dst: cd.getEdges(src)) {
//						System.out.println(src + " -> " + dst);
					}
				}
			}
		}
		
		long end = System.currentTimeMillis();
		
		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
