package demo.wala;

import java.util.Iterator;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.FileProvider;

import demo.util.DemoUtil;
import demo.util.MemoryInfo;

public class ClassHierarchyPerformance {

	public static void main(String[] args) throws Exception {
		long start = System.currentTimeMillis();

		AnalysisScope scope = AnalysisScopeReader.makeJavaBinaryAnalysisScope(args[0], (new FileProvider()).getFile(DemoUtil.REGRESSION_EXCLUSIONS));
		ClassHierarchy cha = ClassHierarchy.make(scope);
		Iterable<Entrypoint> entrypoints = Util.makeMainEntrypoints(scope, cha);
		AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
		CallGraphBuilder builder = Util.makeZeroCFABuilder(options, new AnalysisCache(), cha, scope);
		CallGraph cg = builder.makeCallGraph(options, null);
		for (CGNode caller: cg) {
			for (Iterator<CGNode> callees = cg.getSuccNodes(caller); callees.hasNext();) {
				CGNode callee = callees.next();
				IMethod callerMethod = caller.getMethod();
				IMethod calleeMethod = callee.getMethod();
//				System.out.println(callerMethod.toString() + " -> " + calleeMethod.toString());
			}
		}
		
		long end = System.currentTimeMillis();

		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
