//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;
import java.util.Date;
    /**
     * YouTube検索の結果要素を格納する
     */
    public class YouTubeElement implements IVideoElement, Serializable
    {
        // コンストラクタ

        /**
         * コンストラクタ
         * @param author 
         * @param id 
         * @param title 
         * @param length_seconds 
         * @param rating_avg 
         * @param rating_count 
         * @param description 
         * @param view_count 
         * @param date 
         * @param comment_count 
         * @param tags 
         * @param uri 
         * @param thumbnail_url 
         */
        public YouTubeElement(String author, String id, String title, int length_seconds,
            double rating_avg, int rating_count, String description, int view_count, Date date, int comment_count,
            String tags, String uri, String thumbnail_url)
        {
            this.author = author; this.id = id; this.title = title; this.length_seconds = length_seconds;
            this.rating_avg = rating_avg; this.rating_count = rating_count; this.description = description;
            this.view_count = view_count; this.date = date; this.comment_count = comment_count; this.tags = tags;
            this.uri = uri; this.thumbnail_url = thumbnail_url;
        }



        // privateフィールド

        String author;
        String id;
        String title;
        int length_seconds;
        double rating_avg;
        int rating_count;
        String description;
        int view_count;
        Date date;
        int comment_count;
        String tags;
        String uri;
        String thumbnail_url;



        // プロパティ

        /**
         * ビデオのタイトル
         */
        public String getTitle()
        {
        	return this.title;
        }

        /**
         * ビデオの作者
         */
        public String getAuthor()
        {
        	return this.author;
        }

        /**
         * ビデオID
         */
        public String getID()
        {
        	return this.id;
        }

        /**
         * ビデオの説明文
         */
        public String getDescription()
        {
        	return this.description;
        }

        /**
         * ビデオのページのURL
         */
        public String getURL()
        {
        	return this.uri;
        }

        /**
         * ビデオのサムネイルのURL
         */
        public String getThumbnailURL()
        {
        	return this.thumbnail_url;
        }

        /**
         * ビデオにつけられれたタグ
         */
        public String getTags()
        {
        	return this.tags;
        }

        /**
         * ビデオにつけられたコメントの数
         */
        public int getCommentCount()
        {
        	return this.comment_count;
        }

        /**
         * ビデオの長さ（秒）
         */
        public int getLengthSeconds()
        {
        	return this.length_seconds;
        }

        /**
         * 評価された数
         */
        public int getRatingCount()
        {
                return this.rating_count;
        }

        /**
         * ビデオが閲覧された回数
         */
        public int getViewCount()
        {
        	return this.view_count;
        }

        /**
         * 評価の平均値
         */
        public double getRatingAvg()
        {
        	return this.rating_avg;
        }

        /**
         * 投稿日時
         */
        public Date getDate()
        {
        	return this.date;
        }






//        //#region ISearchResultElement メンバ
//
//        String ISearchResultElement.URL
//        {
//            get
//            {
//                return this.uri;
//            }
//        }
//
//        String ISearchResultElement.Title
//        {
//            get
//            {
//                return this.title;
//            }
//        }
//
//        String ISearchResultElement.Description
//        {
//            get
//            {
//                return this.description;
//            }
//        }



        // ToString()

        /**
         * ビデオ情報を表示する
         */
        @Override
        public String toString()
        {
            return "Title:" + this.title + "\r\n"
                + "URL:" + this.uri + "\r\n"
            + "Author:" + this.author + "\r\n"
            + "CommentNum:" + this.comment_count + "\r\n"
            + "Date:" + this.date + "\r\n"
            + "Description:" + this.description + "\r\n"
            + "id:" + this.id + "\r\n"
            + "length:" + this.length_seconds + "\r\n"
            + "rating_avg:" + this.rating_avg + "\r\n"
            + "rating_count:" + this.rating_count + "\r\n"
            + "tags:" + this.tags + "\r\n"
            + "thum url:" + this.thumbnail_url + "\r\n"
            + "view_Count:" + this.view_count;
        }



        // IVideoElement メンバ

        public int getDuration()
        {
        	return this.length_seconds;
        }

//        public String getThumbnailURL()
//        {
//        	return this.thumbnail_url;
//        }



        // ISerializable メンバ

//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("title", this.title);
//            info.AddValue("url", this.uri);
//            info.AddValue("author", this.author);
//            info.AddValue("tags", this.tags);
//            info.AddValue("id", this.id);
//            info.AddValue("length_seconds", this.length_seconds);
//            info.AddValue("rating_count", this.rating_count);
//            info.AddValue("rating_avg", this.rating_avg);
//            info.AddValue("thumbnail_url", this.thumbnail_url);
//            info.AddValue("date", this.date);
//            info.AddValue("description", this.description);
//            info.AddValue("view_count", this.view_count);
//            info.AddValue("comment_count", this.comment_count);
//        }
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected YouTubeElement(SerializationInfo info, StreamingContext context)
//        {
//            this.title = info.GetString("title");
//            this.uri = info.GetString("url");
//            this.author = info.GetString("author");
//            this.tags = info.GetString("tags");
//            this.id = info.GetString("id");
//            this.length_seconds = info.GetInt32("length_seconds");
//            this.rating_avg = info.GetDouble("rating_avg");
//            this.rating_count = info.GetInt32("rating_count");
//            this.thumbnail_url = info.GetString("thumbnail_url");
//            this.date = info.GetDateTime("date");
//            this.description = info.GetString("description");
//            this.view_count = info.GetInt32("view_count");
//            this.comment_count = info.GetInt32("comment_count");
//        }
//
//        //#endregion
    }
