//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Runtime.Serialization;

package slothLib.web.search;

import java.io.Serializable;

    /**
     * GoogleAPIの検索結果を格納するクラス
     */
    
    public class GoogleSOAPSearchAPIResult implements IWebSearchResult, Serializable
    {
        
        // privateフィールド

        private String query;
        long totalNumber;
        GoogleSOAPElement[] resultElements;



        // コンストラクタ

        /**
         * コンストラクタ
         * @param query 検索クエリ
		 * @param totalNumber 検索HIT数
         * @param resultElements 検索結果要素の配列
         */
        public GoogleSOAPSearchAPIResult(String query, long totalNumber, GoogleSOAPElement[] resultElements)
        {
            this.query = query;
            this.totalNumber = totalNumber;
            this.resultElements = resultElements;
        }




        // プロパティ

        /**
         * 検索に使われたクエリ
         */
        public String getQuery()
        {
        	return this.query;
        }

        /**
         * 検索HIT数
         */
        public long getTotalNumber()
        {
            return this.totalNumber;
        }

        /**
         * 検索結果要素の配列
         */
        public GoogleSOAPElement[] getResultElements()
        {
            return this.resultElements; 
        }



        // ISerializable メンバ

//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        public void GetObjectData(SerializationInfo info, StreamingContext context)
//        {
//            info.AddValue("query", this.query);
//            info.AddValue("totalNumber", this.totalNumber);
//            info.AddValue("resultElements", this.resultElements);
//        }
//
//        /// <summary>
//		/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//		/// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//        protected GoogleSOAPSearchAPIResult(SerializationInfo info, StreamingContext context)
//        {
//            this.query = info.GetString("query");
//            this.totalNumber = info.GetInt64("totalNumber");
//            this.resultElements = (GoogleSOAPElement[])info.GetValue("resultElements", typeof(GoogleSOAPElement[]));
//        }
//
//        //#endregion        

        // IWebSearchResult メンバ

//        /// <summary>
//        /// 
//        /// </summary>
//        IWebElement[] IWebSearchResult.ResultElements
//        {
//            get { return this.resultElements; }
//        }



        // ISearchResult メンバ

        /**
         * 検索結果要素の配列
         */
//        ISearchResultElement[] ISearchResult.ResultElements
//        {
//            get { return this.resultElements; }
//        }
//
//        /// <summary>
//        /// 総検索数
//        /// </summary>
//        long ISearchResult.TotalNumber
//        {
//            get { return this.totalNumber; }
//        }


    }

