package slothLib.linearAlgebra.matrix;

/**
 * 要素の値の総和が1になるように正規化
 * Value = Value / Sum
 */

public class SubNormMatrix extends BasicMatrix {

	public SubNormMatrix(IMatrix matrix)
    {
        super(matrix.rowCount(), matrix.columnCount());
        double sum = MatrixOperator.getAllElementSum(matrix);

    	for (int i = 0; i < matrix.rowCount(); i++)
        {
        	for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (sum != 0.0)
                {
                	set(i, j, matrix.get(i, j) / sum);
                }
                else
                {
                	set(i, j, 0.0); //was default(double);
                }
            }
        }
    }

}
