package slothLib.linearAlgebra.featureVector;

import java.util.Collection;

public class MultiplyVector <T> extends BasicVector <T> {
	
	public MultiplyVector(Collection<IVector <T> > vectors){
		this(1.0, vectors);
	}

	public MultiplyVector(IVector <T> ...vectors ){
		this(1.0, vectors);
	}

	public MultiplyVector(double multiplyValue, Collection<IVector <T> > vectors){
		if (vectors.size() == 0)
			return;
		initialize(multiplyValue, vectors.iterator().next()); // select the first one
		for (IVector<T> vector: vectors)
			calculate(vector);
	}

	public MultiplyVector(double multiplyValue, IVector <T> ...vectors ){
		if (vectors.length == 0)
			return;
		initialize(multiplyValue, vectors[0]);
		for (IVector<T> vector: vectors)
			calculate(vector);
	}

	private void initialize(double multiplyValue, IVector <T> vector ){
		for (T key: vector.keys())
			this.set(key, multiplyValue);
	}

	private void calculate(IVector<T> vector){
		for (T key: this.keys())
			this.set(key, this.get(key) * vector.get(key));
	}
	

}
