package slothLib.linearAlgebra.featureVector;

import java.util.Collection;

public class InverseDFVector<T> 
extends BasicVector<T> implements IDocumentFrequencyVector<T>{
	private int _vectorCount = 0; 		
	
	public InverseDFVector() {
		// 
	}

	public InverseDFVector(double baseValue, double addValue, IDocumentFrequencyVector<T> dfVector)
    {
        calculate(baseValue, addValue, dfVector);
    }

    public InverseDFVector(double baseValue, double addValue, Collection<IVector<T>> vectors)
    {
        calculate(baseValue, addValue, vectors);
    }

    public InverseDFVector(IDocumentFrequencyVector<T> dfVector) {
        this(2.0, 1.0, dfVector);
    }


    public InverseDFVector(Collection<IVector<T>> vectors){
    	this(2.0, 1.0, vectors);
    }

            
    private void calculate(double baseValue, double addValue, Collection<IVector<T>> vectors) {
    
    	calculate(baseValue, addValue, new DocumentFrequencyVector<T>(vectors));
    }

    private void calculate(double baseValue, double addValue, IDocumentFrequencyVector<T> dfVector) {
    	for (T key: dfVector.keys()){
    		// in java.lang.Math log(a, b) is not supported.
    		// instead, log(a) / log(b) is used. 
    		double val = Math.log(dfVector.vectorCount() / dfVector.get(key) + addValue) / Math.log(baseValue);  		
    		this.set(key, val);
    	}
    	this._vectorCount = dfVector.vectorCount();
    }

            
	public int vectorCount() {
		return _vectorCount;
	}
	
	
}
