package slothLib.linearAlgebra.featureVector;

import java.util.Collection;

public class DocumentFrequencyVector<T> extends BasicVector<T> implements
		IDocumentFrequencyVector<T> {

	private int _vectorCount;
	
	
	public int vectorCount() {
		return _vectorCount;
	}

    public DocumentFrequencyVector(Collection<IVector <T> > vectors){
    	int i = 0;
    	for (IVector<T> vector: vectors){    	
    		calculate(vector);
    	    i++;
    	}
    	_vectorCount = i;
    }

    public DocumentFrequencyVector(IVector <T> ...vectors ){
    	int i = 0;
    	for (IVector<T> vector: vectors){    	
    		calculate(vector);
    	    i++;
    	}
    	_vectorCount = i;
    }

    private void calculate(IVector<T> v){
    	for (T key: v.keys()) {
    		if (v.get(key) != 0) {
    			if (this.containsKey(key)) 
    				this.set(key, this.get(key) + 1);
    			else
    				this.set(key, 1);

            }
        }
    }


	
}
