package slothLib.linearAlgebra.featureVector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;


public class BasicVector<T> extends AbstractVector<T>{
	private Map<T, Double> dic = null;
	
	public BasicVector(){
		dic = new HashMap<T, Double>();  
	}

	public BasicVector(IVector<T> vector){
		this();
		for (T key: vector.keys())
			dic.put(key, vector.get(key));
	}

	public BasicVector(Map<T, Double> dictionary){
		this();
		for (T key: dictionary.keySet())
			dic.put(key, dictionary.get(key));
	}
	
	public double get(T e) {
		if (dic.containsKey(e))
			return dic.get(e);
		else
			return 0.0;
	}

	public void set(T e, double val) {
		dic.put(e, val);
		
		// what is this ? i'm not sure this makes sense in java
		if (val == 0)  
			dic.remove(e);
	}

	@Override
	public Object clone() {
		return new BasicVector<T>(this);
	}

	public int dimension(){
		return dic.size();
	}
	
	@Override
	public double[] getPlainVector() {
		double [] r = new double[this.dimension()]; 
		int i = 0; 
		for (T key: this.keys())
			r[i++] = this.get(key);
		return null;
	}

	public boolean containsKey(T key) {
		return dic.containsKey(key);
	}

	public Set<T> keys() {
		return dic.keySet();
	}
	
	public List<T> keyList() {
		return new ArrayList<T>(keys());
	}

	public List<T> getSortedKeyList() {
		List<T> keyList = keyList();
		Collections.sort(keyList, new VectorComparer<T>(this));
		return keyList;
	}

	

	
}
