package slothLib.NLP;

/**
 * 品詞情報が付加された語のクラス
 */
public class PosTaggedWord implements IPosTaggedWord
{
	
	private String pos;
	private String raw;
	
	/**
	 * コンストラクタ
	 * @param pos 品詞
	 * @param raw 出現形
	 */
	public PosTaggedWord(String pos, String raw)
	{
		this.pos = pos;
		this.raw = raw;
	}
	
	/**
	 * 品詞
	 */
	public String getPOS()
	{
		return this.pos;
	}
	
	/**
	 * 出現形
	 */
	public String getRaw()
	{
		return this.raw;
	}
	
	/**
	 * "[Raw](出現形)\t[POS](品詞)"の形の文字列を返す
	 * @return 
	 */
	public String toString()
	{
		return "[Raw]" + this.getRaw() + "\t[POS]" + this.getPOS() ;
	}

}
