package slothLib.NLP;

import java.util.List;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 半角の英語、数字、記号のみを切り出すクラス。
 * 日本語などは全て無視される。
 */
public class EnglishTokenizer implements ITokenizer
{
	
	private static final Pattern regexTarget = Pattern.compile("[A-Za-z]+('[A-Za-z]*)?|[0-9]+(,[0-9]+)*(\\.[0-9]+)?|[!\"\"#$%&'()*+,-\\./:;<=>?@\\[\\\\\\]^_`{|}~]");

	
	/**
	 * 英単語ごとに切り出す。
	 * @param text 
	 * @return 
	 */
	public String[] doTokenize(String text)
	{
		List<String> result = new ArrayList<String>();
		
		Matcher matcher = regexTarget.matcher(text);
		
		// 語の切り出し
		while (matcher.find()){
			String token = matcher.group();
			// 結果のリスト作成
			result.add(token);
		}
		
		// 結果
		return (String[])(result.toArray(new String[0]));
	}

}	