package slothLib.NLP;

import java.util.Collection;
import java.util.List;
import java.util.ArrayList;
/// <summary>
/// 文字列に対するフィルタのリスト
/// </summary>
public class StringFilterList extends AbstractStringFilter
{
	private List<IStringFilter> StringFilterList;
	
	/// <summary>
	/// コンストラクタ
	/// </summary>
	public StringFilterList()
	{
		this.StringFilterList = new ArrayList<IStringFilter>();
	}
	
	/// <summary>
	/// コンストラクタ
	/// </summary>
	/// <param name="StringFilters">もととなるIStringFilterのIterable</param>
	public StringFilterList(Collection<IStringFilter> StringFilters)
	{
		this.StringFilterList = new ArrayList<IStringFilter>(StringFilters);
	}
	
	/// <summary>
	/// フィルタを追加する
	/// </summary>
	/// <param name="StringFilter">追加するIStringFilter</param>
	public void add(IStringFilter StringFilter)
	{
		this.StringFilterList.add(StringFilter);
	}
	
	/// <summary>
	/// フィルタを適用する
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	public String doFilter(String str)
	{
		for (IStringFilter filter: this.StringFilterList)
		{
			str = filter.doFilter(str);
		}
		return str;
	}
}

