package slothLib.NLP;

import java.util.List;
import java.util.ArrayList;
import java.util.regex.*;


	/**
	 * 茶筌の出力結果。
	 * <remarks>
	 * 

	 * [TODO]EOSごとの結果を求めるのは、メソッドが呼び出されたときにやればいいのではないか。
	 * MeCabのように。て、こんなこと書く間にやれという話ですね。はい。
	 * <newpara>[2007-04-21][ohshima]作成</newpara>
	 * </remarks>
	 */
	public class ChaSenResult implements IMorphologicalAnalyzerResult
	{

        private  List<ChaSenMorpheme> morphemeList;

		// / <summary>
		// / 茶筌の生の結果
		// / </summary>
		private String rawResult;

		// / <summary>
		// / EOSごとの結果
		// / </summary>
		private List<ChaSenResult> sequenceResults;


        // GetOriginalArray()等を実装するためのフィルタ
        private static RemainOriginalFilter remainOriginalFilter = new RemainOriginalFilter();
        private static RemainPosFilter remainPosFilter = new RemainPosFilter();
        private static RemainRawFilter remainRawFilter = new RemainRawFilter();


		// / <summary>
		// / 茶筌の-fオプションの出力にマッチする正規表現
		// / </summary>
		private static Pattern regexResultLine = Pattern.compile("^(.*)\\t(.*)\\t(.*)\\t(.*)\\t(.*)\\t(.*)$");

        // / <summary>
        // / コンストラクタ
        // / </summary>
        // / <param name="rawResult">ChaSenが出力する生の結果</param>
		public ChaSenResult(String rawResult)
		{
            this.morphemeList = new ArrayList<ChaSenMorpheme>();

			this.rawResult = rawResult;
			this.sequenceResults = new ArrayList<ChaSenResult>();

			// それを一行ごとに切り分ける。
			String [] resultList = rawResult.split("\\n");

			// EOSごとの結果を一時的に持っておくための変数。
			StringBuffer sequenceRawResult = new StringBuffer();
			List<ChaSenMorpheme> sequenceMorphemes = new ArrayList<ChaSenMorpheme>();


			// 一行ごとに見ていく。
			for (String line: resultList)
			{
				Matcher match = regexResultLine.matcher(line);
				if (match.matches())
				{
					String raw = match.group(1).toString();
					String reading = match.group(2).toString();
					String original = match.group(3).toString();
					String pos = match.group(4).toString();
					String conjugationPattern = match.group(5).toString();
					String conjugationForm = match.group(6).toString();

					ChaSenMorpheme morpheme = new ChaSenMorpheme(raw, reading, original, pos, conjugationPattern, conjugationForm);

					this.morphemeList.add(morpheme);

					// EOSごとの結果取得用
					sequenceRawResult.append(line + "\r\n");
					sequenceMorphemes.add(morpheme);
				}
				else
				{
					if (line == "EOS")
					{
						this.sequenceResults.add(new ChaSenResult(sequenceRawResult.toString(), sequenceMorphemes));

						// EOSごとの結果取得用
						sequenceRawResult = new StringBuffer();
						sequenceMorphemes = new ArrayList<ChaSenMorpheme>();
					}
				}
			}

		}


		private ChaSenResult(String rawResult, List<ChaSenMorpheme> sequenceMorphemes)
		{
            this.morphemeList = new ArrayList<ChaSenMorpheme>();

			this.rawResult = rawResult;
			for (ChaSenMorpheme morpheme: sequenceMorphemes)
			{
				this.morphemeList.add(morpheme);
			}
		}

		// / <summary>
		// / 茶筌が出力した生の結果。
		// / </summary>
		public String getRawResult()
		{
            return this.rawResult; 
		}

        // / <summary>
        // / EOSごとの結果の数
        // / </summary>
		public int getSequenceCount()
		{
            return this.sequenceResults.size(); 
		}

        // / <summary>
        // / EOSごとに結果を分けて返す
        // / </summary>
        // / <returns>EOSごとに分けられたChaSenResultの配列</returns>
		public ChaSenResult[] getSequenceResults()
		{
            return this.sequenceResults.toArray(new ChaSenResult[0]);
		}

        // / <summary>
        // / インデクサ
        // / </summary>
        // / <param name="index">形態素の番号</param>
        // / <returns>index番目の形態素</returns>
		public ChaSenMorpheme get(int index)
		{
            return (ChaSenMorpheme)this.morphemeList.get(index); 
		}

        // / <summary>
        // / 格納する形態素の配列
        // / </summary>
        public ChaSenMorpheme[] getMorphemes()
        {
        	return this.morphemeList.toArray(new ChaSenMorpheme[0]);
        }



        // #region IMorphologicalAnalyzerResult メンバ

//        IMorpheme[] IMorphologicalAnalyzerResult.Morphemes
//        {
//            get
//            {
//                return this.morphemeList.ToArray();
//            }
//        }

        // / <summary>
        // / 各形態素のRawを配列にして返す
        // / </summary>
        // / <returns>Rawの配列</returns>
        public String[] getRawArray()
        {
            return remainRawFilter.doFilter(this.getMorphemes());
        }

        // / <summary>
        // / 各形態素のOriginalを配列にして返す
        // / </summary>
        // / <returns>Originalの配列</returns>
        public String[] getOriginalArray()
        {
            return remainOriginalFilter.doFilter(this.getMorphemes());
        }

        // / <summary>
        // / 各形態素のPOSを配列にして返す
        // / </summary>
        // / <returns>POSの配列</returns>
        public String[] getPOSArray()
        {
            return remainPosFilter.doFilter(this.getMorphemes());
        }

        // #endregion
    }

