package slothLib.io;

import java.util.ArrayList;
import java.util.List;

import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;


/**
 * 様々な形式の文書の内容のみを読み込む。
 */
	public class MultiReader implements IContentReader
	{
		static {slothLib.SlothLib.init();}
		
		
		private List<IContentReader> readers;
//		private PdftotextHtmlReader pdftotextHtmlReader;



		/**
		 * コンストラクタ
		 */
		public MultiReader()
		throws SlothLibException
        {
			this.readers = new ArrayList<IContentReader>();
			readers.add(new TextReader());

			IContentReader reader;

			if ((reader = createXdoc2TxtReader()) != null)
				readers.add(reader);
			if ((reader = createPdfReader()) != null)
				readers.add(reader);
			if ((reader = createHtmlReader()) != null)
				readers.add(reader);
			if ((reader = createDocReader()) != null)
				readers.add(reader);
			if ((reader = createXlsReader()) != null)
				readers.add(reader);
			if ((reader = createPptReader()) != null)
				readers.add(reader);
			
			//			readers.add(new PdftotextReader());
        }

				

        /**
         * 内容のテキストの読み込み
         * @param filePath 
         * @return 
         */
        public String read(String filePath) throws SlothLibException
        {
            // ファイルの有無をチェック
            if (!PortUtil.fileExists(filePath))
            {
                throw new SlothLibException("ファイルが存在しません。");
            }

            // 拡張子を"."付きで小文字で取得
            String fileExt = filePath.substring(filePath.lastIndexOf(".")).toLowerCase();


            for (IContentReader reader: readers) 
            {  
            	if (reader.isReadable(fileExt))
            	{
            		return reader.read(filePath);
            	}
            }
            
            // テキストファイル
//            if (fileExt.equals(".txt"))
            //{
//            	return (new TextReader()).read(filePath);
            //}
            
//            // htm または html
//            if (fileExt.equals(".htm") || fileExt.equals(".html"))
//            {
//            	return this.pdftotextHtmlReader.read(filePath);
//            }
            
            // Pdftotext（htm以外）
//            if (this.pdftotextReader.isReadable(fileExt))
            //{
//            	return this.pdftotextReader.read(filePath);
            //}
            throw new SlothLibException(fileExt + "cannot be handled with MultiReader");
        }

		/**
		 * 

		 * @param extension 
		 * @return 
		 */
		public boolean isReadable(String extension)
		{
            for (IContentReader reader: readers) 
            {  
            	if (reader.isReadable(extension))
            	{
            		return true;
            	}
            }
            return false;
		}

		/*
		 * versatile reader xdoc2txt
		 */
		
		private static String XDOC2TXT_TAG = "slothlib.xdoc2txt.path";
		private static String XDOC2TXT_DEFAULT = "C:\\Program Files\\xdoc2txt\\xdoc2txt.exe";
		
		static private IContentReader createXdoc2TxtReader(){ 
			GenericContentReader reader = new GenericContentReader(".pdf", ".html", ".htm", ".doc", ".xls", ".ppt"); 
			String cmd = System.getProperty(XDOC2TXT_TAG, XDOC2TXT_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;
			
			reader.addCommand(	cmd, GenericContentReader.placeHolder, "-");
			reader.setFileterMode(false);
			return reader;
		}			

		
		
		/*
		 *  PDF reader with pdftotext
		 */
		
		
		private static String PDFTOTEXTREADER_TAG = "slothlib.pdftotext.path";
		private static String PDFTOTEXT_DEFAULT = "/usr/bin/pdftotext";
		
		static private IContentReader createPdfReader(){ 
			GenericContentReader reader = new GenericContentReader(".pdf"); 
			String cmd = System.getProperty(PDFTOTEXTREADER_TAG, PDFTOTEXT_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;
			
			reader.addCommand(	cmd, GenericContentReader.placeHolder, "-");
			reader.setFileterMode(false);
			return reader;
		}			

		
		/*
		 *  HTML reader with w3m 
		 */
		
		private static String W3M_PROP_TAG = "slothlib.w3m.path";
		private static String W3M_DEFAULT = "/usr/bin/w3m";
		
		static private IContentReader createHtmlReader(){ 
			GenericContentReader reader = new GenericContentReader(".html", ".htm"); 
			String cmd = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;
			
			reader.addCommand(	cmd, "-T", "text/html", "-dump", GenericContentReader.placeHolder);
			reader.setFileterMode(false);
			return reader;
		}			

		/*
		 *  WORD DOC reader with wvText
		 */

		private static String WVTEXT_PROP_TAG = "slothlib.wvText.path";
		private static String WVTEXT_DEFAULT = "/usr/bin/wvText";
		
		static private IContentReader createDocReader(){ 
			GenericContentReader reader = new GenericContentReader(".doc");
			String cmd = System.getProperty(WVTEXT_PROP_TAG, WVTEXT_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;
			
			reader.addCommand(	cmd, GenericContentReader.placeHolder, GenericContentReader.outputHolder);
			reader.setFileterMode(false);
			return reader;
		}			
		
		/*
		 *  EXCEL Reader with xlhtml 
		 */
		
		private static String XLHTML_PROP_TAG = "slothlib.xlhtml.path";
		private static String XLHTML_DEFAULT = "/usr/bin/xlhtml";
		
		static private IContentReader createXlsReader(){ 
			GenericContentReader reader = new GenericContentReader(".xls");
			String cmd = System.getProperty(XLHTML_PROP_TAG, XLHTML_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;

			String cmd2 = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);
			if (!PortUtil.fileExists(cmd2))
				return null;

			reader.addCommand(	cmd, GenericContentReader.placeHolder);
			reader.addCommand(	cmd2, "-T", "text/html", "-dump");
			reader.setFileterMode(false);
			return reader;
		}			

		/*
		 *  Powerpoint Reader with xlhtml 
		 */
		
		private static String PPTHTML_PROP_TAG = "slothlib.ppthtml.path";
		private static String PPTHTML_DEFAULT = "/usr/bin/ppthtml";
		
		static private IContentReader createPptReader(){ 
			GenericContentReader reader = new GenericContentReader(".ppt");
			String cmd = System.getProperty(PPTHTML_PROP_TAG, PPTHTML_DEFAULT);
			if (!PortUtil.fileExists(cmd))
				return null;

			String cmd2 = System.getProperty(W3M_PROP_TAG, W3M_DEFAULT);	
			if (!PortUtil.fileExists(cmd2))
				return null;

			reader.addCommand(	cmd, GenericContentReader.placeHolder);
			reader.addCommand(	cmd2, "-T", "text/html", "-dump");
			reader.setFileterMode(false);
			return reader;
		}			
	
		
		
		
	
	}

