//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.IO;

package slothLib.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;
import slothLib.portUtil.ProcessPipe;
	/**
	 * pdftotextを使ってpdfファイルから内容を取得する
	 */
	public class GenericContentReader extends AbstractContentReader
	{
		static final String placeHolder =  "__FILE__";
		static final String outputHolder = "__OUTPUT__";
		
		private String encoding;

		List<String []> commandLists = new ArrayList<String []>();
		boolean filterMode;

		/**
		 * コンストラクタ
		 */
		public GenericContentReader(String ... extensions) 
		{
			super(extensions);
			encoding = slothLib.SlothLib.getDefaultEncoding();
		
		}

		public void addCommand(String ... command){
			this.commandLists.add(command);
		}

		public void setFileterMode(boolean filterMode){
			this.filterMode = filterMode;
		}

		public void setEncoding(String encoding){
			this.encoding = encoding;
		}
		
		static private String [] replace(String [] commandLine, String filePath, String outfile){
			String [] tmp = (String[])commandLine.clone();
			for (int i = 0; i < tmp.length; i++) 
				if (tmp[i].equals(placeHolder))
					tmp[i] = filePath;
				else if (tmp[i].equals(outputHolder))
					tmp[i] = outfile;
			return tmp;
		}

		private boolean checkOutputHolder() {
			for (String [] commandList: commandLists)
				for (String str: commandList)
					if (str.equals(outputHolder))
						return true;
			return false;
		}
		
		
		/**
		 * ファイルからテキストを抽出する。
		 * 対応しているかどうかはReadableを用いる。
		 * @param filePath ファイルのパス
		 * @return 抽出された内容
		 */
		protected String process(String filePath) throws SlothLibException
		{
			ProcessPipe pipe = null;
			String outputFile = null;
			try {
				pipe = new ProcessPipe();
				boolean outputFileUsed = checkOutputHolder();
				if (outputFileUsed) {
					File f = File.createTempFile("slothlib", "out");
					outputFile = f.getAbsolutePath();
					pipe.setResultFileName(outputFile);
				}
					
				for (String [] commandList: commandLists)
					pipe.add(replace(commandList, filePath, outputFile));
				if (filterMode) 
				{
					pipe.start(filePath);
				}
				else
				{
					pipe.start();
				}
				String output = null;
				
				// have to start reading so that the process can write the results
				if (!outputFileUsed)
					output = PortUtil.readFully(pipe.getInputStream(), encoding);
				while (true) {
					try {
						pipe.waitFor();
						break;
					} catch (InterruptedException e){}
				}
				
				// have to wait for the process to be done to make sure the
				// results are complete.
				if (outputFileUsed)
					output = PortUtil.readFully(pipe.getInputStream(), encoding);
				int ec = pipe.exitValue();			
				
				if (ec != 0)
				{
					System.err.println(PortUtil.readFully(pipe.getErrorStream(), encoding));
					throw new SlothLibException("pipeの実行時にエラーが起こりました。");
				}
				return output;

			} catch (IOException e){
				throw new SlothLibException(e);
			} finally {			
				pipe.destroy();
				if (outputFile != null)
					(new File(outputFile)).delete();
			}
			
		}


	}

