using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.Web.Search;

using SlothLib.Web.Search.com.msn.search.soap;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// LiveSearchsNX
    /// http://msdn2.microsoft.com/en-us/library/bb266180.aspx
    /// </summary>
    public class LiveWebSearch : IWebSearch
    {

        #region privatetB[h

        private string appID;
        private SearchFlags searchFlags = SearchFlags.None;
        private SafeSearchOptions safeSearchOptions = SafeSearchOptions.Moderate;
        private Language language = Language.Japanese;
        private string fileType = "";

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="appID">AvP[VID</param>
        public LiveWebSearch(string appID)
        {
            this.appID = appID;
        }

        #endregion

        #region public\bh

        /// <summary>
        /// LiveSearchs
        /// </summary>
        /// <param name="query">NG[</param>
        /// <param name="resultNum">ʑ</param>
        /// <returns>LiveWebSearch^̌</returns>
        public LiveWebSearchResult DoSearch(string query, int resultNum)
        {
            return this.DoSearchOver(query, resultNum);
        }

        #region IWebSearch o

        IWebSearchResult IWebSearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion

        #region ISearch o

        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query, resultNum);
        }

        #endregion

        #endregion

        #region private֐

        private LiveWebSearchResult DoSearchOriginal(string query, int resultNum, int offset, int trueResultNum)
        {
            MSNSearchService searchSeavice = new MSNSearchService();
            SearchRequest searchRequest = new SearchRequest();

            searchRequest.AppID = appID;


            //錾̎w
            switch (language)
            {
                case Language.Japanese:
                    searchRequest.CultureInfo = "ja-JP";
                    break;
                case Language.English:
                    searchRequest.CultureInfo = "en-US";
                    break;
            }

            searchRequest.Query = query;

            switch (this.safeSearchOptions)
            {
                case SafeSearchOptions.Moderate:
                    searchRequest.SafeSearch = SlothLib.Web.Search.com.msn.search.soap.SafeSearchOptions.Moderate;
                    break;
                case SafeSearchOptions.Strict:
                    searchRequest.SafeSearch = SlothLib.Web.Search.com.msn.search.soap.SafeSearchOptions.Strict;
                    break;
                case SafeSearchOptions.None:
                    searchRequest.SafeSearch = SlothLib.Web.Search.com.msn.search.soap.SafeSearchOptions.Off;
                    break;
            }

            switch (this.searchFlags)
            {
                case SearchFlags.DisableHostCollapsing:
                    searchRequest.Flags = SlothLib.Web.Search.com.msn.search.soap.SearchFlags.DisableHostCollapsing;
                    break;
                case SearchFlags.MarkQueryWords:
                    searchRequest.Flags = SlothLib.Web.Search.com.msn.search.soap.SearchFlags.MarkQueryWords;
                    break;
                case SearchFlags.None:
                    searchRequest.Flags = SlothLib.Web.Search.com.msn.search.soap.SearchFlags.None;
                    break;
            }


            int arraySize = 1;
            SourceRequest[] sourceRequests = new SourceRequest[arraySize];

            sourceRequests[0] = new SourceRequest();
            sourceRequests[0].Count = 25;
            sourceRequests[0].Offset = 0;
            sourceRequests[0].Offset = offset;
            sourceRequests[0].ResultFields = ResultFieldMask.All;
            sourceRequests[0].Source = SourceType.Web;
            if (!string.IsNullOrEmpty(fileType))
            {
                sourceRequests[0].FileType = fileType;
            }

            searchRequest.Requests = sourceRequests;

            //ʂ̎擾Jn
            SearchResponse searchResponse = searchSeavice.Search(searchRequest);

            long totalNumber = 0;
            List<LiveWebElement> resultElements = new List<LiveWebElement>();
            int rank = offset + 1;
            foreach (SourceResponse response in searchResponse.Responses)
            {

                    totalNumber = response.Total;

                    int count = 0;
                Result[] elements = response.Results;
                foreach (Result re in elements)
                {
                    LiveWebElement element = new LiveWebElement(SafeGet(re.Title), SafeGet(re.Description), SafeGet(re.Url), SafeGet(re.DisplayUrl), SafeGet(re.CacheUrl), SafeGet(re.SearchTags), rank);
                    rank++;
                    resultElements.Add(element);
                    count++;
                    if(count >= trueResultNum){
                        break;
                    }
                }

            }

            return new LiveWebSearchResult(query, totalNumber, resultElements.ToArray());

        }

        private string SafeGet(string str)
        {
            return string.IsNullOrEmpty(str) ? string.Empty : str;
        }

        private LiveWebSearchResult DoSearchOver(string query, int resultNum)
        {
            int loop = (resultNum - 1) / 25;
            long total = 0;
            List<LiveWebElement> resultElements = new List<LiveWebElement>();
            for (int i = 0; i < loop; i++)
            {
                resultElements.AddRange(DoSearchOriginal(query, 25, 25 * i,25).ResultElements);
            }
            LiveWebSearchResult searchResult = DoSearchOriginal(query, 25, loop * 25,resultNum - (loop * 25));
            total = searchResult.TotalNumber;
            resultElements.AddRange(searchResult.ResultElements);

            return new LiveWebSearchResult(query, total, resultElements.ToArray());

        }

        #endregion

        #region vpeB

        /// <summary>
        /// ɊւtO
        /// </summary>
        public SearchFlags SearchFrag
        {
            get
            {
                return this.searchFlags;
            }
            set
            {
                this.searchFlags = value;
            }
        }

        /// <summary>
        /// LQTCg̃tB^OIvV
        /// </summary>
        public SafeSearchOptions SafeSearchOption
        {
            get
            {
                return this.safeSearchOptions;
            }
            set
            {
                this.safeSearchOptions = value;
            }
        }

        /// <summary>
        /// Ƃ̌
        /// </summary>
        public Language SearchLanguage
        {
            get
            {
                return this.language;
            }
            set
            {
                this.language = value;
            }
        }

        /// <summary>
        /// t@C̎
        /// </summary>
        public string FileType
        {
            get
            {
                return this.fileType;
            }
            set
            {
                this.fileType = value;
            }
        }

        #endregion

        #region 񋓌^

        /// <summary>
        /// ɊւtO
        /// </summary>
        public enum SearchFlags
        {
            /// <summary>
            /// ʂURLɂďW񂳂邱Ƃ𖳌ɂ
            /// </summary>
            DisableHostCollapsing,

            /// <summary>
            /// ʒ̃NG
            /// </summary>
            MarkQueryWords,

            /// <summary>
            /// w肵Ȃ
            /// </summary>
            None,
        }

        /// <summary>
        /// LQTCg̃tB^OIvV
        /// </summary>
        public enum SafeSearchOptions
        {
            /// <summary>
            /// LQȉ摜̂݃tB^Os
            /// </summary>
            Moderate,
            /// <summary>
            /// LQȉ摜ƃeLXg̗̃tB^Os
            /// </summary>
            Strict,
            /// <summary>
            /// tB^OsȂ
            /// </summary>
            None,
        }

        /// <summary>
        /// Ƃ̌
        /// </summary>
        public enum Language
        {
            /// <summary>
            /// {
            /// </summary>
            Japanese,
            /// <summary>
            /// p
            /// </summary>
            English,
        }

        #endregion
    }
}
